#!/usr/bin/env ruby

require 'optparse'
require 'iconv'
require 'xosd'
require 'uim'

$default_font="-*-*-medium-r-normal--SIZE-*-*-*-*-*"

class XosdString
  def initialize(line = 1, config = {})
    @osd = Xosd.new(line)
    @osd.valign = config['valign']
    @osd.align = config['align']
    @osd.font = config['font']
    @osd.timeout = config['timeout'].to_i
    
    @osd.outline_width = 1
    @osd.shadow_offset = 2

  end

  def to_array_32(str)
    dst_array = []
    src_array = `echo -n #{str} | kbanner -l`.split("\n")
    (src_array[0].size-1).downto(0) do |i|
      str = ""
      0.step(src_array.size-1) do |j|
        str += src_array[j][i, 1]
      end
      dst_array.push(str)
    end
    dst_array
  end

  def to_array(str)
    src_array = `echo -n #{str} | kbanner`.split("\n")
    num = src_array.size/16
    dst_array = []
    0.step(15) do |i|
      dst_array[i] = ""
      0.step(num-1) do |j|
        dst_array[i] += src_array[j*16 +i]
      end
    end
    dst_array
  end

  def show(str)
    puts str
    @osd.display(str)
    
#    @osd.wait
#    @osd.clear
  end
end

class XosdKbanner < XosdString
  def show(str)
    array = self.to_array(str)
    0.step(array.size-1) do |i|
      @osd.display(array[i], i)
    end

#    @osd.wait
#    @osd.clear
  end
end

class UIM::Helper::Message
  attr_accessor :type, :charset, :iconic_label, :buttontooltip_string
  attr_accessor :imname, :imlang, :imshort_description

  def initialize(str)
    @charset = nil
    tmp_a = str.split("\n")
    @type = tmp_a.shift
    if tmp_a.empty?
      return
    end
    @charset = tmp_a.shift.split("=")[1]

    case @type
    when 'prop_list_update'
      dummy, dummy2, @im_icon, @imname = tmp_a.shift.split("\t")
      while tmp_a[0] !~ /branch/
        tmp_a.shift
      end
      dummy, dummy2, @iconic_label, @buttontooltip_string =
        tmp_a.shift.split("\t")
    end
  end
end

class UimHelper
  ::Version = 0.1

  def option_parse(arg, config)
    opts = OptionParser.new
    opts.on("--valign (top|middle|bottom)") {|val| config['valign'] = val}
    opts.on("--align (left|center|right)") {|val| config['align'] = val}
    opts.on("--timeout TIMEOUT") {|val| config['timeout'] = val}
    opts.on("--fontsize FONTSIZE") {|val| config['fontsize'] = val}
    opts.on("--font FONTNAME") {|val| config['font'] = val}
    opts.on("-i") {|val| config['show_im'] = true}
    opts.on("-v") {|val| config['verbose'] = true}
    opts.on("-k") {|val| config['kbanner'] = true}
    opts.parse(arg)
    return config
  end

  def initialize(arg)
    @config = Hash.new
    @config['valign'] = 'middle'
    @config['align'] = 'center'
    @config['timeout'] = 1
    @config['fontsize'] = 32
    @config['verbose'] = false
    @config['kbanner'] = false
    @config['show_im'] = false
    @config = self.option_parse(arg, @config)

    if @config['font'] == nil
      @config['font'] = $default_font.sub('SIZE', @config['fontsize'].to_s)
    end
    @uim = UIM::Helper.new
    if @config['kbanner'] == true
      @xosd = XosdKbanner.new(16, @config)
    else
      @xosd = XosdString.new(1, @config)
    end
  end

  def start
    @uim.im_list_get
    @uim.prop_label_get
    im = ""
    loop do
      @uim.read(100) do |str|
        msg = UIM::Helper::Message.new(str)
        case msg.type
        when 'prop_list_update'
          label = Iconv.conv("UTF-8", msg.charset, msg.iconic_label)
          tooltip = Iconv.conv("UTF-8", msg.charset, 
                                msg.buttontooltip_string)
          #      osd.clear
          if @config['verbose'] == true
            show_str = tooltip
          else
            show_str = label
          end
          if @config['show_im'] == true and msg.imname != ""
            show_str += "["+msg.imname+"]"
          end
            @xosd.show(show_str)
        end
      end
    end
  end
end

xosduim = UimHelper.new(ARGV)
xosduim.start
