﻿#pragma once
/** @file
*  @brief MIDI Outputのヘッダーファイル
*/
//#include "midi_message.h"
#include "exception.h"

namespace sf {

//  const int midi_ch_num = 16;
//  const int control_change_num = 2;
//  const int max_control_changes = 128;


  /** デバイスエラー時に投げる例外 */
  struct midi出力エラー : sf::exception 
  {
    midi出力エラー(const boost::uint32_t error) : error_id_(error),exception(get_error_string(error)){}
    const int error_id() const {return error_id_;}
  private:
    const int error_id_;
    const std::wstring get_error_string(boost::uint32_t id);
  };
  
  /** デバイスが存在しない時に投げる例外 */
  struct MIDI出力デバイスが存在しない : sf::exception 
  {
    explicit MIDI出力デバイスが存在しない()  : exception(L"MIDI Input Deviceが見つかりません。"){}
  };

  inline void MIDI出力エラーなら例外送出(const boost::uint32_t error)
  {
    if(MMSYSERR_NOERROR !=  error)
    {
      throw midi出力エラー(error);
    }
  };

  /** MIDI Output Class */
  struct midi出力
  {
    
    /** MIDI IN インターフェース*/
    struct デバイス情報 {
      デバイス情報(const MIDIOUTCAPS2& value,const boost::uint32_t dev_id) :id_(dev_id),名前_(value.szPname),デバイス情報_(value)
      {
      }
      const boost::uint32_t id() const { return id_;}
      const std::wstring& 名前() const  {return 名前_;}
    private:
      const boost::uint32_t id_;
      const std::wstring 名前_;
      MIDIOUTCAPS2 デバイス情報_;
    };

    typedef boost::ptr_vector<デバイス情報> デバイス情報コンテナ型;

    midi出力(boost::uint32_t id);
    virtual ~midi出力();

    //void id(const boost::uint32_t id) { assert(id < デバイス情報.size()); dev_id_ = id;}
    const boost::uint32_t id() {return dev_id_;} 

    const boost::uint32_t デバイス数() {return ::midiOutGetNumDevs();}

    void オープン()
    {
      if(デバイス数() > 0){
        int 結果 = ::midiOutOpen(&hmidiout_,dev_id_,(LONG_PTR)(&midi_out_proc),(DWORD_PTR)this,CALLBACK_FUNCTION);
        assert(結果 == MMSYSERR_NOERROR);
      } else {
        throw MIDI出力デバイスが存在しない();
      }
    }

    void リセット()
    {
      assert(hmidiout_ != NULL);
      boost::uint32_t 結果 = midiOutReset(hmidiout_);
      assert(結果 == MMSYSERR_NOERROR);
      MIDI出力エラーなら例外送出(結果);
    }

    void クローズ()
    {
      if(hmidiout_ == NULL) return;

      boost::uint32_t 結果 = midiOutClose(hmidiout_);
      assert(結果 == MMSYSERR_NOERROR);
      hmidiout_ = NULL;
      MIDI出力エラーなら例外送出(結果);
    }

    static const デバイス情報コンテナ型 & デバイス情報コンテナ(){return デバイス情報コンテナ_;};
    static void CALLBACK midi_out_proc(
      HMIDIOUT HMIDIOUT,  
      boost::uint32_t wMsg,        
      DWORD dwInstance, 
      DWORD dwParam1,   
      DWORD dwParam2    
      ){
        ::OutputDebugStringW(L"output_proc\n");
        //reinterpret_cast<midi出力*>(dwInstance)->MIDIメッセージ到着時(wMsg,dwParam1,dwParam2);
    }
    static void デバイスの列挙();
    HMIDIOUT ハンドル() const {return hmidiout_;}

    /** メッセージ送信 */
    void メッセージ送信(boost::uint32_t メッセージデータ)
    {
      ::midiOutShortMsg(ハンドル(),メッセージデータ);
    }
    /** エクスクルーシブ */
    void  メッセージ送信(const std::vector<boost::uint8_t>& エクスクルーシブデータ)
    {
      BOOST_ASSERT(!エクスクルーシブデータ.empty());
      MIDIHDR ヘッダ;
      ヘッダ.dwBufferLength = エクスクルーシブデータ.size() ? 65536 : 0;
      // TODO: 頑張って実装する。
      ::midiOutLongMsg(ハンドル(),&ヘッダ,sizeof(MIDIHDR));
    }
  private:
    static デバイス情報コンテナ型 デバイス情報コンテナ_;
//    boost::uint32_t control_change_buffer_[midi_ch_num][control_change_num];
    HMIDIOUT hmidiout_;
    boost::uint32_t dev_id_;
  };
}
