﻿/** @file
*  @brief MIDI Input 実装クラス
*/
#include "stdafx.h"
#include "seq_message.h"
#include "midi_input.h"

namespace sf {
  
  midi入力::デバイス情報コンテナ型 midi入力::デバイス情報;

  const std::wstring midi入力エラー::get_error_string(boost::uint32_t id)
  {
    wchar_t buf[MAXCHAR] = {};

    ::midiInGetErrorTextW(id,buf,MAXCHAR);
    return std::wstring(buf);
  }

  /** デバイスを列挙して、情報をコンテナに収める */
  void midi入力::デバイスの列挙()
  {
    const boost::uint32_t num_devs_ = midiInGetNumDevs();
    if(num_devs_ > 0)
    {
      デバイス情報.clear();
      for( boost::uint32_t dev_id_ = 0;dev_id_ < num_devs_;++dev_id_)
      {
        MIDIINCAPS2 caps2_;
        boost::uint32_t 結果 = midiInGetDevCaps(dev_id_,reinterpret_cast<LPMIDIINCAPS>(&caps2_),sizeof(MIDIINCAPS2));
        if(結果 != MMSYSERR_NOERROR)
        {
           throw midi入力エラー(結果);
        } else {
          midi入力::デバイス情報.push_back(new midi入力::caps(caps2_,dev_id_));
        }
      }
    }

  }

  /** コンストラクタ */
  midi入力::midi入力(boost::uint32_t id) 
    : dev_id_(id),hmidiin_(NULL)
  {
    memset(&MIDIバッファ情報_,0,sizeof(MIDIバッファ情報_));
    MIDIバッファ情報_.lpData  = (LPSTR)エクスクルーシブバッファ_;
    MIDIバッファ情報_.dwBufferLength = バッファ容量_;
    オープン();
  }

  /** デストラクタ */
  midi入力::~midi入力()
  {
    リセット();
    受信停止();
    クローズ();
  }

 
 }
