#pragma once


/** @file
 *  @author S.F. (Satoshi Fujiwara)
 *  @brief wchar_t <--> char ̕ϊ[eBeB
 *  ƂĕnہAϊKvȏꍇAL̂悤ɃA_v^IɎgp邱Ƃz肵ĂB
 *  std::wstring a(L"abcd");
 *  std::wstring b((sf::code_converter<wcha_t,char>(a)));
 *
 *@AATLR[hւptypedefpӂĂB
 *  ́AA_v^ƂĂ̗p݂̂Ɍ肳B
 *  sf::ct2a hoge_(L"abcef"); // z肵ĂȂi삷ꍇ邵A_ȏꍇj
 */

namespace sf 
{
    /** ` */
    template <typename SrcChar,typename DestChar>
    struct code_converter
    {
    public:
        explicit code_converter(SrcChar* p);
        explicit code_converter(std::basic_string<SrcChar> & p);
        operator DestChar*();
    };

    /** char -> wchar_tւ̕ϊ */
    template <>
    struct code_converter<char,wchar_t>
    {
        explicit code_converter(const char* p);
        explicit code_converter(const std::string& p);

        operator wchar_t*() const {return m_dest.get();}
    private:
        boost::scoped_array<wchar_t> m_dest;
    };

    /** wchar_t -> char */
    template <>
    struct code_converter<wchar_t,char>
    {
        explicit code_converter(const wchar_t* p);
        explicit code_converter(const std::wstring& p);
        operator char* () const {return m_dest.get();}
    private:
        boost::scoped_array<char> m_dest;
    };

    /** ATLR[hւ̂߂̃GCAX */
    typedef sf::code_converter<char,wchar_t> ca2w;

    /** ATLR[hւ̂߂̃GCAX */
    typedef sf::code_converter<wchar_t,char> cw2a;

    #ifdef _UNICODE

        /** ATLR[hւ̂߂̃GCAX */
        typedef sf::code_converter<char,wchar_t> ca2t;
        /** ATLR[hւ̂߂̃GCAX */
        typedef sf::code_converter<wchar_t,char> ct2a;

        /** ATLR[hւ̂߂̃GCAX */
        inline const wchar_t* ct2w(const wchar_t* p) { return p;};
        /** ATLR[hւ̂߂̃GCAX */
        inline const wchar_t* cw2t(const wchar_t* p) { return p;};

    #else

        /** ATLR[hւ̂߂̃GCAX */
        inline const char* ct2a(const char* p) { return p;};
        /** ATLR[hւ̂߂̃GCAX */
        inline const char* ca2t(const char* p) { return p;};

    #endif
}


