﻿/*
  win32_text.cpp
  base class of screen driver

  Made by Studio Breeze. 2002

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */
#include "stdafx.h"
#include "sted_screen_win32.h"


// private methods

BOOL
CSTedScreenWin32::TextToWindowPos(int in_text_x, int in_text_y, int *out_x, int *out_y)
{
  if (out_x) *out_x = fWindowWidth * in_text_x / fX68TextWidth;
  if (out_y) *out_y = fWindowHeight * in_text_y / fX68TextHeight;
  return TRUE;
}

BOOL
CSTedScreenWin32::TextToWindowPos(int *out_x, int *out_y)
{
  return TextToWindowPos(fCurrentTextX, fCurrentTextY, out_x, out_y);
}

int
CSTedScreenWin32::GetTextWidth(LPCTSTR in_str, int in_len)
{

  if (!in_str) return 0;
  if (in_len <= 0) return 0;

  //u = toUCS2(in_str, in_len, &len);
  IDWriteTextLayoutPtr l;
  write_factory_->CreateTextLayout(in_str,in_len,text_fmt_.Get(),fWindowWidth,fTextLineHeight,&l);
  DWRITE_TEXT_METRICS m;
  l->GetMetrics(&m);

  // Ugh!: should the data be cached ?



  //if (!::GetTextExtentPoint32(fTextDC, in_str, in_len, &size)) return 0;

  return (int)m.widthIncludingTrailingWhitespace;
}

// window
void
CSTedScreenWin32::SetTextWindow(int in_y, int in_h)
{
	if (in_y < 0) in_y = 0;
	if (in_y >= fX68TextHeight) in_y = fX68TextHeight-1;
	if (in_h < 0) in_h = 0;
	if (in_y + in_h >= fX68TextHeight) in_h = fX68TextHeight-in_y;

	fTextOriginY = in_y;
	fTextHeight = in_h;
}

// cursor
void 
CSTedScreenWin32::SetCursor(int in_onoff)
{
  fIsCursorOn = in_onoff;
  DrawCursor();
}

void
CSTedScreenWin32::DrawCursor(void)
{
  if (fIsCursorOn) {
	  TextReverse(fCurrentTextX, fCurrentTextY, 1, 3);
  }
}

// text
void
CSTedScreenWin32::Locate(int in_x, int in_y)
{
  in_y += fTextOriginY;

  if (in_x >= fX68TextWidth) in_x = fX68TextWidth-1;
  if (in_x<0) in_x=0;
  if (in_y >= fTextHeight) in_y = fTextHeight;
  if (in_y<0) in_y = 0;

  fCurrentTextX = in_x;
  fCurrentTextY = in_y;

  DrawCursor();
}

void
CSTedScreenWin32::Puts(const char* in_str)
{
  LPCTSTR u;
  int len;
  int x,y;
  int l;
  RECT r;
  int sx, sy, ey;
  int w,h;
  char* str = (char *)in_str;

  l = (int)strlen(str);
  if(l == 0) return;

  {
  sf::begin_draw<ID2D1BitmapRenderTargetPtr> begin(text_bitmap_target_);

  if (str[0] == '\r')
  {
    l -= 2;
    str += 2;
    fCurrentTextX = 0;
    if (fCurrentTextY < fTextHeight - 1 )
    { 
     fCurrentTextY++;
    } else {
		  sx = 0;
		  w = fWindowWidth;
		  sy = fWindowHeight * (fTextOriginY + 1) / fX68TextHeight;
		  ey = fWindowHeight * fTextOriginY / fX68TextHeight;
		  h = fWindowHeight * (fTextHeight - 1) / fX68TextHeight;
      ID2D1BitmapPtr b;
      THROW_IF_ERR(text_bitmap_target_->GetBitmap(&b));
      D2D1_RECT_F dr = D2D1::RectF(sx,ey,w + sx,h + ey);
      D2D1_RECT_F sr = D2D1::RectF(sx,sy,w + sx,h + sy);
      text_bitmap_target_->DrawBitmap(b.Get(),dr,1.0f,D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,sr);
      //::BitBlt(fTextDC, sx, ey, w, h, fTextDC, sx, sy, SRCCOPY);
		  //::BitBlt(fTextMaskDC, sx, ey, w, h, fTextMaskDC, sx, sy, SRCCOPY);
  	}
  }

  u = toUCS2(str, l, &len);
  if (!u) return;
  if (len == 0) return;

  if (!TextToWindowPos(&x, &y)) return;
  
  IDWriteTextLayoutPtr layout;
  write_factory_->CreateTextLayout(u,len,text_fmt_.Get(),fWindowWidth,fTextLineHeight,&layout);
  DWRITE_TEXT_METRICS m;
  
  layout->GetMetrics(&m);
  text_bitmap_target_->PushAxisAlignedClip(D2D1::RectF(x,y,x + m.widthIncludingTrailingWhitespace,y + m.height),text_bitmap_target_->GetAntialiasMode());
  //text_bitmap_target_->FillRectangle(D2D1::RectF(x,y,x + m.widthIncludingTrailingWhitespace,y + m.height),brush_text_clear_);
  text_bitmap_target_->Clear();
  text_bitmap_target_->PopAxisAlignedClip();
  text_bitmap_target_->DrawTextLayout(D2D1::Point2F(x,y),layout.Get(),brush_text_.Get());
  //text_bitmap_target_->DrawTextW(
  //  u,len,text_fmt_,D2D1::RectF(x,y,x + fWindowWidth ,y + fTextLineHeight),brush_text_);
  //text_bitmap_target_->DrawTextW(
  //  u,len,text_fmt_,D2D1::RectF(0,0,300,300),brushr);

  ////::TextOut(fTextDC, x, y, u, len);
  ////::TextOut(fTextMaskDC, x, y, u, len);
  fCurrentTextX += l;

  ::SetRect(&r, x, y, x +m.widthIncludingTrailingWhitespace, y + m.height);

  }

  InvalidateRect(&r);

  DrawCursor();

  return;
}

void
CSTedScreenWin32::ClsEol(void)
{
  RECT r;
  int x, y;

  if (!TextToWindowPos(&x,&y)) return;

  ::SetRect(&r, 0, y, fWindowWidth, y + fTextLineHeight);
  text_bitmap_target_->BeginDraw();
  text_bitmap_target_->PushAxisAlignedClip(D2D1::RectF(0.0f,y,fWindowWidth,r.bottom),text_bitmap_target_->GetAntialiasMode());
  text_bitmap_target_->Clear();
  text_bitmap_target_->PopAxisAlignedClip();
  text_bitmap_target_->EndDraw();

  //::FillRect(fTextDC, &r, fBrushTextClear);
  //::FillRect(fTextMaskDC, &r, MASK_OFF);

  InvalidateRect(&r);
}

void
CSTedScreenWin32::ClsEd(void)
{
  RECT r;
  int x, y;

  if (!TextToWindowPos(&x,&y)) return;

  ::SetRect(&r, 0, y, fWindowWidth, fWindowHeight);
  text_bitmap_target_->BeginDraw();
  text_bitmap_target_->PushAxisAlignedClip(D2D1::RectF(0,y,fWindowWidth,fWindowHeight),text_bitmap_target_->GetAntialiasMode());
  //text_bitmap_target_->FillRectangle(D2D1::RectF(0,y,fWindowWidth,fWindowHeight),brush_mask_off_);
  text_bitmap_target_->Clear();
  text_bitmap_target_->EndDraw();

 /* ::FillRect(fTextDC, &r, fBrushTextClear);
  ::FillRect(fTextMaskDC, &r, MASK_OFF);*/

  InvalidateRect(&r);
}

void
CSTedScreenWin32::GraphicsPuts(int in_x, int in_y, const char* in_str)
{
  int w, l, c;
  int h;
  int x, y;
  LPCTSTR u;
  int len;
  RECT r;

  c = (in_y >= fX68WindowHeight) ? 1: 0;
  if (!toWindowPos(in_x, in_y % fX68WindowHeight, &x, &y)) return;
  l = (int)strlen(in_str);

  u = toUCS2(in_str, l, &len);
  if (!u || len==0) return;

  w = GetTextWidth(u, len);
  h = fTextLineHeight;
  
  IDWriteTextLayoutPtr layout;
  write_factory_->CreateTextLayout(u,len,text_fmt_.Get(),fWindowWidth,fTextLineHeight,&layout);
  DWRITE_TEXT_METRICS m;
 
  layout->GetMetrics(&m);

  //::TextOut(fGraphicsWindowDC[c], x, y, u, len);
  {
    sf::begin_draw<ID2D1BitmapRenderTargetPtr> begin(graphics_bitmap_target_[c]);
    //graphics_bitmap_target_[c]->PushAxisAlignedClip(D2D1::RectF(x,y,x + m.widthIncludingTrailingWhitespace,y + m.height),graphics_bitmap_target_[c]->GetAntialiasMode());
    ////text_bitmap_target_->FillRectangle(D2D1::RectF(x,y,x + m.widthIncludingTrailingWhitespace,y + m.height),brush_text_clear_);
    //graphics_bitmap_target_[c]->Clear();
    //graphics_bitmap_target_[c]->PopAxisAlignedClip();
    graphics_bitmap_target_[c]->DrawTextLayout(D2D1::Point2F(x,y),layout.Get(),brush_text_.Get());
  }
  //THROW_IF_ERR(begin.end_draw());

  ::SetRect(&r, x, y, x + m.widthIncludingTrailingWhitespace, y + m.height);
  InvalidateRect(&r);

  return;  
}
