﻿/*
 * STed: cm6con.c (cm-64 controler)
 */
#include	"sted.h"

static unsigned char	cm6_info[64]={
  0x43,0x4F,0x4D,0x45,0x20,0x4F,0x4E,0x20,0x4D,0x55,0x53,0x49,0x43,0x00,0x00,0x00,
  0x52,0x20,0x43,0x4D,0x2D,0x36,0x34,0x20,0x20,0x20,0x03,0x00,0x4A,0x00,0x05,0x03,
  0x03,0x0A,0x06,0x04,0x03,0x00,0x00,0x00,0x06,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
  0x08,0x09,0x64,0x01,0x04,0x07,0x00,0x30,0x08,0x01,0x1F,0x07,0x01,0x0E,0x08,0x00};

static unsigned char	la_sys[32]={
  0x4A,0x00,0x05,0x03,0x03,0x0A,0x06,0x04,0x03,0x00,0x00,0x00,0x06,0x01,0x02,0x03,
  0x04,0x05,0x06,0x07,0x08,0x09,0x64,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F};

static unsigned char	pcm_sys[23]={
  0x40,0x01,0x05,0x05,0x02,0x08,0x15,0x00,0x00,0x00,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
  0x64,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F};

static unsigned char	rsetup[85*2]={
  0x7F,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,
  0x7F,0x07,0x7F,0x07,0x7F,0x07,0x40,0x07,0x40,0x07,0x4A,0x06,0x41,0x07,0x4B,0x08,
  0x45,0x06,0x44,0x0B,0x46,0x06,0x44,0x0B,0x5D,0x06,0x43,0x08,0x47,0x06,0x43,0x08,
  0x42,0x03,0x48,0x06,0x42,0x03,0x49,0x08,0x7F,0x07,0x7F,0x07,0x56,0x09,0x7F,0x07,
  0x4C,0x07,0x7F,0x07,0x7F,0x07,0x7F,0x07,0x52,0x02,0x53,0x04,0x4D,0x08,0x4E,0x09,
  0x4F,0x0A,0x50,0x07,0x51,0x05,0x54,0x02,0x55,0x02,0x5B,0x09,0x58,0x04,0x5A,0x09,
  0x59,0x09,0x5C,0x0A,0x7F,0x07,0x57,0x0C,0x5E,0x07,0x5F,0x07,0x60,0x07,0x61,0x07,
  0x62,0x07,0x63,0x07,0x64,0x07,0x65,0x07,0x66,0x07,0x67,0x07,0x68,0x07,0x69,0x07,
  0x6A,0x07,0x6B,0x07,0x6C,0x07,0x6D,0x07,0x6E,0x07,0x6F,0x07,0x70,0x07,0x71,0x07,
  0x72,0x07,0x73,0x07,0x74,0x07,0x75,0x07,0x76,0x07,0x77,0x07,0x78,0x07,0x79,0x07,
  0x7A,0x07,0x7B,0x07,0x7C,0x07,0x7D,0x07,0x7E,0x07};

static unsigned char	pcmpat[64]={
  0x00,0x01,0x02,0x03,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x0F,0x11,0x12,0x14,0x15,0x1A,
  0x1B,0x1C,0x1D,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x2A,0x2B,0x2C,0x2D,
  0x2E,0x2F,0x30,0x31,0x32,0x34,0x36,0x38,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x42,
  0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53};

static unsigned char	la_para[8]={
  0x00,0x00,0x18,0x32,0x0C,0x00,0x01,0x00};

static unsigned char	pcm_para[19]={
  0,0x00,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C};

static unsigned char	la_tmp[144]={
  0x01,0x04,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x07,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x00,0x30,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x08,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x01,0x1F,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x07,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x01,0x0E,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x08,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x00,0x29,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x04,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x00,0x03,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x0A,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x01,0x2E,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x01,0x3A,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x0E,0x00,0x7F,0x00,0x00,0x00,0x00,
  0x00,0x00,0x18,0x32,0x0C,0x00,0x01,0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

static unsigned char	pcm_tmp[126]={
  0,0x28,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x40,0x64,
  0,0x2B,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x51,0x64,
  0,0x00,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x40,0x64,
  0,0x33,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x63,0x64,
  0,0x14,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x1B,0x64,
  0,0x40,0x0C,0x32,0x0C,0,0x7F,0,1,0x0F,0x40,0x40,0x32,0,0,0,2,4,0x0C,0x2D,0x64};

static unsigned char	la_tim_tmp[1968]={
  0x53,0x6C,0x61,0x70,0x20,0x42,0x61,0x73,0x73,0x31,0x05,0x00,0x07,0x00,0x24,0x32,
  0x10,0x01,0x00,0x24,0x00,0x07,0x00,0x00,0x00,0x0F,0x0C,0x12,0x00,0x15,0x23,0x2C,
  0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0x4B,0x50,0x06,0x0F,0x0C,0x00,0x00,0x00,
  0x3C,0x00,0x00,0x1E,0x64,0x00,0x00,0x00,0x24,0x26,0x10,0x01,0x00,0x25,0x00,0x07,
  0x00,0x00,0x00,0x0D,0x0C,0x12,0x00,0x15,0x25,0x2C,0x32,0x32,0x40,0x00,0x38,0x00,
  0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x64,0x4B,0x43,0x04,0x0F,0x0C,0x00,0x00,0x00,0x3B,0x4E,0x64,0x1E,0x64,0x50,
  0x37,0x00,0x24,0x37,0x10,0x01,0x01,0x00,0x26,0x07,0x04,0x00,0x00,0x0C,0x0C,0x0C,
  0x00,0x1B,0x27,0x2F,0x32,0x32,0x37,0x19,0x26,0x28,0x14,0x07,0x2E,0x07,0x64,0x19,
  0x00,0x00,0x00,0x2D,0x50,0x5E,0x1C,0x64,0x55,0x30,0x1A,0x50,0x4B,0x5B,0x0C,0x0F,
  0x0C,0x00,0x00,0x00,0x3B,0x3B,0x64,0x1E,0x64,0x50,0x37,0x00,0x24,0x37,0x10,0x01,
  0x01,0x00,0x26,0x07,0x04,0x00,0x00,0x0C,0x0C,0x0C,0x00,0x1B,0x27,0x2F,0x32,0x32,
  0x37,0x19,0x26,0x28,0x14,0x07,0x2E,0x07,0x64,0x19,0x00,0x00,0x00,0x2D,0x50,0x5E,
  0x1C,0x64,0x55,0x30,0x1A,0x50,0x4B,0x5B,0x0C,0x0F,0x0C,0x00,0x00,0x00,0x3B,0x3B,
  0x64,0x1E,0x64,0x50,0x37,0x00,0x53,0x74,0x72,0x20,0x53,0x65,0x63,0x74,0x20,0x31,
  0x07,0x05,0x0F,0x00,0x24,0x2B,0x10,0x01,0x00,0x00,0x59,0x07,0x07,0x01,0x03,0x07,
  0x0F,0x18,0x00,0x30,0x63,0x29,0x32,0x32,0x43,0x1C,0x2E,0x4B,0x00,0x09,0x1B,0x0A,
  0x1E,0x14,0x00,0x00,0x10,0x18,0x18,0x50,0x58,0x64,0x60,0x5A,0x12,0x46,0x50,0x5B,
  0x0C,0x1B,0x0C,0x04,0x01,0x10,0x0A,0x12,0x18,0x3C,0x38,0x50,0x60,0x64,0x24,0x39,
  0x10,0x01,0x00,0x00,0x50,0x07,0x07,0x01,0x04,0x06,0x11,0x09,0x00,0x31,0x64,0x2B,
  0x32,0x32,0x3F,0x1C,0x29,0x55,0x00,0x09,0x27,0x0A,0x0F,0x14,0x00,0x00,0x12,0x20,
  0x1C,0x59,0x58,0x55,0x44,0x1A,0x12,0x46,0x50,0x70,0x09,0x5B,0x0C,0x04,0x01,0x0C,
  0x0E,0x12,0x1C,0x3C,0x30,0x4A,0x5A,0x64,0x24,0x32,0x10,0x01,0x00,0x2C,0x00,0x07,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,
  0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x5A,0x46,0x4F,0x04,0x41,0x0A,0x00,0x00,0x00,0x3C,0x00,0x00,0x3D,0x64,0x00,
  0x00,0x00,0x24,0x54,0x10,0x01,0x00,0x2D,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5C,0x5A,0x2B,0x08,0x5B,
  0x0C,0x00,0x00,0x00,0x3C,0x00,0x00,0x3C,0x64,0x00,0x00,0x00,0x42,0x72,0x73,0x20,
  0x53,0x65,0x63,0x74,0x20,0x31,0x05,0x07,0x0F,0x00,0x30,0x32,0x10,0x01,0x00,0x17,
  0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,
  0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x5F,0x48,0x7F,0x06,0x24,0x05,0x00,0x01,0x00,0x00,0x00,0x00,0x14,
  0x64,0x64,0x64,0x64,0x24,0x32,0x10,0x01,0x00,0x1D,0x00,0x07,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x48,0x7F,
  0x06,0x24,0x0C,0x00,0x01,0x00,0x00,0x1D,0x2E,0x28,0x64,0x64,0x64,0x00,0x30,0x32,
  0x10,0x01,0x01,0x00,0x00,0x07,0x06,0x03,0x00,0x0B,0x21,0x23,0x00,0x13,0x22,0x32,
  0x32,0x32,0x3F,0x0F,0x28,0x46,0x08,0x09,0x24,0x09,0x37,0x3A,0x00,0x02,0x13,0x01,
  0x08,0x1F,0x64,0x56,0x3C,0x57,0x48,0x4E,0x44,0x7F,0x00,0x1B,0x0C,0x01,0x02,0x06,
  0x08,0x04,0x17,0x14,0x4B,0x2C,0x64,0x5D,0x24,0x2F,0x10,0x01,0x00,0x00,0x48,0x07,
  0x06,0x03,0x00,0x0B,0x0F,0x18,0x00,0x13,0x22,0x2B,0x32,0x32,0x3D,0x0F,0x28,0x46,
  0x08,0x09,0x24,0x09,0x37,0x3A,0x00,0x02,0x18,0x01,0x08,0x1F,0x64,0x56,0x3C,0x57,
  0x48,0x4E,0x44,0x7F,0x00,0x1B,0x0C,0x01,0x02,0x0B,0x08,0x0D,0x17,0x14,0x4B,0x2C,
  0x64,0x5D,0x53,0x61,0x78,0x20,0x31,0x20,0x20,0x20,0x20,0x20,0x01,0x05,0x0F,0x00,
  0x24,0x32,0x10,0x01,0x01,0x00,0x00,0x07,0x07,0x03,0x04,0x15,0x15,0x27,0x00,0x32,
  0x27,0x32,0x32,0x32,0x40,0x1A,0x30,0x58,0x11,0x07,0x21,0x09,0x30,0x47,0x00,0x00,
  0x03,0x11,0x19,0x3E,0x2D,0x4C,0x37,0x29,0x1D,0x64,0x4B,0x5B,0x0C,0x1B,0x0C,0x03,
  0x00,0x0B,0x0E,0x0C,0x16,0x1E,0x2F,0x42,0x60,0x64,0x37,0x31,0x10,0x01,0x01,0x00,
  0x00,0x07,0x00,0x00,0x00,0x0A,0x14,0x32,0x00,0x32,0x32,0x32,0x32,0x32,0x40,0x21,
  0x2E,0x64,0x00,0x06,0x26,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x64,0x64,0x73,0x00,0x24,0x08,0x02,0x00,0x0A,0x1A,0x14,0x3C,0x11,
  0x3E,0x64,0x59,0x45,0x24,0x00,0x10,0x01,0x00,0x1E,0x00,0x07,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x07,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0x50,0x50,
  0x00,0x1B,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x64,0x64,0x64,0x64,0x24,0x38,
  0x10,0x01,0x00,0x1D,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,
  0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0x50,0x6F,0x05,0x1B,0x06,0x00,0x00,0x00,
  0x00,0x00,0x00,0x1E,0x64,0x64,0x64,0x64,0x49,0x63,0x65,0x20,0x52,0x61,0x69,0x6E,
  0x20,0x20,0x07,0x02,0x07,0x00,0x24,0x37,0x10,0x01,0x01,0x00,0x00,0x06,0x08,0x01,
  0x00,0x01,0x08,0x06,0x64,0x32,0x62,0x29,0x32,0x32,0x40,0x1E,0x4C,0x19,0x00,0x07,
  0x29,0x0A,0x5C,0x58,0x00,0x01,0x01,0x0F,0x29,0x3D,0x59,0x4F,0x1F,0x40,0x28,0x5F,
  0x4B,0x5B,0x0C,0x1B,0x0C,0x01,0x01,0x00,0x07,0x0E,0x54,0x55,0x64,0x47,0x53,0x00,
  0x24,0x2D,0x10,0x01,0x00,0x00,0x55,0x06,0x05,0x01,0x00,0x01,0x08,0x06,0x64,0x32,
  0x62,0x29,0x32,0x32,0x3D,0x1E,0x46,0x19,0x00,0x07,0x29,0x0A,0x5C,0x58,0x00,0x01,
  0x01,0x0F,0x29,0x3D,0x59,0x4F,0x1F,0x40,0x28,0x5F,0x4B,0x5B,0x0C,0x1B,0x0C,0x01,
  0x01,0x00,0x07,0x0E,0x54,0x55,0x64,0x47,0x53,0x00,0x43,0x32,0x05,0x01,0x00,0x69,
  0x00,0x07,0x08,0x03,0x00,0x36,0x36,0x44,0x4C,0x5D,0x57,0x4D,0x2D,0x00,0x00,0x00,
  0x00,0x00,0x00,0x0B,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x5F,0x46,0x7F,0x00,0x1B,0x0C,0x00,0x00,0x00,0x3F,0x3D,0x48,0x4C,
  0x64,0x5E,0x41,0x00,0x43,0x32,0x05,0x01,0x00,0x69,0x00,0x07,0x08,0x03,0x00,0x36,
  0x36,0x44,0x4C,0x5D,0x57,0x4D,0x2D,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x07,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5F,0x46,0x7F,
  0x00,0x1B,0x0C,0x00,0x00,0x00,0x3F,0x3D,0x48,0x4C,0x64,0x5E,0x41,0x00,0x45,0x6C,
  0x65,0x63,0x50,0x69,0x61,0x6E,0x6F,0x31,0x01,0x00,0x07,0x00,0x24,0x37,0x0F,0x01,
  0x00,0x00,0x3C,0x07,0x03,0x00,0x01,0x0A,0x07,0x16,0x00,0x32,0x42,0x33,0x32,0x32,
  0x00,0x00,0x00,0x35,0x00,0x07,0x16,0x08,0x29,0x28,0x00,0x02,0x00,0x20,0x3B,0x64,
  0x52,0x64,0x47,0x29,0x00,0x5A,0x55,0x5C,0x0C,0x59,0x0C,0x02,0x00,0x00,0x32,0x47,
  0x64,0x38,0x64,0x52,0x28,0x00,0x4E,0x47,0x07,0x01,0x00,0x00,0x21,0x07,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x1D,0x01,0x09,
  0x61,0x0A,0x64,0x00,0x00,0x03,0x00,0x1A,0x40,0x4B,0x1D,0x64,0x38,0x14,0x00,0x47,
  0x3C,0x33,0x08,0x5B,0x0C,0x01,0x01,0x00,0x28,0x3D,0x4A,0x64,0x64,0x36,0x23,0x06,
  0x30,0x2D,0x0F,0x01,0x01,0x00,0x3C,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x32,
  0x34,0x30,0x30,0x31,0x3E,0x08,0x42,0x37,0x00,0x07,0x16,0x09,0x28,0x28,0x00,0x02,
  0x00,0x18,0x3B,0x64,0x52,0x64,0x47,0x29,0x00,0x5A,0x55,0x5C,0x0C,0x59,0x0C,0x02,
  0x00,0x00,0x32,0x47,0x64,0x33,0x64,0x52,0x28,0x00,0x30,0x2D,0x0F,0x01,0x01,0x00,
  0x3C,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x32,0x34,0x30,0x30,0x31,0x3E,0x08,
  0x42,0x37,0x00,0x07,0x16,0x09,0x28,0x28,0x00,0x02,0x00,0x18,0x3B,0x64,0x52,0x64,
  0x47,0x29,0x00,0x5A,0x55,0x5C,0x0C,0x59,0x0C,0x02,0x00,0x00,0x32,0x47,0x64,0x33,
  0x64,0x52,0x28,0x00,0x42,0x6F,0x74,0x74,0x6C,0x65,0x42,0x6C,0x6F,0x77,0x05,0x01,
  0x0F,0x00,0x21,0x32,0x10,0x01,0x00,0x1C,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,0x55,0x7B,0x08,0x20,
  0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x64,0x64,0x64,0x64,0x3C,0x49,0x07,0x01,
  0x00,0x35,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x1D,0x00,0x32,0x32,0x32,0x32,0x32,
  0x3F,0x25,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x20,0x46,0x7D,0x04,0x1B,0x0C,0x00,0x00,0x08,0x18,0x23,
  0x28,0x1A,0x54,0x5F,0x56,0x46,0x24,0x32,0x10,0x01,0x00,0x00,0x00,0x07,0x06,0x03,
  0x01,0x0E,0x11,0x30,0x00,0x42,0x38,0x32,0x32,0x32,0x3F,0x19,0x44,0x32,0x18,0x0C,
  0x1D,0x0B,0x2A,0x43,0x00,0x00,0x05,0x15,0x2C,0x2D,0x44,0x11,0x1D,0x17,0x0E,0x64,
  0x44,0x7F,0x00,0x1B,0x0C,0x00,0x00,0x04,0x08,0x17,0x22,0x36,0x57,0x64,0x5D,0x64,
  0x43,0x2D,0x10,0x01,0x00,0x00,0x00,0x07,0x05,0x03,0x01,0x0D,0x12,0x22,0x00,0x3F,
  0x37,0x33,0x32,0x32,0x3F,0x28,0x00,0x2A,0x16,0x08,0x64,0x04,0x24,0x37,0x00,0x00,
  0x09,0x25,0x2B,0x4E,0x64,0x42,0x23,0x17,0x11,0x44,0x3C,0x67,0x07,0x1B,0x0C,0x00,
  0x00,0x19,0x0F,0x19,0x22,0x26,0x4F,0x61,0x5E,0x64,0x4F,0x72,0x63,0x68,0x65,0x20,
  0x48,0x69,0x74,0x20,0x02,0x08,0x0F,0x00,0x24,0x32,0x10,0x01,0x00,0x2F,0x00,0x07,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,
  0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x64,0x46,0x1B,0x0C,0x67,0x02,0x02,0x00,0x01,0x2E,0x2D,0x1F,0x4C,0x64,0x5D,
  0x32,0x00,0x18,0x32,0x10,0x01,0x01,0x00,0x64,0x07,0x04,0x00,0x00,0x0C,0x13,0x25,
  0x00,0x3D,0x36,0x32,0x32,0x32,0x39,0x21,0x43,0x3A,0x00,0x0A,0x1E,0x09,0x3E,0x00,
  0x00,0x00,0x08,0x2F,0x23,0x2D,0x29,0x1E,0x2A,0x22,0x05,0x3D,0x49,0x1B,0x0C,0x67,
  0x02,0x01,0x00,0x14,0x24,0x2C,0x22,0x3E,0x64,0x61,0x3F,0x00,0x30,0x32,0x10,0x01,
  0x00,0x17,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,
  0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x64,0x46,0x1B,0x0C,0x67,0x02,0x02,0x00,0x00,0x33,0x2D,
  0x19,0x4C,0x64,0x5E,0x32,0x00,0x31,0x48,0x10,0x01,0x00,0x2D,0x00,0x07,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x32,0x32,0x32,0x32,0x32,0x00,0x00,0x00,0x00,0x00,0x03,
  0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x64,
  0x48,0x1B,0x0C,0x67,0x02,0x02,0x00,0x00,0x33,0x2D,0x19,0x4C,0x64,0x5E,0x32,0x00};

unsigned char gsd_sys[]={
  0x43,0x4F,0x4D,0x45,0x20,0x4F,0x4E,0x20,0x4D,0x55,0x53,0x49,0x43,0x00,0x47,0x53,
  0x20,0x43,0x4F,0x4E,0x54,0x52,0x4F,0x4C,0x20,0x31,0x2E,0x30,0x00,0x00,0x00,0x00,
  0x00,0x04,0x00,0x00,0x7F,0x40,0x40,0x04,0x04,0x00,0x40,0x40,0x00,0x00,0x02,0x00,
  0x40,0x08,0x50,0x03,0x13,0x00};

unsigned char gsd_rsv[]={
  2,2,2,2,2,2,2,2,2,6,0,0,0,0,0,0};

unsigned char gsd_part[]={
  0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
  0x01,0x01,0x01,0x01,0x01,0x00,0x40,0x08,0x00,0x64,0x40,0x40,0x40,0x00,0x7F,0x10,
  0x11,0x00,0x28,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
  0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x0A,0x00,0x00,0x40,0x00,
  0x00,0x00,0x42,0x40,0x40,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x40,0x40,
  0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x40,
  0x00,0x00,0x00,0x40,0x40,0x40,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x40,
  0x40,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x02};

unsigned char gsd_rhy[]={
  0x4F,0x31,0x7F,0x7F,0x6B,0x31,0x7F,0x7F,0x57,0x36,0x3F,0x3F,0x5B,0x36,0x3F,0x3F,
  0x73,0x40,0x3F,0x3F,0x7F,0x36,0x00,0x00,0x67,0x40,0x3F,0x3F,0x67,0x40,0x3F,0x3F,
  0x7F,0x40,0x20,0x20,0x7F,0x40,0x20,0x20,0x7F,0x40,0x7F,0x7F,0x7F,0x40,0x7F,0x7F,
  0x63,0x36,0x7F,0x7F,0x7F,0x40,0x7F,0x7F,0x7F,0x22,0x7F,0x7F,0x7B,0x54,0x1F,0x1F,
  0x7F,0x2E,0x7F,0x7F,0x57,0x54,0x20,0x20,0x7F,0x3A,0x7F,0x7F,0x77,0x54,0x1F,0x1F,
  0x7F,0x46,0x7F,0x7F,0x7F,0x52,0x7F,0x7F,0x7F,0x54,0x7F,0x7F,0x7F,0x5E,0x7F,0x7F,
  0x78,0x2C,0x7F,0x7F,0x6F,0x2C,0x7F,0x7F,0x63,0x2C,0x7F,0x7F,0x77,0x4A,0x3F,0x3F,
  0x53,0x36,0x7F,0x7F,0x73,0x54,0x3F,0x3F,0x7F,0x2C,0x7F,0x7F,0x69,0x1D,0x7F,0x7F,
  0x78,0x2C,0x7F,0x7F,0x7F,0x63,0x5F,0x5F,0x7F,0x63,0x5F,0x5F,0x63,0x27,0x7F,0x7F,
  0x6B,0x27,0x7F,0x7F,0x7B,0x2C,0x5F,0x5F,0x63,0x54,0x7F,0x7F,0x63,0x54,0x7F,0x7F,
  0x63,0x1D,0x64,0x64,0x63,0x1D,0x64,0x64,0x5F,0x1D,0x3F,0x3F,0x69,0x18,0x3F,0x3F,
  0x4F,0x63,0x7F,0x7F,0x53,0x63,0x7F,0x7F,0x6B,0x5E,0x3F,0x3F,0x6F,0x5E,0x3F,0x3F,
  0x6E,0x54,0x5F,0x5F,0x6B,0x63,0x5F,0x5F,0x6B,0x63,0x5F,0x5F,0x53,0x2C,0x7F,0x7F,
  0x57,0x2C,0x7F,0x7F,0x5F,0x18,0x5F,0x5F,0x5F,0x18,0x7F,0x7F,0x7B,0x5E,0x3F,0x3F,
  0x77,0x63,0x7F,0x7F,0x7B,0x68,0x7F,0x7F,0x7B,0x22,0x5F,0x5F,0x7F,0x2C,0x5F,0x5F,
  0x7F,0x2C,0x5F,0x5F,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,
  0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,
  0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,
  0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,
  0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,
  0x7F,0x40,0x00,0x00,0x7F,0x40,0x00,0x00,0x00,0x00,0x00,0x00};

unsigned char gsd_data[]={
  0x00,0x20,0x40,0x00,0x00};

char	swi_str[2][4]={"OFF"," ON"};

char	pch_title[5][20]={
  "<<< SYSTEM MODE >>>","   LA PATCH WRITE  ","  PCM PATCH WRITE  ",
  "RHYTHM PATCH WRITE ","   USER TONE LIST  "};

char	tone_title[6][11]={
  "< LA [A] >","< LA [B] >"," < USER > ","< RHYTHM >","<INTERNAL>"," < CARD > "};

char	tone_hed[6]={'A','B','I','R','I','C'};

int	selno,tkey,tvel;
char	trf[64];


/***************************/
void	cm64_con()
{
  int	ke,sh,ex,smo=0,i;
  char	tmp0[256],path2[256];

  tkey=60;tvel=127;
  fill(0,544,767,1023,0);pfil();home2(512);trns_check();
  B_CLR_AL();

  if(cm6_file[0]==0){cm6_write(0x51*128*128+19*64,0x4eb2+19*64,19*64);}/*debug*/

  while( 1){
    ke=0;
    if( smo==0 ){ke=sys_mode();}
    if( smo==1 ){ke=tone_patch(0);}
    if( smo==2 ){ke=tone_patch(1);}
    if( smo==3 ){ke=rhy_patch();}

    if(ke==0){ke=inkey3();}
  recontrol:
    sh=ke>>8;ke=ke & 0xff;if(ke>=0xf0 && ke<=0xf3){smo=ke-0xf0;}

    if( ke==0xf4 ){
      if( (sh&1)!=0 ){
	ke=user_tone_list();goto recontrol;
      }else{
	all_note_off(0);temporary_set();
	msg(_("Sending voice data (  )"));
	for(i=0;i<64;i++){
	  if(trf[i]==0){
	    B_LOCATE(20,1);B_PRINT(fstr(64-i,2));trf[i]=1;
	    cm6_tone_write(i);
	  }
	}
	msg_clr();tim_buf_trns();C_FNKMOD(2);B_CLR_AL();dpl(0);
	ex=exe("te.x -i");C_FNKMOD(3);if(ex>0){key_pause();}
	C_CUROFF();B_COLOR(3);B_CLR_AL();tim_var_read();
	C_WINDOW(0,31);home2(512);OnGraphic();dpl(1);
	if(ex<0){msg(_("Cannot execute: TE.x"));}
      }
    }

    if( ke==0xf5 ){
      B_CLR_AL();strcpy(path2,rcp_path);fsel(cm6_file,path2,0x002);
      if( cm6_file[0]==0 ){cminit();timtra();}
      if( cm6_file[0]!=0 && es==0 ){
	strcpy(tmp0,path2);strcat(tmp0,cm6_file);
	if(timload(tmp0)!=0){cminit();cm6_file[0]=0;}
	else{
	  if(!(cnfflag&0x0008)){strcpy(rcp_path,path2);}
	}
	timtra();trns_check();
      }
      sdis2(53,64,cm6_file,15,15,0);pfil();
    }
    if( ke==0xf6 ){
      B_CLR_AL();strcpy(path2,rcp_path);fsel(cm6_file,path2,0x102);
      if( cm6_file[0]!=0 && es==0 ){
	strcpy(tmp0,path2);strcat(tmp0,cm6_file);
	if(timsave(tmp0)==0){
	  if(!(cnfflag&0x0008)){strcpy(rcp_path,path2);}
	}
      }
      sdis2(53,64,cm6_file,15,15,0);pfil();
    }

    if( ke==0xf7 ){poplay(0,1);}

    if( ke==0xf8 ){
      msg(_("Initialize all control data"));
      if(yn_sel()>0){
	cminit();all_note_off(1);trns_check();
      }
    }

    if( ke==0xf9 || ke==27 ){break;}

  }

  temporary_set();
  fnc_dis(-1);B_CLR_AL();home2(0);return;
}

/***************************/
void	pfil()
{
  sdis2(0,552," CM-64 CONTROLER",17,15,8);
  sdis2(50,552," CONTROL FILE:",14,15,8);sdis2(64,552,cm6_file,15,15,8);
  box(648,552,744,600,14,65535);box(650,554,742,598,14,65535);
  keyd();
}

/***************************/
void	keyd()
{
  B_LOCATE(83,3);B_PRINT("KEY= ");B_PRINT(keystr(tkey));
  B_LOCATE(83,4);B_PRINT("VEL=");B_PRINT(fstr(tvel,4));
}

/***************************/
void	keyd_inp(int a)
{
  int	v;
  char	tmp0[128];
  if(a==0){
    B_LOCATE(88,3);strcpy(tmp0,keystr(tkey));sinput(tmp0,0x803);
    if(es==0){v=ctc(60,tmp0,0);if(v>=0){tkey=v;}}
  }else{
    B_LOCATE(88,4);v=vinput(tvel,0x803);
    if(es==0 && v>=0 && v<128){tvel=v;}
  }
  keyd();
}

/***************************/
void	pch_fld(int m)
{
  static	char	hd0[]="NO. TIMBRE NAME     ";
  static	char	hd1[]="KEY#   TIMBRE NAME   OUTPUT  PAN  REV   ";

  fnc_dis(3);B_LOCATE(0,2);B_CLR_ED();fill(0,574,639,1023,0);keyd();
  sdis2(19,552,pch_title[m],19,15,8);

  if(m==0){
    box(0,598,639,1000,14,65535);
  }else{
    box(0,700,639,999,14,65535);box(1,724,638,1000,14,65535);
    fill(1,701,638,723,14);
    if(m==2){
      sdis2(1,576," CARD:",14,15,8);
      sdis2(7,576,card_name[card_no[0]],65,15,8);
    }
    if(m==3){
      B_LOCATE(1,12);B_PRINT(hd1);B_PRINT(hd1);
      line(316,723,316,1000,14,65535);
    }else{
      B_LOCATE(1,12);B_PRINT(hd0);B_PRINT(hd0);B_PRINT(hd0);B_PRINT(hd0);
      if(m<3){
	box(0,600,639,696,14,65535);box(2,602,637,694,14,65535);
	line(156,602,156,694,14,65535);line(316,602,316,694,14,65535);
	line(476,602,476,694,14,65535);
	fill(4,604,154,619,14);
	g_print(10,604,"PATCH PARAMETER",15);
      }
      line(156,723,156,1000,14,65535);line(316,723,316,1000,14,65535);
      line(476,723,476,1000,14,65535);
    }
  }
}

/***************************/
void	card_sel()
{
  int	ke,i,y;

  B_CLR_AL();fill(0,574,639,1023,0);keyd();
  box(7,692,432,984,14,65535);box(9,694,430,982,14,65535);
  sdis(1,676," PCM CARD SELECTER",53,15,14);

  for(i=0;i<17;i++){
    B_LOCATE(2,12+i);B_PRINT(fstr(i,2));B_PRINT(":");B_PRINT(card_name[i]);
  }
  y=card_no[0];

  while( 1){
    tcur(5,12+y,48,3);
    ke=inkey2();
    tcur(5,12+y,48,3);

    if( ke==27 ){return;}
    if( ke==13 ){card_no[0]=y;card_name_get();return;}

    if( ke==0x05 ){y--;if( y<0 ){y=16;}}
    if( ke==0x18 ){y++;if( y>16 ){y=0;}}
  }
}

void	card_name_get()
{
  int	i,nm=card_no[0];

  for(i=0;i<128;i++){
    if(nm){
      strcpy(tim_name[384+i],tim_names((nm+15)*128+i));
    }else{
      tim_name[384+i][0]=0;
    }
  }
}

/***************************/
int	sys_mode()
{
  int	a,ke;

  pch_fld(0);
  while(1){
    ke=inkey3();a=ke&0xff;

    if(a=='Z'||a=='z'){timtra();trns_check();}
    if(a>=0xf0){return(ke);}
    if( a==27 ){return(0xf9);}
  }
}

/***************************/
int	tone_patch(int mo)
{
  int	ad,ke,a,n,i,j,i0,p=0,x=0,y=0,xx,yy;
  char	tmp0[256];

  pch_fld(mo+1);selno=0;
  while(1){
    for(i=p*64;i<p*64+64;i++){
      i0=i;if((cmdflag&0x20)!=0){i0++;}
      strcpy(tmp0,fstr(i0,3));strcat(tmp0,":");
      strcat(tmp0,cm6_tone_name(mo,i));
      tdis(((i&63)>>4)*20,(i&15)+14,tmp0,19,3);
    }

    while( 1){
      i=y+x*16+p*64;
      if(mo==0){ad=0xa34+i*8;}else{ad=0x4eb2+i*19;}
      pat_para_dis(mo,ad);

      xx=x*20+4;yy=y+14;
      strcpy(tmp0,cm6_tone_name(mo,i));
      tdis( xx,yy,tmp0,15,11);
      ke=inkey3();a=ke&0xff;

      if(a=='K'||a=='k'){keyd_inp(0);}
      if(a=='V'||a=='v'){keyd_inp(1);}
      if(a==0x9){
	tdis( xx,yy,tmp0,15,9);
	pat_para_set(mo,ad,i);
      }

      if(a=='C'||a=='c'){
	card_sel();pch_fld(mo+1);break;
      }

      if( a==0x05 ){y--;if( y<0 ){y=15;}}
      if( a==0x18 ){y++;if( y>15 ){y=0;}}
      if( a==0x13 ){x--;if( x<0 ){x=3;}}
      if( a==0x04 ){x++;if( x>3 ){x=0;}}
      if( a==0x17 ){if( p>0 ){p--;break;}}
      if( a==0x12 ){if( p<1 ){p++;break;}}

      if(a==0x15){
	if(mo==0){
	  s_test(2,-1,i,tkey,tvel);
	}else{
	  s_test(11,-1,i,tkey,tvel);
	}
      }

      if( a==13 ){
	tdis(xx,yy,tmp0,15,9);
	if(mo==0){
	  n=cm6_tonesel(0);
	  if( n>=0 ){
	    cm6[ad]=n>>6;cm6[ad+1]=n & 0x3f;
	    cm6_la_write(i);
	    if(n>127 && n<192 ){
	      if(trf[n-128]==0){
		trf[n-128]=1;
		cm6_tone_write(n-128);
	      }
	    }
	  }
	}else{
	  n=cm6_tonesel(2);
	  if( n>=0 ){
	    cm6[ad]=n>>7;cm6[ad+1]=n & 0x7f;
	    cm6_pcm_write(i);
	  }
	}
	break;
      }
      if( a==32 ){
	if(mo==0){
	  for(j=0;j<8;j++){cm6[ad+j]=la_para[j];}
	  cm6[ad]=i>>6;cm6[ad+1]=i & 0x3f;
	  cm6_la_write(i);
	}else{
	  for(j=0;j<20;j++){cm6[ad+j]=pcm_para[j];}
	  cm6[ad]=i>>6;
	  if(i>63){cm6[ad+1]=i-64;}else{cm6[ad+1]=pcmpat[i];}
	  cm6_pcm_write(i);
	}
	break;
      }
      tdis( xx,yy,tmp0,15,3);

      if(a=='Z' || a=='z'){timtra();trns_check();}

      if(a>=0xf0){return(ke);}
      if( a==27 ){return(0xf0);}
    }
  }
}

/***************************/
void	pat_para_set(int mo,int ad,int i)
{
  int	a,s,v,x=0,y=0,xx,yy;

  while(1){
    pat_para_dis(mo,ad);s=x*5+y;xx=20+x*20;yy=y+6;
    tcur(xx,yy,19,3);a=inkey3()&0xff;
    if(a==0x15){
      if(mo==0){s_test(2,-1,i,tkey,tvel);}else{
	s_test(11,-1,i,tkey,tvel);}}
    tcur(xx,yy,19,3);

    if(a=='Z'||a=='z'){timtra();trns_check();}
    if(a=='K'||a=='k'){keyd_inp(0);}
    if(a=='V'||a=='v'){keyd_inp(1);}

    if( a==0x05 ){y--;if( y<0 ){y=4;}}
    if( a==0x18 ){y++;if( y>4){y=0;}}
    if( a==0x13 ){x--;if( x<0 ){x=2;}}
    if( a==0x04 ){x++;if( x>2){x=0;}}

    if( a==13 ){
      B_LOCATE(xx+16,yy);
      if(mo==0){
	if(s==0){
	  v=vinput(cm6[ad+2]-24,0x803);
	  if(es==0 && v>=-24 && v<=24){cm6[ad+2]=v+24;}
	}
	if(s==1){
	  v=vinput(cm6[ad+3]-50,0x803);
	  if(es==0 && v>=-50 && v<=50){cm6[ad+3]=v+50;}
	}
	if(s==2){
	  v=vinput(cm6[ad+4],0x803);
	  if(es==0 && v>=-24 && v<=24){cm6[ad+4]=v;}
	}
	if(s==3){
	  cm6[ad+5]=(cm6[ad+5]+1)&3;
	}
	if(s==4){
	  cm6[ad+6]=(cm6[ad+6]+1)&1;
	}
	cm6_la_write(i);
      }else{
	if(s==0){
	  v=vinput(cm6[ad+2]-12,0x803);
	  if(es==0 && v>=-12 && v<=12){cm6[ad+2]=v+12;}
	}
	if(s==1){
	  v=vinput(cm6[ad+3]-50,0x803);
	  if(es==0 && v>=-50 && v<=50){cm6[ad+3]=v+50;}
	}
	if(s==2){
	  v=vinput(cm6[ad+4]-12,0x803);
	  if(es==0 && v>=-12 && v<=12){cm6[ad+4]=v+12;}
	}
	if(s==3){
	  cm6[ad+7]=(cm6[ad+7]+1)&3;
	}
	if(s==4){
	  cm6[ad+8]=(cm6[ad+8]+1)&1;
	}
	if(s>4 && s<14){
	  v=vinput(cm6[ad+4+s],0x803);
	  if(s>5 && s<9){
	    if(es==0 && v>=0 && v<=127){cm6[ad+4+s]=v;}
	  }else{
	    if(es==0 && v>=0 && v<=15){cm6[ad+4+s]=v;}
	  }
	}
	if(s==14){
	  v=vinput(cm6[ad+18],0x803);
	  if(es==0 && v>=0 && v<=50){cm6[ad+18]=v;}
	}
	cm6_pcm_write(i);
      }
    }
    if( a==27 ){break;}
  }
}

/***************************/
void	pat_para_dis(int m,int ad)
{
  char	tmp0[256];
  int	sv;

  sv=SUPER(0);

  if(m==0){
    strcpy(tmp0," Key Shift     : ");strcat(tmp0,fstr(cm6[ad+2]-24,3));
    B_LOCATE(19,6);H_PRINT(tmp0,"","");

    strcpy(tmp0," Fine Tune     : ");strcat(tmp0,fstr(cm6[ad+3]-50,3));
    B_LOCATE(19,7);H_PRINT(tmp0,"","");

    strcpy(tmp0," Bender Range  : ");strcat(tmp0,fstr(cm6[ad+4],3));
    B_LOCATE(19,8);H_PRINT(tmp0,"","");

    strcpy(tmp0," Assign Mode  :POLY");strcat(tmp0,fstr(cm6[ad+5]+1,1));
    B_LOCATE(19,9);H_PRINT(tmp0,"","");

    strcpy(tmp0," Reverb Switch : ");strcat(tmp0,swi_str[cm6[ad+6]&1]);
    B_LOCATE(19,10);H_PRINT(tmp0,"","");
  }else{
    strcpy(tmp0," Key Shift     : ");strcat(tmp0,fstr(cm6[ad+2]-12,3));
    strcat(tmp0," Velocity Sens : ");strcat(tmp0,fstr(cm6[ad+9],3));
    strcat(tmp0," LFO Aut Rise T: ");strcat(tmp0,fstr(cm6[ad+14],3));
    B_LOCATE(19,6);H_PRINT(tmp0,"","");

    strcpy(tmp0," Fine Tune     : ");strcat(tmp0,fstr(cm6[ad+3]-50,3));
    strcat(tmp0," ENV Att Rate  : ");strcat(tmp0,fstr(cm6[ad+10],3));
    strcat(tmp0," LFO Auto Depth: ");strcat(tmp0,fstr(cm6[ad+15],3));
    B_LOCATE(19,7);H_PRINT(tmp0,"","");

    strcpy(tmp0," Bender Range  : ");strcat(tmp0,fstr(cm6[ad+4],3));
    strcat(tmp0," ENV Rel Rate  : ");strcat(tmp0,fstr(cm6[ad+11],3));
    strcat(tmp0," LFO Man Rise T: ");strcat(tmp0,fstr(cm6[ad+16],3));
    B_LOCATE(19,8);H_PRINT(tmp0,"","");

    strcpy(tmp0," Assign Mode  :POLY");strcat(tmp0,fstr(cm6[ad+7]+1,1));
    strcat(tmp0," LFO Rate      : ");strcat(tmp0,fstr(cm6[ad+12],3));
    strcat(tmp0," LFO Man Depth : ");strcat(tmp0,fstr(cm6[ad+17],3));
    B_LOCATE(19,9);H_PRINT(tmp0,"","");

    strcpy(tmp0," Reverb Switch : ");strcat(tmp0,swi_str[cm6[ad+8]&1]);
    strcat(tmp0," LFO Aut Dlay T: ");strcat(tmp0,fstr(cm6[ad+13],3));
    strcat(tmp0," Detune Depth  : ");strcat(tmp0,fstr(cm6[ad+18],3));
    B_LOCATE(19,10);H_PRINT(tmp0,"","");
  }
  SUPER(sv);
}

/***************************/
int	rhy_patch()
{
  int	ke,a,n,i,ad,p=0,x=0,y=0,v,xx,yy,s,ln;
  char	tmp0[256];

  pch_fld(3);selno=0;

  while(1){
    for(i=p*32;i<p*32+32;i++){
      if(i<85){
	ad=0x130+i*4;
	strcpy(tmp0,fstr(i+24,3));strcat(tmp0,":");
	strcat(tmp0,cm6_tone_name(2,i));
	strcat(tmp0,fstr(cm6[ad+1],6));strcat(tmp0,fstr(cm6[ad+2]-7,6));
	strcat(tmp0,"   ");strcat(tmp0,swi_str[cm6[ad+3]&1]);
      }else{tmp0[0]=0;}
      tdis( ((i&31)>>4)*40+1,(i&15)+14,tmp0,19+18,3);
    }

    while( 1){
      i=y+(x>>2)*16+p*32;ad=0x130+i*4;s=x&3;
      xx=(x>>2)*40+5;yy=y+14;
      if(s>0){ln=5;xx=xx+11+s*6;}else{ln=15;}
      if(i<85){
	if(s==0){strcpy(tmp0,cm6_tone_name(2,i));}
	if(s==1){strcpy(tmp0,fstr(cm6[ad+1],4));}
	if(s==2){strcpy(tmp0,fstr(cm6[ad+2]-7,4));}
	if(s==3){strcpy(tmp0," ");strcat(tmp0,swi_str[cm6[ad+3]&1]);}
      }else{tmp0[0]=0;}
      tdis(xx,yy,tmp0,ln,11);
      ke=inkey3();a=ke&0xff;

      if(a==0x15){s_test(10,-1,0,i+24,tvel);}
      if(a=='Z'||a=='z'){timtra();trns_check();}
      if(a=='K'||a=='k'){keyd_inp(0);}
      if(a=='V'||a=='v'){keyd_inp(1);}
      tdis( xx,yy,tmp0,ln,3);

      if( a==0x05 ){y--;if( y<0 ){y=15;}}
      if( a==0x18 ){y++;if( y>15 ){y=0;}}
      if( a==0x13 ){x--;if( x<0 ){x=7;}}
      if( a==0x04 ){x++;if( x>7 ){x=0;}}
      if( a==0x17 ){if( p>0 ){p--;break;}}
      if( a==0x12 ){if( p<2 ){p++;break;}}

      if( i<85){
	if( a==13 ){
	  if( s==0){
	    tdis(xx,yy,tmp0,ln,9);
	    n=cm6_tonesel(1);
	    if( n>=0 ){
	      cm6[ad]=n;
	      if(n<64){
		if(trf[n]==0){
		  trf[n]=1;
		  cm6_tone_write(n);
		}
	      }
	    }
	  }
	  if(s==1){
	    B_LOCATE(xx+1,yy);v=vinput(cm6[ad+1],0x803);
	    if(es==0 && v>=0 && v<101){cm6[ad+1]=v;}
	  }
	  if(s==2){
	    B_LOCATE(xx+2,yy);v=vinput(cm6[ad+2]-7,0x802)+7;
	    if(es==0 && v>=0 && v<15){cm6[ad+2]=v;}
	  }
	  if(s==3){cm6[ad+3]=1-cm6[ad+3];}
	}
	if( a==32 ){
	  cm6[ad]=rsetup[i*2];cm6[ad+1]=0x64;
	  cm6[ad+2]=rsetup[i*2+1];cm6[ad+3]=1;
	}
	if( a==32 || a==13){
	  cm6_write(3*128*128+1*128+16+i*4,ad,4);
	}
      }

      if(a>=0xf0){return(ke);}
      if( a==27 ){return(0xf0);}
    }
  }
}

/***************************/
int	user_tone_list()
{
  int	ad1,ad2,a,d,n=-1,i,j,x=0,y=0,xx,yy;
  char	tmp0[256];

  pch_fld(4);
  while(1){
    for(i=0;i<64;i++){
      strcpy(tmp0,fstr(i+1,3));strcat(tmp0,": ");
      strcat(tmp0,tim_name[i+128]);
      tdis((i>>4)*20,(i&15)+14,tmp0,15,3);
      if(n==i){tcur( (i>>4)*20+1,(i&15)+14,3,3);}
    }

    while( 1){
      i=y+x*16;xx=x*20+5;yy=y+14;
      strcpy(tmp0,tim_name[i+128]);

      tdis(xx,yy,tmp0,10,11);
      a=inkey3();
      tdis(xx,yy,tmp0,10,3);

      if((a&0xff)>=0xf0){return(a);}
      a=a&0xff;

      if(a=='Z'||a=='z'){timtra();trns_check();}

      if( a==0x05 ){y--;if( y<0 ){y=15;}}
      if( a==0x18 ){y++;if( y>15 ){y=0;}}
      if( a==0x13 ){x--;if( x<0 ){x=3;}}
      if( a==0x04 ){x++;if( x>3 ){x=0;}}

      if( a==32 ){n=i;break;}

      if( (a=='X'||a=='x') && n>=0){
	strcpy(tmp0,tim_name[i+128]);
	strcpy(tim_name[i+128],tim_name[n+128]);
	strcpy(tim_name[n+128],tmp0);

	ad1=0xe34+i*256;ad2=0xe34+n*256;trf[n]=1;trf[i]=1;
	for(j=0;j<256;j++){
	  d=cm6[ad1];cm6[ad1]=cm6[ad2];cm6[ad2]=d;ad1++;ad2++;
	}
	cm6_tone_write(i);cm6_tone_write(n);
	break;
      }

      if( a==12 ){
	msg(_("Clear control data"));
	if(yn_sel()>0){
	  tim_name[i+128][0]=0;
	  ad1=0xe34+i*256;trf[i]=1;
	  for(j=0;j<256;j++){cm6[ad1]=0;ad1++;}
	  cm6_tone_write(i);
	}
      }

      if( a==13 ){
	B_LOCATE(xx,yy);sinput(tim_name[i+128],10);
	strcpy(tmp0,spadd(tim_name[i+128],10));
	for(j=0;j<10;j++){cm6[0xe34+i*256+j]=tmp0[j];}
	cm6_tone_write(i);
      }

      if( a==27 ){return(0xf0);}
    }
  }
}
/***************************/
int	cm6_tonesel(int slmd)
{
  int	a,i,p=0,y=0,g,stpo,gmax,nm;
  char	tmp0[256];

  fill(640,684,767,1004,0);
  box(644,684,767,1004,14,65535);box(645,724,766,1003,14,65535);
  fill(644,684,767,724,14);

  stpo=slmd*128;p=selno&0xf0;y=selno&15;

  if(slmd==0){
    g=2;gmax=3;nm=64;
  }else{
    g=0;gmax=1;
    if(slmd==1){nm=64;}else{nm=128;}
  }

  while(1){
    B_LOCATE(81,11);B_PRINT("## TONE LIST ##");
    B_LOCATE(83,12);B_PRINT(tone_title[slmd*2+g]);

    for(i=p;i<p+16;i++){
      strcpy(tmp0,fstr(i+1,3));strcat(tmp0,":");
      strcat(tmp0,tim_name[i+g*nm+stpo]);
      tdis(81,(i-p)+14,tmp0,14,3);
    }
    while( 1){
      i=y+p;
      tcur(85,y+14,10,3);
      a=inkey2();
      tcur(85,y+14,10,3);

      if( a==0x13 ){g--;if(g<0   ){g=gmax;}break;}
      if( a==0x04 ){g++;if(g>gmax){g=0;}break;}
      if( a==0x05 ){
	y--;if( y<0 ){y=0;if( p>0 ){p--;break;}}
      }
      if( a==0x18 && i+1<nm){
	y++;if( y>15 ){y=15;if( p+16<nm ){p++;break;}}
      }
      if( a==0x17 ){if( p>0 ){p-=16;if(p<0){p=0;}break;}else{y=0;}}

      if( a==0x12 ){if( p+16<nm ){p+=16;if(p+16>nm){p=nm-16;}
      if(p+y>=nm){y=(nm-1)-p;}break;
      }else{y=(nm-1)-p;if(y<0){y=0;}}}
      /*
	if( a==9 ){
	int n;
	msg("Tone No.=");n=vinput(p+y+1,0x803)-1;msg_clr();
	if( es==0 && n>=0 && n<nm){
	p=n&0xf0;y=n&15;break;
	}
	}
	*/
      if( a==13 || a==27 ){break;}
    }
    if( a==13 || a==27 ){break;}
  }
  txerase(80*8,11*16,16*8,20*16);fill(640,684,767,1004,0);
  selno=p+y;
  if( a==13 ){return(y+p+g*nm);}else{return(-1);}
}

/***************************/
void	cminit()
{
  int	i,j,ad,m;

  /* system */
  for(i=0;i<64  ;i++){cm6[i]=cm6_info[i];cm6[i+64]=32;}
  for(i=0;i<32  ;i++){cm6[i+0x80  ]=la_sys[i];}
  for(i=0;i<144 ;i++){cm6[i+0xa0  ]=la_tmp[i];}
  for(i=0;i<1968;i++){cm6[i+0x284 ]=la_tim_tmp[i];}
  for(i=0;i<126 ;i++){cm6[i+0x4e34]=pcm_tmp[i];}
  for(i=0;i<23  ;i++){cm6[i+0x5832]=pcm_sys[i];}

  m=(mdlflag&3);
  for(i=0;i<128;i++){
    /* la_patch */
    ad=0xa34+i*8;cm6[ad]=i>>6;cm6[ad+1]=i&63;
    for(j=2;j<8;j++){cm6[ad+j]=la_para[j];}
    /* pcm patch */
    ad=0x4eb2+i*19;
    if(m==1){
      if(i<64){
	cm6[ad]=0;cm6[ad+1]=pcmpat[i];
      }else{
	cm6[ad]=1;cm6[ad+1]=i-64;
      }
    }else{
      cm6[ad]=0;cm6[ad+1]=i;
    }
    for(j=2;j<19;j++){cm6[ad+j]=pcm_para[j];}
  }

  /* rhythm setup */
  for(i=0;i<85;i++){
    ad=0x130+i*4;
    cm6[ad]=rsetup[i*2];cm6[ad+2]=rsetup[i*2+1];
    cm6[ad+1]=0x64;cm6[ad+3]=1;
  }

  /* timbre */
  for(i=0xe34;i<0x4e34;i++){cm6[i]=0;}
  for(i=0;i<64;i++){tim_name[i+128][0]=0;}
}

/***************************/
void	cm6_write(int ad,int ad2,int ln)
{
  int	i,a,by,sum;
  static	unsigned char	send[5]= {0xf0,0x41,0x10,0x16,0x12};
  unsigned char	para[5];
  unsigned char	buf[280];

  while(ln>0){
    int pp=0;
    if(ln<256){by=ln;}else{by=256;}

    for(i=0;i<5;i++){buf[pp++]=send[i];}
    para[0]=(ad>>14)& 0x7f;para[1]=(ad>>7)& 0x7f;para[2]=ad & 0x7f;
    sum=0;for(i=0;i<3;i++){a=para[i];buf[pp++]=a;sum=sum+a;}
    for(i=0;i<by;i++){a=cm6[ad2+i]&0x7f;buf[pp++]=a;sum=sum+a;}
    buf[pp++]=(128-(sum&0x7f))&0x7f;buf[pp++]=0xf7;

    buf[pp++]=0xff;(*rcd->mix_out)((char *)buf);
    ad=ad+by;ad2=ad2+by;ln=ln-by;twait(3);
  }
}

/***************************/
void	cm6_tone_write(int i)
{
  cm6_write(8*128*128+i*256,0xe34+i*256,256);
}
void	cm6_la_write(int i)
{
  cm6_write(5*128*128+i*8,0xa34+i*8,8);
}
void	cm6_pcm_write(int i)
{
  cm6_write(0x51*128*128+i*19,0x4eb2+i*19,19);
}

/***************************/
void	trns_check()
{
  int	ex,i,ad;

  for(i=0;i<64;i++){
    trf[i]=0;ad=0xe34+i*256;
    if((cm6[ad]==0||cm6[ad]==32)&&(cm6[ad+10]+cm6[ad+16]+cm6[ad+32]+cm6[ad+48]==0)){trf[i]=1;}
  }
  for(i=0;i<128;i++){ad=0xa34+i*8;if(cm6[ad]==2){trf[cm6[ad+1]]=1;}}
  for(i=0;i<85;i++){ex=cm6[0x130+i*4];if(ex<64){trf[ex]=1;}}
}

/***************************/
void	timtra()
{
  all_note_off(1);
  rcd->data_valid=0;rcd->word_valid=0;rcd->tone_valid=0;rcd->gsd_valid=0;
  (*rcd->init)();

  if(cm6_file[0]==0 && gsd_file[0]==0){
    if(init_exc_data[0]!=255){(*rcd->setup)();
    }else{(*rcd->mix_out)((char *)init_exc_data);twait(12);}
  }else{
    if((mdlflag&3)!=0){
      if( cm6_file[0]!=0 ){
	msg(_("Sending control data ..."));tim_buf_trns();
      }
      if( gsd_file[0]!=0 ){
	msg(_("Sending control data ..."));gsd_buf_trns();
      }
      (*rcd->setup)();
      msg_clr();
    }
  }
}

/***************************/
void	all_note_off(int m)
{
  int	i;

  (*rcd->end)();
  if((cmdflag&0x40)!=0){
    /*allnoteoff*/
    for(i=0;i<16;i++){
      (*rcd->md_put2)(0xb0+i);(*rcd->md_put2)(0x7b);(*rcd->md_put2)(0);
    }
    twait(4);
  }
  /*resetall*/
  if(m<2){
    for(i=0;i<16;i++){
      (*rcd->md_put2)(0xb0+i);(*rcd->md_put2)(0x79);(*rcd->md_put2)(0);
    }
    twait(4);
  }
  if((mdlflag&3)==1){
    if(cm6_file[0]!=0 || m==0 ){
      cm6_write(0x10*128*128,0x80,23);cm6_write(0x52*128*128,0x5832,17);
      twait(2);
    }else{
      /*cm6_write(0x7f*128*128,0,1);
	sc55_write(16*128*128+66*128+127,0,1);
	twait(6);*/
    }
  }
}

/***************************/
void	temporary_set()
{
  if(rcd->act==0){
    if((mdlflag&3)==1){
      cm6_write(0x3*128*128,0xa0,144);
      /*cm6_write(0x4*128*128,0x284,1968);*/
      cm6_write(0x50*128*128,0x4e34,126);
    }
  }
}

/***************************/

static char *cm6_tone_name_tmp;

char	*cm6_tone_name(int mo,int i)
{
  int	i0,n,nn;
  char	tmp0[128],tmp1[128];

  if(mo==0){
    /*la tone*/
    i0=cm6[0xa34+i*8]*64+cm6[0xa35+i*8];n=i0&63;nn=i0>>6;
  }else{
    if(mo==1){
      /*pcm tone*/
      i0=cm6[0x4eb2+i*19]*128+cm6[0x4eb3+i*19]+256;n=i0&127;nn=(i0>>7)+2;
    }else{
      /*la rhythm*/
      i0=cm6[0x130+i*4]+128;n=i0&63;nn=i0>>6;
    }
  }

  b_striS(tmp1,128,n+1);strcpy(tmp0,"000");strcat(tmp0,tmp1);
  strcpy(tmp0,&tmp0[strlen(tmp0)-4]);tmp0[0]=tone_hed[nn];
  strcat(tmp0," ");strcat(tmp0,spadd(tim_name[i0],10));
  cm6_tone_name_tmp = tmp0;
  return(cm6_tone_name_tmp);
}

/***************************//*100/1*/
void	twait(int ti)
{
  int	a,b;

  a=ONTIME();
  while(ti>0){b=ONTIME();if(b!=a){a=b;ti--;}}
}

/***************************/
void	gsd_con()
{
  int	ex;

  all_note_off(0);
  msg_clr();gsd_buf_trns();fnc_dis(-1);C_FNKMOD(0);dpl(0);
  ex=exe("ge.x");C_FNKMOD(3);if(ex>0){key_pause();}
  C_FNKMOD(3);C_CUROFF();B_COLOR(3);fnc_dis(-1);gsd_var_read();

  C_WINDOW(0,31);OnGraphic();dpl(1);
  WINDOW(0,0,1023,1023);

  if(ex<0){msg(_("Cannot execute: GE.x"));}
  sdis2(72,64,gsd_file,15,15,0);
}

/***************************/
void	gsinit()
{
  int	i,j;

  for(i=0;i<54;i++){gsd[i]=gsd_sys[i];}
  for(j=0;j<16;j++){
    for(i=0;i<122;i++){gsd[j*122+i+0x36]=gsd_part[i];}
    gsd[j*122+0x38]=j;gsd[j*122+121+0x36]=gsd_rsv[j];
  }
  gsd[9*122+0x14+0x36]=0;gsd[9*122+0x15+0x36]=1;
  for(i=0;i<332;i++){gsd[i+0x7d6]=gsd_rhy[i];gsd[i+0x922]=gsd_rhy[i];}
  for(i=0;i<5;i++){gsd[i+0xa70-2]=gsd_data[i];}
}

/***************************/
