﻿/*
  win32_misc.cpp

  Made by Studio Breeze. 2002

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */
#include "stdafx.h"

#include "sted_win32.h"
#include "sted_screen_win32.h"
#include <mmsystem.h>


int
CSTedScreenWin32::OnTime(void)
{
	DWORD time = ::timeGetTime();
    return (unsigned int)((time/10)%863999);
}

int
CSTedScreenWin32::USleep(long in_usec)
{
	::Sleep(in_usec/1000);
	return 0;
}

void
CSTedScreenWin32::DoMessageLoop(void)
{
	MSG msg;
	int result;

	if(PeekMessage (&msg,NULL,0,0,PM_NOREMOVE)) {
		result = GetMessage(&msg, NULL, 0, 0);
		if (result < 0) {
			// panic!
			exit(0);
		} else if (result==0) {
			exit(0);
		}

		if (!TranslateAccelerator(msg.hwnd, accel_, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	} else {
		Sleep(0);
	}
}

