﻿/* midi_in.c

   midi-port access functions

   Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "sted.h"
#include "sted_screen.h"

int
open_midi_device( char *in_dev_name )
{
  CSTedScreenBase* scr;
  scr = GetDriver();
  if (!scr) return -1;

  return scr->OpenMidiDevice();
}

void
close_midi_device( void )
{
  CSTedScreenBase* scr;
  scr = GetDriver();
  if (!scr) return;

  scr->CloseMidiDevice();
  return;
}

int
get_midi_data( void )
{
  CSTedScreenBase* scr;
  scr = GetDriver();
  if (!scr) return -1;

  return scr->GetMidiData();
}

int
is_midi_in( void )
{
  CSTedScreenBase* scr;
  scr = GetDriver();
  if (!scr) return 0;

  return scr->CanMidiRead();
}

void
put_midi_data ( char in_data )
{
  CSTedScreenBase* scr;
  scr = GetDriver();
  if (!scr) return;

  scr->PutMidiData((int)(in_data+128));
}

// midi player
int
start_player(unsigned char* in_data, int in_len)
{
	if (!in_data) return -1;

	CSTedScreenBase* scr;
	scr = GetDriver();
	if (!scr) return -1;

	return scr->StartMidiPlayer(in_data, in_len);
}

int
stop_player(void)
{
	CSTedScreenBase* scr;
	scr = GetDriver();
	if (!scr) return -1;

	return scr->StopMidiPlayer();
}

int
close_player(int in_sig)
{
	CSTedScreenBase* scr;
	scr = GetDriver();
	if (!scr) return -1;

	return scr->CloseMidiPlayer(in_sig);
}
