﻿/*
  dlg_mididevice.cpp

  Made by Studio Breeze. 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include "stdafx.h"
#include "sted_screen_win32.h"
#include "sted_dialogs.h"

#include "resource.h"

static void DlgMidi_SetListBox(HWND hwnd);
static void DlgMidi_GetParameters(HWND hwnd);

LRESULT CALLBACK
Dlg_MidiDevices(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		DlgMidi_SetListBox(hDlg);
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			if (LOWORD(wParam) == IDOK) {
				DlgMidi_GetParameters(hDlg);
			}
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//

static void
DlgMidi_SetListBox(HWND hwnd)
{
	int min, mout;
	MIDIINCAPS mic;
	MIDIOUTCAPS moc;
	MMRESULT result;
	int i;
	HWND wnd, wnd2;
	BOOL added;

	wnd = ::GetDlgItem(hwnd, IDC_MIDIIN);
	min = ::midiInGetNumDevs();

	added = FALSE;
	if (wnd && min>0) {
		for (i=0; i<min; i++) {
			result = ::midiInGetDevCaps(i, &mic, sizeof(MIDIINCAPS));
			if (result==MMSYSERR_NOERROR) {
				::SendMessage(wnd, CB_ADDSTRING, -1, (LPARAM)mic.szPname);
				added = TRUE;
			}
		}
		if (added) {
			::SendMessage(wnd, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
			::SendMessage(wnd, CB_SETCURSEL, 1, 0);
			::EnableWindow(wnd, TRUE);
		}
	} else if (wnd) {
		::SendMessage(wnd, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
		::SendMessage(wnd, CB_SETCURSEL, 0, 0);
	}


	wnd = ::GetDlgItem(hwnd, IDC_MIDIOUT0);
	wnd2 = ::GetDlgItem(hwnd, IDC_MIDIOUT1);
	mout = ::midiOutGetNumDevs();
	added = FALSE;
	if (mout>0 && wnd && wnd2) {
		for (i=0; i<mout; i++) {
			result = ::midiOutGetDevCaps(i, &moc, sizeof(MIDIOUTCAPS));
			if (result==MMSYSERR_NOERROR) {
				::SendMessage(wnd, CB_ADDSTRING, -1, (LPARAM)moc.szPname);
				::SendMessage(wnd2, CB_ADDSTRING, -1, (LPARAM)moc.szPname);
				added = TRUE;
			}
		}
		if (added) {
			::SendMessage(wnd, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
			::SendMessage(wnd2, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
			::SendMessage(wnd, CB_SETCURSEL, 1, 0);
			::SendMessage(wnd2, CB_SETCURSEL, 1, 0);
			::EnableWindow(wnd, TRUE);
			::EnableWindow(wnd2, TRUE);
		}
	} else {
		if (wnd) {
			::SendMessage(wnd, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
			::SendMessage(wnd, CB_SETCURSEL, 0, 0);
		}
		if (wnd2) {
			::SendMessage(wnd2, CB_INSERTSTRING, 0, (LPARAM)TEXT("--disable--"));
			::SendMessage(wnd, CB_SETCURSEL, 0, 0);
		}
	}
}

static void DlgMidi_GetParameters(HWND hwnd)
{
	HWND wnd;
	CSTedScreenWin32* drv;
	int min, mout[2];
	int index;
	int max;

	drv = (CSTedScreenWin32 *)GetDriver();
	if (!drv) return;

	min = -1;
	wnd = ::GetDlgItem(hwnd, IDC_MIDIIN);
	max = ::midiInGetNumDevs();
	if (wnd) {
		index = (int)::SendMessage(wnd, CB_GETCURSEL, 0, 0);
		if (index<0 || index>max) min = -1;
		else min = index-1;
	}

	mout[0] = -1;
	wnd = ::GetDlgItem(hwnd, IDC_MIDIOUT0);
	max = ::midiOutGetNumDevs();
	if (wnd) {
		index = (int)::SendMessage(wnd, CB_GETCURSEL, 0, 0);
		if (index<0 || index>max) mout[0] = -1;
		else mout[0] = index-1;
	}

	mout[1] = -1;
	wnd = ::GetDlgItem(hwnd, IDC_MIDIOUT1);
	if (wnd) {
		index = (int)::SendMessage(wnd, CB_GETCURSEL, 0, 0);
		if (index<0 || index>max) mout[1] = -1;
		else mout[1] = index-1;
	}

	drv->CloseMidiDevice();
	drv->SetMidiPorts(min, mout);
	drv->OpenMidiDevice();
}

