/*!
******************************************************************************

	@file	rtc.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "rtc.h"
#include "io.h"

bool rtc_get_time( struct tm *tp )
{
	if ( tp == NULL )
		return false;

#ifndef _VSUN86_PCSIM
	//                   秒    分    時    日    月   <-- 年 -->
	const u8 addr[] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
	const u8 max[]  = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
	u8 buf[8];

	int n;
	for ( n=0; n<100; n++ ) {
		bool ok = true;
		for ( int i=0; i<7; i++ )
		{	// CMOSから現在時刻を読み出す
			outb( 0x70, addr[i] );
			buf[i] = inb( 0x71 );
		}
		for ( int i=0; i<7; i++ )
		{	// 読み出した値に問題がないかチェックする
			outb( 0x70, addr[i] );
			if ( (buf[i] != inb( 0x71 )) || (buf[i] > max[i]) || ((buf[i] & 0x0F) > 0x09) )
				ok = false;
		}
		if ( ok )
			break;
	}

	if ( n >= 100 )
		return false;

	tp->tm_year	= (buf[6] >> 4) * 1000 + (buf[6] & 0x0F) * 100 + (buf[5] >> 4) * 10 + (buf[5] & 0x0F) - 1900;
	tp->tm_mon	= (buf[4] >> 4) * 10 + (buf[4] & 0x0F) - 1;
	tp->tm_mday	= (buf[3] >> 4) * 10 + (buf[3] & 0x0F);
	tp->tm_hour	= (buf[2] >> 4) * 10 + (buf[2] & 0x0F);
	tp->tm_min	= (buf[1] >> 4) * 10 + (buf[1] & 0x0F);
	tp->tm_sec	= (buf[0] >> 4) * 10 + (buf[0] & 0x0F);
#else	//_VSUN86_PCSIM
	time_t t = time( NULL );
	memcpy( tp, localtime( &t ), sizeof(struct tm) );
#endif	//_VSUN86_PCSIM

	return true;
}
