/*!
******************************************************************************

	@file	vcpu.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __VCPU_H__
#define __VCPU_H__

#include "svm.h"

#pragma pack(1)

typedef struct {
	u8	 (*read8  )( u32 addr );
	u16	 (*read16 )( u32 addr );
	u32  (*read32 )( u32 addr );
	void (*write8 )( u32 addr, u8  data );
	void (*write16)( u32 addr, u16 data );
	void (*write32)( u32 addr, u32 data );
} VCPU_MMIO_PROCS;

typedef struct {
	SVM_VMCB *		vmcb;
	void *			_padding[3];
	SVM_REG			rcx, rdx, rbx, rbp, rsi, rdi;
	SVM_REG			v_cr0, v_cr2, v_cr3, v_cr4;
	SVM_REG			dr0, dr1, dr2, dr3, dr6, dr7;
	u8				fx_env[0x200];
	int				a20m;
	u32				a20_pte[16];
	VCPU_MMIO_PROCS	mmio[0x60];		// 000A0xxx`000FFxxx
} VCPU;

#define _A20M(vcpu)		((vcpu)->a20m)

#define _ES(vcpu)		((vcpu)->vmcb->stat.es)
#define _CS(vcpu)		((vcpu)->vmcb->stat.cs)
#define _SS(vcpu)		((vcpu)->vmcb->stat.ss)
#define _DS(vcpu)		((vcpu)->vmcb->stat.ds)
#define _FS(vcpu)		((vcpu)->vmcb->stat.fs)
#define _GS(vcpu)		((vcpu)->vmcb->stat.gs)

#define _GDTR(vcpu)		((vcpu)->vmcb->stat.gdtr)
#define _LDTR(vcpu)		((vcpu)->vmcb->stat.ldtr)
#define _IDTR(vcpu)		((vcpu)->vmcb->stat.idtr)
#define _TR(vcpu)		((vcpu)->vmcb->stat.tr)

#define _EFER(vcpu)		((vcpu)->vmcb->stat.efer)

#define R_CR0(vcpu)		((vcpu)->vmcb->stat.cr0)
#define R_CR2(vcpu)		((vcpu)->vmcb->stat.cr2)
#define R_CR3(vcpu)		((vcpu)->vmcb->stat.cr3)
#define R_CR4(vcpu)		((vcpu)->vmcb->stat.cr4)
#define V_CR0(vcpu)		((vcpu)->v_cr0)
#define V_CR2(vcpu)		((vcpu)->v_cr2)
#define V_CR3(vcpu)		((vcpu)->v_cr3)
#define V_CR4(vcpu)		((vcpu)->v_cr4)

#define _DR0(vcpu)		((vcpu)->dr0)
#define _DR1(vcpu)		((vcpu)->dr1)
#define _DR2(vcpu)		((vcpu)->dr2)
#define _DR3(vcpu)		((vcpu)->dr3)
#define _DR6(vcpu)		((vcpu)->vmcb->stat.dr6)
#define _DR7(vcpu)		((vcpu)->vmcb->stat.dr7)

#define _rAX(vcpu)		((vcpu)->vmcb->stat.rax)
#define _rCX(vcpu)		((vcpu)->rcx)
#define _rDX(vcpu)		((vcpu)->rdx)
#define _rBX(vcpu)		((vcpu)->rbx)
#define _rSP(vcpu)		((vcpu)->vmcb->stat.rsp)
#define _rBP(vcpu)		((vcpu)->rbp)
#define _rSI(vcpu)		((vcpu)->rsi)
#define _rDI(vcpu)		((vcpu)->rdi)
#define _rIP(vcpu)		((vcpu)->vmcb->stat.rip)
#define _rFLAGS(vcpu)	((vcpu)->vmcb->stat.rflags)

#define _RAX(vcpu)		(_rAX(vcpu).q)
#define _RCX(vcpu)		(_rCX(vcpu).q)
#define _RDX(vcpu)		(_rDX(vcpu).q)
#define _RBX(vcpu)		(_rBX(vcpu).q)
#define _RSP(vcpu)		(_rSP(vcpu).q)
#define _RBP(vcpu)		(_rBP(vcpu).q)
#define _RSI(vcpu)		(_rSI(vcpu).q)
#define _RDI(vcpu)		(_rDI(vcpu).q)
#define _RIP(vcpu)		(_rIP(vcpu).q)
#define _RFLAGS(vcpu)	(_rFLAGS(vcpu).q)

#define _EAX(vcpu)		(_rAX(vcpu).d)
#define _ECX(vcpu)		(_rCX(vcpu).d)
#define _EDX(vcpu)		(_rDX(vcpu).d)
#define _EBX(vcpu)		(_rBX(vcpu).d)
#define _ESP(vcpu)		(_rSP(vcpu).d)
#define _EBP(vcpu)		(_rBP(vcpu).d)
#define _ESI(vcpu)		(_rSI(vcpu).d)
#define _EDI(vcpu)		(_rDI(vcpu).d)
#define _EIP(vcpu)		(_rIP(vcpu).d)
#define _EFLAGS(vcpu)	(_rFLAGS(vcpu).d)

#define _AX(vcpu)		(_rAX(vcpu).w)
#define _CX(vcpu)		(_rCX(vcpu).w)
#define _DX(vcpu)		(_rDX(vcpu).w)
#define _BX(vcpu)		(_rBX(vcpu).w)
#define _SP(vcpu)		(_rSP(vcpu).w)
#define _BP(vcpu)		(_rBP(vcpu).w)
#define _SI(vcpu)		(_rSI(vcpu).w)
#define _DI(vcpu)		(_rDI(vcpu).w)
#define _IP(vcpu)		(_rIP(vcpu).w)
#define _FLAGS(vcpu)	(_rFLAGS(vcpu).w)

#define _AL(vcpu)		(_rAX(vcpu).bl)
#define _AH(vcpu)		(_rAX(vcpu).bh)
#define _CL(vcpu)		(_rCX(vcpu).bl)
#define _CH(vcpu)		(_rCX(vcpu).bh)
#define _DL(vcpu)		(_rDX(vcpu).bl)
#define _DH(vcpu)		(_rDX(vcpu).bh)
#define _BL(vcpu)		(_rBX(vcpu).bl)
#define _BH(vcpu)		(_rBX(vcpu).bh)

#ifdef __PFEMU_H__
extern bool vcpu_init( VSUN86_VM * );
extern bool vcpu_run( VSUN86_VM *, void * );
extern bool vcpu_set_event( VSUN86_VM *, void * );
extern bool vcpu_set_mmio( VSUN86_VM *, u32, u32, void * );
extern bool vcpu_enable_a20m( VSUN86_VM * );
extern bool vcpu_disable_a20m( VSUN86_VM * );
#endif // __PFEMU_H__

extern VCPU_MMIO_PROCS * vcpu_get_mmio( VCPU *cpu, u32 page );

#define VCPU_SEG_INDEX_NULL	0
#define VCPU_SEG_INDEX_ES	1
#define VCPU_SEG_INDEX_CS	2
#define VCPU_SEG_INDEX_SS	3
#define VCPU_SEG_INDEX_DS	4
#define VCPU_SEG_INDEX_FS	5
#define VCPU_SEG_INDEX_GS	6

extern SVM_VMCB_SEG * vcpu_get_seg( VCPU *cpu, u8 index );

#pragma pack()

#endif // __VCPU_H__
