/*!
******************************************************************************

	@file	mboot.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __MBOOT_H__
#define __MBOOT_H__

#include "common.h"

#pragma pack(1)

typedef struct {
	u32		lower;
	u32		upper;
} MBOOT_MEMORY_INFO;

typedef struct {
	u8		part3;
	u8		part2;
	u8		part1;
	u8		drive;
} MBOOT_BOOT_DEVICE_INFO;

typedef struct {
	u32		count;
	void *	addr;
} MBOOT_MODULE_INFO_HEADER;

typedef struct {
	u32		start;
	u32		end;
	char *	string;
	u32		reserved;
} MBOOT_MODULE_INFO;

typedef struct {
	u32		tabsize;
	u32		strsize;
	void *	addr;
	u32		reserved;
} MBOOT_SYMBOL_INFO;

typedef struct {
	u32		num;
	u32		size;
	void *	addr;
	u32		shndx;
} MBOOT_ELF_SECTION_INFO;

typedef struct {
	u32		length;
	void *	addr;
} MBOOT_MMAP_INFO_HEADER;

typedef struct {
	u32		size;
	u32		base_addr_low;
	u32		base_addr_high;
	u32		length_low;
	u32		length_high;
	u32		type;
} MBOOT_MMAP_INFO;

typedef struct {
	u32		length;
	void *	addr;
} MBOOT_DRIVE_INFO_HEADER;

typedef struct {
	u32		size;
	u8		number;
	u8		mode;
	u16		cylinders;
	u8		heads;
	u8		sectors;
	u16		port[1];
} MBOOT_DRIVE_INFO;

typedef struct {
	u16		version;
	u16		cseg;
	u32		offset;
	u16		cseg_16;
	u16		dseg;
	u16		flags;
	u16		cseg_len;
	u16		cseg_16_len;
	u16		dseg_len;
} MBOOT_APM_INFO;

/*
typedef struct {
	u32					flags;
	u32					mem_lower;
	u32					mem_upper;
	u32					boot_device;
	char *				cmdline;
	u32					mods_count;
	MBOOT_MODULE_INFO *	mods_addr;
	u32					syms[4];
	u32					mmap_length;
	MBOOT_MMAP_INFO *	mmap_addr;
	u32					drives_length;
	MBOOT_DRIVE_INFO *	drives_addr;
	u32					config_table;
	char * 				boot_loader_name;
	MBOOT_APM_INFO *	apm_table;
	u32					vbe_ctrl_info;
	u32					vbe_mode_info;
	u16					vbe_mode;
	u16					vbe_interface_seg;
	u16					vbe_interface_off;
	u16					vbe_interface_len;
} MBOOT_INFO;
*/

#define MBINFO_FLAG_MEMORY			0x00000001
#define MBINFO_FLAG_BOOT_DEVICE		0x00000002
#define MBINFO_FLAG_CMDLINE			0x00000004
#define MBINFO_FLAG_MODULES			0x00000008
#define MBINFO_FLAG_SYMBOLS			0x00000010
#define MBINFO_FLAG_ELF_SECTION		0x00000020
#define MBINFO_FLAG_MMAP			0x00000040
#define MBINFO_FLAG_DRIVES			0x00000080
#define MBINFO_FLAG_CONFIG			0x00000100
#define MBINFO_FLAG_LOADER_NAME		0x00000200
#define MBINFO_FLAG_APM				0x00000400
#define MBINFO_FLAG_GRAPHICS		0x00000800

#pragma pack()

extern bool mboot_init( void * );

extern const MBOOT_MEMORY_INFO *			mboot_get_memory_info( void );
extern const MBOOT_BOOT_DEVICE_INFO *		mboot_get_boot_device( void );
extern const char *							mboot_get_cmdline( void );
extern const MBOOT_MODULE_INFO_HEADER *		mboot_get_module_info_header( void );
extern const MBOOT_SYMBOL_INFO *			mboot_get_symbol_info( void );
extern const MBOOT_ELF_SECTION_INFO *		mboot_get_elf_section_header_table( void );
extern const MBOOT_MMAP_INFO_HEADER *		mboot_get_mmap_info_header( void );
extern const MBOOT_DRIVE_INFO_HEADER *		mboot_get_drive_info_header( void );
extern const void *							mboot_get_config_table( void );
extern const char *							mboot_get_loader_name( void );
extern const MBOOT_APM_INFO *				mboot_get_apm_table( void );


#endif // !__MBOOT_H__
