;=============================================================================
;
; entry.asm
;
; Copyright (c) 2008-2009 Vsun86 Development Project. All rights reserved.
;
;=============================================================================

%define MBHF_PAGE_ALIGN		(1<<0)
%define MBHF_MEM_INFO		(1<<1)
%define MBHF_AOUT_KLUDGE	(1<<16)

%define MBOOT_HEADER_MAGIC	0x1BADB002
%define MBOOT_HEADER_FLAGS	(MBHF_PAGE_ALIGN | MBHF_MEM_INFO | MBHF_AOUT_KLUDGE)
%define MBOOT_CHECKSUM		(-(MBOOT_HEADER_MAGIC + MBOOT_HEADER_FLAGS))

%define VMM_STACK_SIZE		0x00010000

%define IDT_ENTRY_MAX		64
%define SYSCALL_VECTOR		0x20
%define LINT_START_VECTOR	0x28
%define IRQ_START_VECTOR	0x30
%define SEG_VMM_DATA		0x0010

extern code, bss, end
extern vmm_main, vmm_stack
extern excep_handler_table
extern syscall_entry_point
extern local_int_handler
extern irq_handler

;=============================================================================
; macros
;=============================================================================
%macro	ExceptionEntry_0	1
	align	4
int%1_entry:
	push	byte 0		; (dummy)
	push	byte %1
	push	ds
	push	es
	pushad
	push	esp
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	call	[excep_handler_table + %1 * 4]
	pop		esp
	popad
	pop		es
	pop		ds
	add		esp, byte 8
	iretd
%endmacro

%macro	ExceptionEntry_1	1
	align	4
int%1_entry:
	push	byte %1
	push	ds
	push	es
	pushad
	push	esp
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	call	[excep_handler_table + %1 * 4]
	pop		esp
	popad
	pop		es
	pop		ds
	add		esp, byte 8
	iretd
%endmacro

%macro	ExceptionEntry_X	1
	align	4
int%1_entry:
	push	byte 0		; (dummy)
	push	byte %1
	push	ds
	push	es
	pushad
	push	esp
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	call	[excep_handler_table + %1 * 4]
%%.infinity_loop:
	hlt
	jmp		%%.infinity_loop
%endmacro

%macro	SwIntEntry	1
	align	4
int%1_entry:
	push	ds
	push	es
	pushad
	push	esp
	push	byte %1
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	sti
	call	syscall_entry_point
	add		esp, 4
	pop		esp
	popad
	pop		es
	pop		ds
	iretd
%endmacro

%macro	LocalIntEntry	1
	align	4
int%1_entry:
	push	ds
	push	es
	pushad
	push	byte %1
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	call	local_int_handler
	pop		eax
	popad
	pop		es
	pop		ds
	iretd
%endmacro

%macro	HwIntEntry	1
	align	4
int%1_entry:
	push	ds
	push	es
	pushad
	push	byte %1
	mov		eax, SEG_VMM_DATA
	mov		ds, eax
	mov		es, eax
	call	irq_handler
	pop		eax
	popad
	pop		es
	pop		ds
	iretd
%endmacro

%macro	IntTblEntry	1
	dd	int%1_entry
%endmacro


section .entry
;=============================================================================
;
; @brief	VMM Entry Point
;
;=============================================================================
global vmm_entry
vmm_entry:
	cli
	mov		esp, vmm_stack + VMM_STACK_SIZE - 4
	push	ebx
	call	vmm_main
	pop		ebx

.infinity_loop:
	hlt
	jmp		.infinity_loop

	;// Multiboot header
	align	4
mboot:
	dd		MBOOT_HEADER_MAGIC
	dd		MBOOT_HEADER_FLAGS
	dd		MBOOT_CHECKSUM
	dd		mboot
	dd		code
	dd		bss
	dd		end
	dd		vmm_entry



ExceptionEntry_0  0		; #DE
ExceptionEntry_0  1		; #DB
ExceptionEntry_X  2		; NMI
ExceptionEntry_0  3		; #BP
ExceptionEntry_0  4		; #OF
ExceptionEntry_0  5		; #BR
ExceptionEntry_0  6		; #UD
ExceptionEntry_0  7		; #NM
ExceptionEntry_1  8		; #DF
ExceptionEntry_X  9		; (rsvd)
ExceptionEntry_1 10		; #TS
ExceptionEntry_1 11		; #NP
ExceptionEntry_1 12		; #SS
ExceptionEntry_1 13		; #GP
ExceptionEntry_1 14		; #PF
ExceptionEntry_X 15		; (rsvd)
ExceptionEntry_0 16		; #MF
ExceptionEntry_1 17		; #AC
ExceptionEntry_0 18		; #MC
ExceptionEntry_0 19		; #XF

%assign	i 20
%rep	32 - 20
	ExceptionEntry_X i
%assign	i i+1
%endrep

%assign	i SYSCALL_VECTOR
%rep	8
	SwIntEntry i
%assign	i i+1
%endrep

%assign	i LINT_START_VECTOR
%rep	8
	LocalIntEntry i
%assign	i i+1
%endrep

%assign	i IRQ_START_VECTOR
%rep	16
	HwIntEntry i
%assign	i i+1
%endrep

	align	16, db 0x00
;=============================================================================
;
; @brief	INT Handler Entry Point Table
;
;=============================================================================
global int_ptr_table
int_ptr_table:

%assign i 0
%rep	IDT_ENTRY_MAX
	IntTblEntry	i
%assign i i+1
%endrep
