/*!
******************************************************************************

	@file	scsi.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __SCSI_H__
#define __SCSI_H__

#pragma pack(1)

typedef bool (*SCSI_SEND_CMD)( void *bus_dev, void *cmd, u32 cmd_len, void *buf, u32 buf_len, bool dir_in );

typedef struct {
	void *			bus_dev;
	SCSI_SEND_CMD	send_cmd;
} SCSI_DEVICE;

typedef struct {
	u8		cmd;
	u8		data[5];
} SCSI_CDB6;

typedef struct {
	u8		cmd;
	u8		data[9];
} SCSI_CDB10;

#define SCSI_CMD_INQUIRY		0x12
#define SCSI_CMD_READ_CAPACITY	0x25
#define SCSI_CMD_READ			0x28

typedef struct {
	u8		cmd;
	u8		evpd		: 1;
	u8		obsolete	: 1;
	u8		rsvd		: 6;
	u8		page_code;
	u16		alloc_len;
	u8		ctrl;
} SCSI_CDB_INQUIRY;

typedef struct {
	u8		cmd;
	u8		flags;
	u32		block_addr;
	u8		group_num;
	u16		xfer_len;
	u8		ctrl;
} SCSI_CDB_READ;

typedef struct {
	u8		dev_type	: 5;
	u8		qualifier	: 3;
	u8		rsvd		: 7;
	u8		removable	: 1;
	u8		version;
	u8		resp_fmt	: 4;
	u8		hi_sup		: 1;
	u8		norm_aca	: 1;
	u8		obsolete	: 2;
	u8		add_len;
	u8		flags[3];
	char	vendor_id[8];
	char	product_id[16];
	char	revision[4];
} SCSI_STD_INQUIRY_DATA;

#define STD_INQUIRY_FL1_PROTECT		0x01
#define STD_INQUIRY_FL1_3PC			0x08
#define STD_INQUIRY_FL1_TPGS		0x30
#define STD_INQUIRY_FL1_ACC			0x40
#define STD_INQUIRY_FL1_SCCS		0x80
#define STD_INQUIRY_FL2_ADDR16		0x01
#define STD_INQUIRY_FL2_MULTI_P		0x10
#define STD_INQUIRY_FL2_VS			0x20
#define STD_INQUIRY_FL2_ENC_SERV	0x40
#define STD_INQUIRY_FL3_VS			0x01
#define STD_INQUIRY_FL3_CMD_QUE		0x02
#define STD_INQUIRY_FL3_SYNC		0x10
#define STD_INQUIRY_FL3_WBUS16		0x20

typedef struct {
	u32		last_block;
	u32		block_len;
} SCSI_DISK_CAPACITY;

#pragma pack()

extern bool scsi_cmd_inquiry( SCSI_DEVICE *, SCSI_STD_INQUIRY_DATA * );
extern bool scsi_cmd_read_capacity( SCSI_DEVICE *, SCSI_DISK_CAPACITY * );
extern bool scsi_cmd_read( SCSI_DEVICE *, u32, u16, void *, u32 );

#endif // !__SCSI_H__
