/*!
******************************************************************************

	@file	ata.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __ATA_H__
#define __ATA_H__

#pragma pack(1)

#define IO_ATA0_DATA		0x01F0		// R/W
#define IO_ATA0_ERROR		0x01F1		// R
#define IO_ATA0_FEATURES	0x01F1		// W
#define IO_ATA0_SECTOR_CNT	0x01F2		// R/W
#define IO_ATA0_SECTOR_NUM	0x01F3		// R/W
#define IO_ATA0_CYLINDER_L	0x01F4		// R/W
#define IO_ATA0_CYLINDER_H	0x01F5		// R/W
#define IO_ATA0_DEV_HEAD	0x01F6		// R/W
#define IO_ATA0_STATUS		0x01F7		// R
#define IO_ATA0_CMD			0x01F7		// W
#define IO_ATA0_ALT_STATUS	0x03F6		// R
#define IO_ATA0_DEV_CTRL	0x03F6		// W
#define IO_ATA1_DATA		0x0170		// R/W
#define IO_ATA1_ERROR		0x0171		// R
#define IO_ATA1_FEATURES	0x0171		// W
#define IO_ATA1_SECTOR_CNT	0x0172		// R/W
#define IO_ATA1_SECTOR_NUM	0x0173		// R/W
#define IO_ATA1_CYLINDER_L	0x0174		// R/W
#define IO_ATA1_CYLINDER_H	0x0175		// R/W
#define IO_ATA1_DEV_HEAD	0x0176		// R/W
#define IO_ATA1_STATUS		0x0177		// R
#define IO_ATA1_CMD			0x0177		// W
#define IO_ATA1_ALT_STATUS	0x0376		// R
#define IO_ATA1_DEV_CTRL	0x0376		// W

// PACKETコマンド用
#define IO_ATA0_INT_REASON	0x01F2		// R
#define IO_ATA0_BYTE_CNT_L	0x01F4		// R/W
#define IO_ATA0_BYTE_CNT_H	0x01F5		// R/W
#define IO_ATA1_INT_REASON	0x0172		// R
#define IO_ATA1_BYTE_CNT_L	0x0174		// R/W
#define IO_ATA1_BYTE_CNT_H	0x0175		// R/W

// Statusレジスタ
#define ATA_STATUS_ERR		0x01
#define ATA_STATUS_DRQ		0x08
#define ATA_STATUS_DF		0x20
#define ATA_STATUS_DRDY		0x40
#define ATA_STATUS_BSY		0x80

// Device/Headレジスタ
#define ATA_DEV_SHIFT		4
#define ATA_DEV_LBA			0x40

// Commandレジスタ
#define ATA_CMD_NOP						0x00
#define ATA_CMD_READ_SECTORS			0x20
#define ATA_CMD_IDENTIFY_PACKET_DEVICE	0xA1
#define ATA_CMD_IDENTIFY_DEVICE			0xEC

typedef struct {
	u16		data;
	u16		error;
	u16		features;
	union {
		u16	sector_cnt;
		u16	int_reason;
	};
	union {
		u16	sector_num;
		u16	lba_l;
	};
	union {
		u16	cylinder_l;
		u16	lba_m;
		u16	byte_cnt_l;
	};
	union {
		u16	cylinder_h;
		u16	lba_h;
		u16	byte_cnt_h;
	};
	u16		dev_head;
	u16		status;
	u16		cmd;
	u16		alt_status;
	u16		dev_ctrl;
} ATA_IO_PORTS;

typedef struct {
	ATA_IO_PORTS *	ports;
	u8				id;
	u8				irq;
	bool			present;
} ATA_DEVICE;

typedef union {
	u16		w[256];
	struct {
		u16		flags;
		u16		_w1_obs;
		u16		specific_conf;
		u16		_w3_obs;
		u16		_w4to5_retired[2];
		u16		_w6_obs;
		u16		_w7to8_rsvd[2];
		u16		_w9_retired;
		u16		serial_number[10];
		u16		_w20to21_retired[2];
		u16		_w22_obs;
		u16		firmware_rev[4];
		u16		model_number[20];
		u16		flags2;
		u16		_w48_rsvd;
		u16		capabilities[1];
	};
} ATA_IDENTIFY_DEVICE_DATA;

#pragma pack()

extern bool ata_init( void );
extern bool ata_start( void );
extern bool ata_select_device( ATA_DEVICE *dev );
extern bool ata_pio_read( ATA_DEVICE *dev, u8 cmd, void *buf, size_t buf_len, bool buf_filled );

extern bool ata_cmd_read_sectors( ATA_DEVICE *dev, u32 lba, u8 sectors, void *buf );
extern bool ata_cmd_identify_device( ATA_DEVICE *dev, ATA_IDENTIFY_DEVICE_DATA *data );
extern bool ata_cmd_identify_packet_device( ATA_DEVICE *dev, ATA_IDENTIFY_DEVICE_DATA *data );

#endif //!__ATA_H__
