/*!
******************************************************************************

	@file	disk.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __DISK_H__
#define __DISK_H__

#ifndef _VSUN86_PCSIM
#include "disk/scsi.h"
#include "disk/ata.h"
#endif	//!_VSUN86_PCSIM

#pragma pack(1)

typedef struct {
	bool	valid;
	u8		ctrl;
	u8		int13h_drive;
	union {
#ifndef _VSUN86_PCSIM
		SCSI_DEVICE	scsi;
		ATA_DEVICE	ata;
#else	//_VSUN86_PCSIM
		int	vdisk_index;
#endif	//_VSUN86_PCSIM
	} dev;
	char	vendor_id[8];
	char	product_id[16];
	char	revision[4];
	u32		last_block;
	u32		block_len;
} DISK_INFO;

#define DISK_ID_MAX			16

#define DISK_CTRL_UNKNOWN	0x00
#ifndef _VSUN86_PCSIM
#define DISK_CTRL_FLOPPY	0x01
#define DISK_CTRL_SCSI		0x02
#define DISK_CTRL_ATA		0x03
#define DISK_CTRL_ATAPI		0x04
#else	//_VSUN86_PCSIM
#define DISK_CTRL_VDISK		0xFF
#endif	//_VSUN86_PCSIM

#pragma pack()

extern bool disk_init( void );
extern bool disk_start( void );
#ifndef _VSUN86_PCSIM
extern bool disk_register_scsi( SCSI_DEVICE *dev );
extern bool disk_register_ata( ATA_DEVICE *dev, ATA_IDENTIFY_DEVICE_DATA *data );
#else	//_VSUN86_PCSIM
extern bool disk_register_vdisk( int vdisk_index, u64 *capacity );
#endif	//_VSUN86_PCSIM
extern u32  disk_get_num( void );
extern bool disk_get_info( u32 disk_id, DISK_INFO *info );
extern bool disk_read( u32 disk_id, u32 block_addr, u16 block_len, void *buf, u32 buf_len );

#endif // !__DISK_H__
