/*!
******************************************************************************

	@file	cpuid.h

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#ifndef __CPUID_H__
#define __CPUID_H__

#include "common.h"

#define cpuid( op, __b, __c, __d )									\
({																	\
	u32 __a;														\
	__ASM__( "cpuid"												\
			: "=a"(__a), "=b"(*(__b)), "=c"(*(__c)), "=d"(*(__d))	\
			: "0"(op) );											\
	__a;															\
})

// [AMD] Fn8000_0000
#define CPUID_AMD_Fn8000_0000_EBX		0x68747541	// "Auth"
#define CPUID_AMD_Fn8000_0000_EDX		0x69746E65	// "enti"
#define CPUID_AMD_Fn8000_0000_ECX		0x444D4163	// "cAMD"
// [AMD] Fn8000_0001
#define CPUID_AMD_Fn8000_0001_ECX_SVM	0x00000004
#define CPUID_AMD_Fn8000_0001_EDX_MTRR	0x00001000
// [AMD] Fn8000_000A
#define CPUID_AMD_Fn8000_000A_EDX_NP	0x00000001
#define CPUID_AMD_Fn8000_000A_EDX_SVML	0x00000004

#endif // !__CPUID_H__
