/*!
******************************************************************************

	@file	ctype.c

	Copyright (C) 2008 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include <ctype.h>

#define _N	0x01	// 数字(0～9)
#define _U	0x02	// 英大文字(A～Z)
#define _L	0x04	// 英小文字(a～z)

static unsigned char ctype[128] =
{
	/* 0x00 : NUL */	0,
	/* 0x01 : SOH */	0,
	/* 0x02 : STX */	0,
	/* 0x03 : ETX */	0,
	/* 0x04 : EOT */	0,
	/* 0x05 : ENQ */	0,
	/* 0x06 : ACK */	0,
	/* 0x07 : BEL */	0,
	/* 0x08 : BS  */	0,
	/* 0x09 : HT  */	0,
	/* 0x0A : LF  */	0,
	/* 0x0B : VT  */	0,
	/* 0x0C : NP  */	0,
	/* 0x0D : CR  */	0,
	/* 0x0E : SO  */	0,
	/* 0x0F : SI  */	0,
	/* 0x10 : DLE */	0,
	/* 0x11 : DC1 */	0,
	/* 0x12 : DC2 */	0,
	/* 0x13 : DC3 */	0,
	/* 0x14 : DC4 */	0,
	/* 0x15 : NAK */	0,
	/* 0x16 : SYN */	0,
	/* 0x17 : ETB */	0,
	/* 0x18 : CAN */	0,
	/* 0x19 : EM  */	0,
	/* 0x1A : SUB */	0,
	/* 0x1B : ESC */	0,
	/* 0x1C : FS  */	0,
	/* 0x1D : GS  */	0,
	/* 0x1E : RS  */	0,
	/* 0x1F : US  */	0,
	/* 0x20 : SP  */	0,
	/* 0x21 : !   */	0,
	/* 0x22 : "   */	0,
	/* 0x23 : #   */	0,
	/* 0x24 : $   */	0,
	/* 0x25 : %   */	0,
	/* 0x26 : &   */	0,
	/* 0x27 : '   */	0,
	/* 0x28 : (   */	0,
	/* 0x29 : )   */	0,
	/* 0x2A : *   */	0,
	/* 0x2B : +   */	0,
	/* 0x2C : ,   */	0,
	/* 0x2D : -   */	0,
	/* 0x2E : .   */	0,
	/* 0x2F : /   */	0,
	/* 0x30 : 0   */	_N,
	/* 0x31 : 1   */	_N,
	/* 0x32 : 2   */	_N,
	/* 0x33 : 3   */	_N,
	/* 0x34 : 4   */	_N,
	/* 0x35 : 5   */	_N,
	/* 0x36 : 6   */	_N,
	/* 0x37 : 7   */	_N,
	/* 0x38 : 8   */	_N,
	/* 0x39 : 9   */	_N,
	/* 0x3A : :   */	0,
	/* 0x3B : ;   */	0,
	/* 0x3C : <   */	0,
	/* 0x3D : =   */	0,
	/* 0x3E : >   */	0,
	/* 0x3F : ?   */	0,
	/* 0x40 : @   */	0,
	/* 0x41 : A   */	_U,
	/* 0x42 : B   */	_U,
	/* 0x43 : C   */	_U,
	/* 0x44 : D   */	_U,
	/* 0x45 : E   */	_U,
	/* 0x46 : F   */	_U,
	/* 0x47 : G   */	_U,
	/* 0x48 : H   */	_U,
	/* 0x49 : I   */	_U,
	/* 0x4A : J   */	_U,
	/* 0x4B : K   */	_U,
	/* 0x4C : L   */	_U,
	/* 0x4D : M   */	_U,
	/* 0x4E : N   */	_U,
	/* 0x4F : O   */	_U,
	/* 0x50 : P   */	_U,
	/* 0x51 : Q   */	_U,
	/* 0x52 : R   */	_U,
	/* 0x53 : S   */	_U,
	/* 0x54 : T   */	_U,
	/* 0x55 : U   */	_U,
	/* 0x56 : V   */	_U,
	/* 0x57 : W   */	_U,
	/* 0x58 : X   */	_U,
	/* 0x59 : Y   */	_U,
	/* 0x5A : Z   */	_U,
	/* 0x5B : [   */	0,
	/* 0x5C : \   */	0,
	/* 0x5D : ]   */	0,
	/* 0x5E : ^   */	0,
	/* 0x5F : _   */	0,
	/* 0x60 : `   */	0,
	/* 0x61 : a   */	_L,
	/* 0x62 : b   */	_L,
	/* 0x63 : c   */	_L,
	/* 0x64 : d   */	_L,
	/* 0x65 : e   */	_L,
	/* 0x66 : f   */	_L,
	/* 0x67 : g   */	_L,
	/* 0x68 : h   */	_L,
	/* 0x69 : i   */	_L,
	/* 0x6A : j   */	_L,
	/* 0x6B : k   */	_L,
	/* 0x6C : l   */	_L,
	/* 0x6D : m   */	_L,
	/* 0x6E : n   */	_L,
	/* 0x6F : o   */	_L,
	/* 0x70 : p   */	_L,
	/* 0x71 : q   */	_L,
	/* 0x72 : r   */	_L,
	/* 0x73 : s   */	_L,
	/* 0x74 : t   */	_L,
	/* 0x75 : u   */	_L,
	/* 0x76 : v   */	_L,
	/* 0x77 : w   */	_L,
	/* 0x78 : x   */	_L,
	/* 0x79 : y   */	_L,
	/* 0x7A : z   */	_L,
	/* 0x7B : {   */	0,
	/* 0x7C : |   */	0,
	/* 0x7D : }   */	0,
	/* 0x7E : ~   */	0,
	/* 0x7F : DEL */	0,
};

__inline int isdigit( int c )
{
	if ( (0 <= c) && (c < (int)sizeof(ctype)) )
		return ctype[c] & _N;

	return 0;
}
