﻿/*
 *  Copyright 2008 tarotarorg
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.tarotaro.flash.pv3d {
    import flash.utils.Dictionary;
    import mx.collections.ArrayCollection;
    import mx.collections.ICollectionView;
    import mx.collections.Sort;
    import mx.collections.SortField;
    import mx.controls.treeClasses.DefaultDataDescriptor;
    import mx.controls.treeClasses.ITreeDataDescriptor;
	import org.papervision3d.objects.DisplayObject3D;

    public class DisplayObject3DTreeDataDescriptor implements ITreeDataDescriptor{
        private static var defaultDataDescriptor:DefaultDataDescriptor = new DefaultDataDescriptor();
        
        public function DisplayObject3DTreeDataDescriptor():void {
        }
        
        public function addChildAt(parent:Object, newChild:Object, index:int, model:Object = null):Boolean {
            return false;
        }
        public function getChildren(node:Object, model:Object = null):ICollectionView {
            var mqo:DisplayObject3D = node as DisplayObject3D;
            if(mqo == null) {
                return defaultDataDescriptor.getChildren(node , model);
            } else {
                var modelArray:ArrayCollection = new ArrayCollection();
                var sort:Sort = new Sort();
                sort.fields = [new SortField("name")];
                modelArray.sort = sort;
                var children:Object = mqo.children;
                if (children != null) {
                    for(var name:Object in children) {
                        modelArray.addItem(children[name]);
                    }
                    modelArray.refresh();
                }
                return modelArray;
            }
        }
        public function getData(node:Object, model:Object = null):Object {
            var mqo:DisplayObject3D = node as DisplayObject3D;
            if(mqo == null) {
                return defaultDataDescriptor.getData(node , model);
            } else {
                return mqo.name;
            }
        }
        public function hasChildren(node:Object, model:Object = null):Boolean {
            var mqo:DisplayObject3D = node as DisplayObject3D;
            if(mqo == null) {
                return defaultDataDescriptor.hasChildren(node , model);
            } else {
                return mqo.childrenList().length > 0;
            }
        }
        public function isBranch(node:Object, model:Object = null):Boolean {
            return this.hasChildren(node , model);
        }
        public function removeChildAt(parent:Object, child:Object, index:int, model:Object = null):Boolean {
            return false;
        }

    }
    
}
