﻿/**
 * @author b2ox
 */
package org.b2ox.flash3d.MikuMikuDance
{
	import org.b2ox.flash3d.MikuMikuDance.*;

	/**
	 * ボーンパラメータ列の格納
	 */
	public class VMDBoneParamSequence
	{
		private var keyFrame:Vector.<KeyFrameInfo> = new Vector.<KeyFrameInfo>();
		private var frameLength:int = 0;
		public var boneName:String;

		/**
		 * コンストラクタ.
		 * @param	boneName	パラメータ列の対象となるボーン名
		 */
		public function VMDBoneParamSequence(boneName:String):void 
		{
			this.boneName = boneName;
		}

		/**
		 * ボーンパラメータの追加
		 * @param	frameNo	追加先のフレーム番号
		 * @param	param
		 */
		public function addBoneParam(frameNo:int, param:VMDBoneParam):void
		{
			// 既に登録済みのフレームの場合は上書き
			for (var i:int = keyFrame.length-1; i >= 0; i--)
			{
				if (keyFrame[i].frameNo == frameNo) {
					keyFrame[i].param = param;
					return;
				}
			}
			keyFrame.push(new KeyFrameInfo(frameNo, param));
		}

		/**
		 * パラメータ列の整理.
		 * 全パラメータ登録後に実行すること
		 * @param	frameLength
		 */
		public function fixSequence(frameLength:int):void
		{
			keyFrame = keyFrame.sort(KeyFrameInfo.compare);
			keyFrame.fixed = true;
			this.frameLength = frameLength;
			trace("bone["+boneName+"]: キーフレーム総数 "+keyFrame.length);
		}

		/**
		 * 2分探索でkeyFrame配列中にframeNoが所属する区間の先頭を求める
		 * @param	start
		 * @param	end
		 * @param	frameNo
		 * @return
		 */
		private function searchRange(start:int, end:int, frameNo:int):int
		{
			if (keyFrame[start].frameNo == frameNo || end == start + 1) return start;
			var n:int = (start + end) / 2;
			if (frameNo < keyFrame[n].frameNo) return searchRange(start, n, frameNo);
			return searchRange(n, end, frameNo);
		}

		/**
		 * frameNoにおけるボーンパラメータを得る
		 * @param	frameNo
		 * @return
		 */
		public function getBoneParam(frameNo: int):VMDBoneParam
		{
			var n:int = keyFrame.length - 1;
			var kf:KeyFrameInfo = keyFrame[n];
			if (kf.frameNo <= frameNo) return kf.param;
			n = searchRange(0, n, frameNo);
			kf = keyFrame[n];
			var kf2:KeyFrameInfo = keyFrame[n + 1];
			var t:Number = (frameNo - kf.frameNo) / (kf2.frameNo - kf.frameNo);
			return kf.param.interpolateParam(kf2.param, t);
		}
	}
}

import org.b2ox.flash3d.MikuMikuDance.*;

class KeyFrameInfo
{
	public var frameNo:int;
	public var param:VMDBoneParam;

	public function KeyFrameInfo(frameNo:int, param:VMDBoneParam):void
	{
		this.frameNo = frameNo;
		this.param = param;
	}
	
	public static function compare(a:KeyFrameInfo, b:KeyFrameInfo):Number
	{
		return (a.frameNo == b.frameNo) ? 0 : (a.frameNo < b.frameNo) ? -1 : 1;
	}
}