﻿package
{
	import com.adobe.serialization.json.JSON;
	import flash.display.*;
	import flash.media.*;
	import flash.net.URLRequest;
	import net.hires.debug.*;
	import org.b2ox.flash3d.*;
	import org.b2ox.thread.*;
	import org.libspark.thread.*;
	import org.libspark.thread.threads.net.*;
	import org.libspark.thread.threads.utils.*;
	import org.libspark.thread.utils.*;
	import mx.controls.*;

	public class PMDViewerJSON extends Thread
	{
		private const jsonURL:String = "PMDViewer.json";
		private var pmdviewer:PMDViewer;

		//[Embed(source = '../img/vocaloplus.png')] public var logoCls:Class;
		// Flex4でSVGを扱う場合は Show Deprecation Warningsをfalseにしておく必要有り。将来的にはSVGからFXGに移行しろってことらしい。
		[Embed(source = '../img/vocaloplus.svg')][Bindable] public var logoSvgCls:Class;
		[Embed(source = '../mp3/vocaloplus_eyecatch.mp3')] public var eyecatchCls:Class;


		static public function init(pmdviewer:PMDViewer, msgArea:Text):void
		{
			new PMDViewerJSON(pmdviewer, msgArea).start();
		}

		private var msgArea:Text;
		public function PMDViewerJSON(pmdviewer:PMDViewer, msgArea:Text):void
		{
			this.pmdviewer = pmdviewer;
			this.msgArea = msgArea;
		}

		override protected function run():void
		{
			// FPSなどの表示
			var stat:Stats = new Stats();
			stat.y = 30;
			pmdviewer.addChild(stat);

			// ロゴ画像の貼り付け
			//var logo:Bitmap = new logoCls();
			var logo:Sprite = new logoSvgCls();
			logo.scaleX = 0.09;
			logo.scaleY = 0.09;
			pmdviewer.addChild(logo);

			Sound(new eyecatchCls()).play(); // サウンドロゴの再生

			var th:SerialExecutor = new SerialExecutor();
			var urlloader:URLLoaderThread = new URLLoaderThread(new URLRequest(jsonURL));
			th.addThread( new FunctionThread(function ():void { msgArea.text = "loading: "+jsonURL }) );
			th.addThread( new TraceThread(jsonURL+"を読み込みます") );
			th.addThread( urlloader );
			th.addThread( new FunctionThread(function ():void { execConfig( JSON.decode(urlloader.loader.data.replace(/\r\n|\r/g, '\n')) ); } ) );
			th.start();
			th.join();
		}

		private function execConfig(config:Object):void
		{
			var url:String, scale:Number, x:Number, y:Number, z:Number;
			if (! (config["pmd"] is Array)) {
				trace(jsonURL + "にpmd配列がありません");
				return;
			}

			var loaders:ParallelExecutor = new ParallelExecutor();
			for each (var obj:Object in (config["pmd"] as Array)) {
				if (obj["url"] is String) {
					url = obj["url"];
				} else {
					trace("urlがありません");
					continue;
				}
				if (obj["scale"] is Number) {
					scale = obj["scale"];
				} else {
					trace("scaleがないのでデフォルト値1.0を使います");
					scale = 1.0;
				}
				if (obj["x"] is Number) {
					x = obj["x"];
				} else {
					trace("xがないのでデフォルト値0.0を使います");
					x = 0.0;
				}
				if (obj["y"] is Number) {
					y = obj["y"];
				} else {
					trace("yがないのでデフォルト値0.0を使います");
					y = 0.0;
				}
				if (obj["z"] is Number) {
					z = obj["z"];
				} else {
					trace("zがないのでデフォルト値0.0を使います");
					z = 0.0;
				}
				if (obj["vmd"] is Array) {
					loaders.addThread(mmdLoaderThread(url, scale, x, y, z, obj["vmd"]));
				} else {
					trace(jsonURL + "の /pmd@url=" + url + "にvmd配列がありません");
				}
			}

			loaders.start();
			loaders.join();
			next(allComplete);
		}
		private function mmdLoaderThread(url:String, scale:Number, x:Number, y:Number, z:Number, vmd:Array):SerialExecutor
		{
			var mmd:MikuMikuDance = new MikuMikuDance();
			mmd.looping = true;
			mmd.x = x;
			mmd.y = y;
			mmd.z = z;
			mmd.addEventListener(MikuMikuDance.MOTION_ADDED, function (e:Event):void { msgArea.text = mmd.motionName } );
			mmd.addEventListener(MikuMikuDance.MOTION_CHANGED, function (e:Event):void { msgArea.text = mmd.motionName } );

			var sloaders:SerialExecutor = new SerialExecutor();
			trace("addThread: pmdLoader(" + url + "," + scale + ")" );
			sloaders.addThread(mmd.makePMDLoader(url, scale));
			sloaders.addThread(new FunctionThread(function ():void { msgArea.text = "model loaded: " + url }));
			sloaders.addThread(new TraceThread("addMMD:" + url));
			sloaders.addThread(new FunctionThread(pmdviewer.addMMD, mmd));
			var vmdUrl:String, vmdName:String;
			for each (var obj:Object in vmd) {
				if (obj["url"] is String) {
					vmdUrl = obj["url"];
				} else {
					trace("urlがありません");
					continue;
				}
				if (obj["name"] is String) {
					vmdName = obj["name"];
				} else {
					trace("nameがありません");
					continue;
				}
				trace("addThread: vmdLoader(" + vmdUrl + "," + vmdName + ")" );
				sloaders.addThread(mmd.makeVMDLoader(vmdUrl, vmdName));
				sloaders.addThread(new FunctionThread(function ():void { msgArea.text = "motion loaded: " + vmdName + " ( " + vmdUrl + " )" }));
			}
			// sloaders.addThread(new FuncThread(function ():void { mmd.changeMotionByID(0); } ));

			return sloaders;
		}
		private function allComplete():void
		{
			msgArea.text = jsonURL + "の読み込み処理が完了しました。";
			
			trace(jsonURL+"の読み込み処理が完了しました。");
		}
	}
}
