﻿package
{
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import net.hires.debug.*;
	import org.b2ox.pv3d.*;
	import org.b2ox.thread.*;
	import org.libspark.thread.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.view.*;
	//	import org.papervision3d.render.*;

	public class PMDViewer extends BasicView
	{
		public const jsonURL:String = "PMDViewer.json";

		private var rootNode:DisplayObject3D = null;
		private var cameraDistance:Number = 1000;
		private var cameraDistanceMin:Number = 100;
		private var cameraAngleX:Number = 0;
		private var cameraAngleY:Number = 0;

		public var MMDs:Vector.<MikuMikuDance> = new Vector.<MikuMikuDance>();
		private var glass:Boolean = false;
		private var punpun:Boolean = false;
		private var headset:Boolean = true;

		//[Embed(source = '../img/vocaloplus.png')] public var logoCls:Class;
		// Flex4でSVGを扱う場合は Show Deprecation Warningsをfalseにしておく必要有り。将来的にはSVGからFXGに移行しろってことらしい。
		[Embed(source = '../img/vocaloplus.svg')][Bindable] public var logoSvgCls:Class;
		[Embed(source = '../mp3/vocaloplus_eyecatch.mp3')] public var eyecatchCls:Class;

		public function PMDViewer():void
		{
			if (!Thread.isReady) Thread.initialize(new EnterFrameThreadExecutor());

			viewport.interactive = true;

			// 3D シーンにルートオブジェクトを作る。
			rootNode = scene.addChild(new DisplayObject3D("rootNode"));

			// カメラ設定
			camera.zoom = 800;
			camera.focus = 2;
			camera.x = 0;
			camera.y = 0;
			camera.z = -cameraDistance;
			calcCamera();

			// リスナ登録
			// stage.addEventListener にするとビルドは通るけどまともに動かない
			addEventListener(MouseEvent.MOUSE_DOWN, mouseDownEventHandler);
			addEventListener(MouseEvent.MOUSE_UP, mouseUpEventHandler);
			addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveEventHandler);
			addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelEventHandler);

			// ポリゴン欠けは改善されるが負荷がとんでもない
			// renderer = new QuadrantRenderEngine(QuadrantRenderEngine.ALL_FILTERS);
			trace("startRendering");
			startRendering();

			var stat:Stats = new Stats();
			addChild(stat);
			stat.y = 30;

			//var logoPng:Bitmap = new logoCls();
			//addChild(logoPng);

			var logoSvg:Sprite = new logoSvgCls();
			addChild(logoSvg);
			logoSvg.scaleX = 0.09;
			logoSvg.scaleY = 0.09;

			var eyecatch:Sound = new eyecatchCls();
			eyecatch.play();

			(new InitialLoaderThread(this)).start();
		}

		private var pi180:Number = Math.PI / 180;
		private function calcCamera():void
		{
			rootNode.rotationY = cameraAngleY;
			camera.y = cameraDistance * Math.sin(cameraAngleX * pi180);
			camera.z = -cameraDistance * Math.cos(cameraAngleX * pi180);
		}

		private var isMouseDown:Boolean = false;
		private var _startMouseX:Number = 0, _startMouseY:Number = 0;
		private var _startCameraX:Number = 0, _startCameraY:Number = 0;
		private var _startCameraAngleX:Number = 0, _startCameraAngleY:Number = 0;
		private function mouseDownEventHandler(event:MouseEvent):void{
			isMouseDown = true;
			_startMouseX = this.mouseX;
			_startMouseY = this.mouseY;
			_startCameraX = rootNode.x;
			_startCameraY = rootNode.y;
			_startCameraAngleX = rootNode.rotationX;
			_startCameraAngleY = rootNode.rotationY;
		}

		private function mouseUpEventHandler(event:MouseEvent):void{
			isMouseDown = false;
		}

		private function mouseMoveEventHandler(event:MouseEvent):void{
			if (isMouseDown == false) return;
			if (event.shiftKey) {
				// shift+ドラッグ
				// 平行移動のコードを書く
				rootNode.x = _startCameraX - _startMouseX + this.mouseX;
				rootNode.y = _startCameraY + _startMouseY - this.mouseY;
			} else {
				cameraAngleX = _startCameraAngleX - _startMouseY + this.mouseY;
				cameraAngleY = _startCameraAngleY + _startMouseX - this.mouseX;
				if (cameraAngleX >= 180) cameraAngleX = 180;
				if (cameraAngleX <= -180) cameraAngleX = -180;
				calcCamera();
			}
		}

		private function mouseWheelEventHandler(event:MouseEvent):void {
			cameraDistance -= event.delta * 10;
			if (cameraDistance < cameraDistanceMin) cameraDistance = cameraDistanceMin;
			calcCamera();
		}

		//-------------------------------------------------

		public function addMMD(mmd:MikuMikuDance):void
		{
			rootNode.addChild(mmd);
			MMDs.push(mmd);
		}

		public function toggleMotion():void
		{
			for each (var mmd:MikuMikuDance in MMDs) {
				mmd.stop(); mmd.changeNextMotion(); mmd.play();
			}
		}

		public function play():void {
			for each (var mmd:MikuMikuDance in MMDs) {
				mmd.play();
			}
		}
		public function stop():void {
			for each (var mmd:MikuMikuDance in MMDs) {
				mmd.stop();
			}
		}
	}
}

import com.adobe.serialization.json.JSON;
import flash.net.URLRequest;
import org.b2ox.pv3d.*;
import org.b2ox.thread.*;
import org.libspark.thread.*;
import org.libspark.thread.threads.net.*;
import org.libspark.thread.utils.*;

class InitialLoaderThread extends Thread
{
	private var pmdviewer:PMDViewer;
	private var worker:SerialExecutor;
	public var config:Object;

	public function InitialLoaderThread(pmdviewer:PMDViewer):void
	{
		this.pmdviewer = pmdviewer;
	}

	override protected function run():void
	{
		worker = new SerialExecutor();
		worker.addThread( new URLLoaderThread(new URLRequest(pmdviewer.jsonURL)) );
		worker.start();
		worker.join();
		next(loadComplete);
	}
	private function loadComplete():void
	{
		var url:String, scale:Number, x:Number, y:Number, z:Number;
		config = JSON.decode(URLLoaderThread(worker.getThreadAt(0)).loader.data.replace(/\r\n|\r/g, '\n'));
		if (! (config["pmd"] is Array)) {
			trace(pmdviewer.jsonURL + "にpmd配列がありません");
			return;
		}
		var loaders:ParallelExecutor = new ParallelExecutor();
		for each (var obj:Object in (config["pmd"] as Array)) {
			if (obj["url"] is String) {
				url = obj["url"];
			} else {
				trace("urlがありません");
				continue;
			}
			if (obj["scale"] is Number) {
				scale = obj["scale"];
			} else {
				trace("scaleがないのでデフォルト値1.0を使います");
				scale = 1.0;
			}
			if (obj["x"] is Number) {
				x = obj["x"];
			} else {
				trace("xがないのでデフォルト値0.0を使います");
				x = 0.0;
			}
			if (obj["y"] is Number) {
				y = obj["y"];
			} else {
				trace("yがないのでデフォルト値0.0を使います");
				y = 0.0;
			}
			if (obj["z"] is Number) {
				z = obj["z"];
			} else {
				trace("zがないのでデフォルト値0.0を使います");
				z = 0.0;
			}
			if (obj["vmd"] is Array) {
				loaders.addThread(mmdLoaderThread(url, scale, x, y, z, obj["vmd"]));
			} else {
				trace(pmdviewer.jsonURL + "の /pmd@url=" + url + "にvmd配列がありません");
			}
		}
		loaders.start();
		loaders.join();
		next(allComplete);
	}
	private function mmdLoaderThread(url:String, scale:Number, x:Number, y:Number, z:Number, vmd:Array):SerialExecutor
	{
		var mmd:MikuMikuDance = new MikuMikuDance();
		mmd.looping = true;
		mmd.x = x;
		mmd.y = y;
		mmd.z = z;

		var sloaders:SerialExecutor = new SerialExecutor();
		trace("addThread: pmdLoader(" + url + "," + scale + ")" );
		sloaders.addThread(mmd.makePMDLoader(url, scale));
		sloaders.addThread(new FuncThread(function ():void { trace("addMMD:" + url); pmdviewer.addMMD(mmd); } ));
		var ploaders:ParallelExecutor = new ParallelExecutor();
		var vmdUrl:String, vmdName:String;
		for each (var obj:Object in vmd) {
			if (obj["url"] is String) {
				vmdUrl = obj["url"];
			} else {
				trace("urlがありません");
				continue;
			}
			if (obj["name"] is String) {
				vmdName = obj["name"];
			} else {
				trace("nameがありません");
				continue;
			}
			trace("addThread: vmdLoader(" + vmdUrl + "," + vmdName + ")" );
			ploaders.addThread(mmd.makeVMDLoader(vmdUrl, vmdName));
			// sloaders.addThreadだと2個目のスレッドのURLLoaderThreadが動かない模様。原因不明
		}
		sloaders.addThread(ploaders);
		// sloaders.addThread(new FuncThread(function ():void { mmd.changeMotionByID(0); } ));

		return sloaders;
	}
	private function allComplete():void
	{
		trace(pmdviewer.jsonURL+"の読み込み処理が完了しました。");
	}
}

