//
//  ReservationItem.h
//  VH7PC_Controller
//
//  Created by nya on 04/12/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


#define RES_ITEM_TITLE_KEY			@"Title"
#define RES_ITEM_DATE_KEY			@"Date"

#define RES_ITEM_YEAR_KEY			@"Year"
#define RES_ITEM_MONTH_KEY			@"Month"
#define RES_ITEM_DAY_KEY			@"Day"
#define RES_ITEM_HOUR_KEY			@"Hour"
#define RES_ITEM_MINUTE_KEY			@"Minute"
#define RES_ITEM_SECOND_KEY			@"Second"

#define RES_ITEM_WEEK_KEY			@"Week"
#define RES_ITEM_INTERVAL_KEY		@"TimeInterval"
#define RES_ITEM_INPUT_KEY			@"Input"
#define RES_ITEM_PRESET_KEY			@"Preset"
#define RES_ITEM_POWEROFF_KEY		@"PowerOff"

#define RES_ITEM_TIMER_KEY			@"Timer"

//#define RES_ITEM_DELEGATE_KEY		@"Delegate"


typedef struct {
	UInt16	year;
	UInt8	month;
	UInt8	day;
} ResDate;

typedef struct {
	UInt8	hour;
	UInt8	minute;
	UInt8	second;
} ResTime;

typedef UInt8 ResWeek;


@interface ReservationItem : NSObject {
	ResDate		date_;
	ResTime		time_;
	ResWeek		week_;
	
	NSString	*title_;
	int			preset_;
	int			input_;
	long		length_;
	BOOL		autoPower_;
	
	//NSTimer		*timer_;
	
	id			delegate_;
}

+ (id) item;
+ (id) itemWithDictionary:(NSDictionary *)dic;

- (id) init;
- (id) initWithDictionary:(NSDictionary *)dic;

- (void) unregistTimer;

- (NSDictionary *) dictionary;

- (NSString *)title;
- (NSDate *)date;
- (unsigned char) week;
- (unsigned long)length;
- (int) input;
- (int) preset;
- (BOOL)autopower;

- (NSString *)dateString;
- (NSString *)timeString;

- (NSDate *) nextRecDate;
- (NSDate *) prevStopDate;

- (NSString *) filename;

@end
