/*

*/

#ifndef _SCANCODE_H_VANE_
#define _SCANCODE_H_VANE_

char Generate_Scancode_To_ASCII_Code(void);

extern struct msg_data kernel;
extern int kernelbuf[32];

/*Flag Code*/
#define BREAK_FLAG 0xf0
#define SPECIAL_FLAG 0xe0

#define BREAK_NORMAL(make_code) (make_code + 0x80)
/*Common*/
#define SC_A	0x1e
#define SC_B	0x30
#define SC_C	0x2e
#define SC_D	0x20
#define SC_E	0x12
#define SC_F	0x21
#define SC_G	0x22
#define SC_H	0x23
#define SC_I	0x17
#define SC_J	0x24
#define SC_K	0x25
#define SC_L	0x26
#define SC_M	0x32
#define SC_N	0x31
#define SC_O	0x18
#define SC_P	0x19
#define SC_Q	0x10
#define SC_R	0x13
#define SC_S	0x1f
#define SC_T	0x14
#define SC_U	0x16
#define SC_V	0x2f
#define SC_W	0x11
#define SC_X	0x2d
#define SC_Y	0x15
#define SC_Z	0x2c

#define SC_0	0x0b
#define SC_1	0x02
#define SC_2	0x03
#define SC_3	0x04
#define SC_4	0x05
#define SC_5	0x06
#define SC_6	0x07
#define SC_7	0x08
#define SC_8	0x09
#define SC_9	0x0a

#define SC_ZEN_HAN_KAKU 0x29
#define SC_ECOAL		0x0c
#define SC_TILDA		0x0d
#define SC_YEN			0x7d
#define SC_GAUS_RIGHT	0x2b
#define SC_BS			0x0e
#define SC_SP			0x39
#define SC_TB			0xof
#define SC_CAPS			0x3a
#define SC_LEFT_SHIFT	0x2a
#define SC_LEFT_CTRL	0x1d
#define SC_LEFT_ALT		0x38
#define SC_RIGHT_SHIFT	0x36

#define SC_ENTER		0x1c
#define SC_ESC			0x01

#define SC_F1	0x3b
#define SC_F2	0x3c
#define SC_F3	0x3d
#define SC_F4	0x3e
#define SC_F5	0x3f
#define SC_F6	0x40
#define SC_F7	0x41
#define SC_F8	0x42
#define SC_F9	0x43
#define SC_F10	0x44
#define SC_F11	0x57
#define SC_F12	0x58

#define SC_SCR		0x46
#define SC_AT_MARK	0x9a

#define SC_NUM_LOCK		0x45
#define SC_NUM_KEY_AST	0x37
#define SC_NUM_KEY_MINUS	0x4a
#define SC_NUM_KEY_PLUS	0x79
#define SC_NUM_KEY_PIRIOD	0x53
#define SC_NUM_KEY_0		0x52
#define SC_NUM_KEY_1		0x4f
#define SC_NUM_KEY_2		0x50
#define SC_NUM_KEY_3		0x51
#define SC_NUM_KEY_4		0x4b
#define SC_NUM_KEY_5		0x4c
#define SC_NUM_KEY_6		0x4d
#define SC_NUM_KEY_7		0x47
#define SC_NUM_KEY_8		0x48
#define SC_NUM_KEY_9		0x49

#define SC_GAUS_LEFT			0x1b
#define SC_SEMI_COLON			0x27
#define SC_COMMA				0x28
#define SC_PILIOD				0x33
#define SC_SLASH				0x34
#define SC_MUHENNKANN			0x35
#define SC_HENNKANN				0x7b
#define SC_KATAKANA_HIRAGANA	0x79


/*Break*/
#define BREAK_LEFT_WIN		0xe0f01f
#define BREAK_RIGHT_CTRL	0xe0f014
#define BREAK_RIGHT_WIN		0xe0f027
#define BREAK_RIGHT_ALT		0xe0f011
#define BREAK_APP			0xe0f02f

#define BREAK_PRISC							0xe0f012e0f07c
#define BREAK_PAUSE							0xe1f01477e1f0f014f077
#define BREAK_INSERT						0xe0f070
#define BREAK_HOME							0xe0f06c
#define BREAK_PAGE_UP						0xe0f07d
#define BREAK_DEL							0xe0f071
#define BREAK_END							0xe0f075
#define BREAK_PAGE_DOWN						0xe0f07a
#define BREAK_ARROW_UP						0xe0f075
#define BREAK_ARROW_LEFT					0xe0f06b
#define BREAK_ARROW_DOWN					0xe0f072
#define BREAK_ARROW_RIGHT					0xe0f074

#define BREAK_NUM_LOCK_AND_INS				0xe0f070e0f012
#define BREAK_NUM_LOCK_AND_HOME				0xe0f006e0f012
#define BREAK_NUM_LOCK_AND_PAGE_UP			0xe0f07de0f012
#define BREAK_NUM_LOCK_AND_DEL				0xe0f071e0f012
#define BREAK_NUM_LOCK_AND_END				0xe0f069e0f012
#define BREAK_NUM_LOCK_AND_PAGE_DOWN		0xe0f07ae0f012
#define BREAK_NUM_LOCK_AND_ARROW_UP			0xe0f075e0f012
#define BREAK_NUM_LOCK_AND_ARROW_LEFT		0xe0f06be0f012
#define BREAK_NUM_LOCK_AND_ARROW_DOWN		0xe0f072e0f012
#define BREAK_NUM_LOCK_AND_ARROW_RIGHT		0xe0f074e0f012

#define BREAK_LEFT_SHIFT_AND_INS			0xe0f070e012
#define BREAK_LEFT_SHIFT_AND_HOME			0xe0f06ce012
#define BREAK_LEFT_SHIFT_AND_PAGE_UP		0xe0f07de012
#define BREAK_LEFT_SHIFT_AND_DEL			0xe0f071e012
#define BREAK_LEFT_SHIFT_AND_END			0xe0f069e012
#define BREAK_LEFT_SHIFT_AND_PAGE_DOWN		0xe0f07ae012
#define BREAK_LEFT_SHIFT_AND_ARROW_UP		0xe0f075e012
#define BREAK_LEFT_SHIFT_AND_ARROW_LEFT		0xe0f06be012
#define BREAK_LEFT_SHIFT_AND_ARROW_DOWN		0xe0f072e012
#define BREAK_LEFT_SHIFT_AND_ARROW_RIGHT	0xe0f074e012

#define BREAK_RIGHT_SHIFT_AND_INS			0xe0f070e059
#define BREAK_RIGHT_SHIFT_AND_HOME			0xe0f06ce059
#define BREAK_RIGHT_SHIFT_AND_PAGE_UP		0xe0f07de059
#define BREAK_RIGHT_SHIFT_AND_DEL			0xe0f071e059
#define BREAK_RIGHT_SHIFT_AND_END			0xe0f069e059
#define BREAK_RIGHT_SHIFT_AND_PAGE_DOWN		0xe0f07ae059
#define BREAK_RIGHT_SHIFT_AND_ARROW_UP		0xe0f075e059
#define BREAK_RIGHT_SHIFT_AND_ARROW_LEFT	0xe0f06be059
#define BREAK_RIGHT_SHIFT_AND_ARROW_DOWN	0xe0f072e059
#define BREAK_RIGHT_SHIFT_AND_ARROW_RIGHT	0xe0f074e059

#define BREAK_LR_SHIFT_AND_INS			0xe0f070e059e012
#define BREAK_LR_SHIFT_AND_HOME			0xe0f06ce059e012
#define BREAK_LR_SHIFT_AND_PAGE_UP		0xe0f07de059e012
#define BREAK_LR_SHIFT_AND_DEL			0xe0f071e059e012
#define BREAK_LR_SHIFT_AND_END			0xe0f069e059e012
#define BREAK_LR_SHIFT_AND_PAGE_DOWN	0xe0f07ae059e012
#define BREAK_LR_SHIFT_AND_ARROW_UP		0xe0f075e059e012
#define BREAK_LR_SHIFT_AND_ARROW_LEFT	0xe0f06be059e012
#define BREAK_LR_SHIFT_AND_ARROW_DOWN	0xe0f072e059e012
#define BREAK_LR_SHIFT_AND_ARROW_RIGHT	0xe0f074e059e012

#define BREAK_NUM_KEY_SLASH		0xe0f04a
#define BREAK_NUM_KEY_LEFT_SHIFT_AND_SLASH		0xe0f04ae012
#define BREAK_NUM_KEY_RIGHT_SHIFT_AND_SLASH		0xe0f04ae059
#define BREAK_NUM_KEY_LR_SHIFT_AND_SLASH		0xe0f04ae059e012


/*Make*/
#define MAKE_RIGHT_CTRL		0xe014
#define MAKE_RIGHT_WIN		0xe027
#define MAKE_RIGHT_ALT		0xe011
#define MAKE_APP			0xe02f

#define MAKE_LEFT_WIN		0xe01f
#define MAKE_PRISC			0xe012e07c
#define MAKE_PAUSE			0xe11477e1f014f077
#define MAKE_INSERT			0xe070
#define MAKE_HOME			0xe06c
#define MAKE_PAGE_UP		0xe07d
#define MAKE_DEL			0xe071
#define MAKE_END			0xe075
#define MAKE_PAGE_DOWN		0xe07a
#define MAKE_ARROW_UP		0xe075
#define MAKE_ARROW_LEFT		0xe06b
#define MAKE_ARROW_DOWN		0xe072
#define MAKE_ARROW_RIGHT	0xe074

#define MAKE_NUM_LOCK_AND_INS			0xe012e070
#define MAKE_NUM_LOCK_AND_HOME			0xe012e06c
#define MAKE_NUM_LOCK_AND_PAGE_UP		0xe012e07d
#define MAKE_NUM_LOCK_AND_DEL			0xe012e071
#define MAKE_NUM_LOCK_AND_END			0xe012e069
#define MAKE_NUM_LOCK_AND_PAGE_DOWN		0xe012e07a
#define MAKE_NUM_LOCK_AND_ARROW_UP		0xe012e075
#define MAKE_NUM_LOCK_AND_ARROW_LEFT	0xe012e06b
#define MAKE_NUM_LOCK_AND_ARROW_DOWN	0xe012e072
#define MAKE_NUM_LOCK_AND_ARROW_RIGHT	0xe012e074

#define MAKE_LEFT_SHIFT_AND_INS			0xe0f012e070
#define MAKE_LEFT_SHIFT_AND_HOME		0xe0f012e06c
#define MAKE_LEFT_SHIFT_AND_PAGE_UP		0xe0f012e07d
#define MAKE_LEFT_SHIFT_AND_DEL			0xe0f012e071
#define MAKE_LEFT_SHIFT_AND_END			0xe0f012e069
#define MAKE_LEFT_SHIFT_AND_PAGE_DOWN	0xe0f012e07a
#define MAKE_LEFT_SHIFT_AND_ARROW_UP	0xe0f012e075
#define MAKE_LEFT_SHIFT_AND_ARROW_LEFT	0xe0f012e06b
#define MAKE_LEFT_SHIFT_AND_ARROW_DOWN	0xe0f012e072
#define MAKE_LEFT_SHIFT_AND_ARROW_RIGHT	0xe0f012e074

#define MAKE_RIGHT_SHIFT_AND_INS			0xe0f059e070
#define MAKE_RIGHT_SHIFT_AND_HOME			0xe0f059e06c
#define MAKE_RIGHT_SHIFT_AND_PAGE_UP		0xe0f059e07d
#define MAKE_RIGHT_SHIFT_AND_DEL			0xe0f059e071
#define MAKE_RIGHT_SHIFT_AND_END			0xe0f059e069
#define MAKE_RIGHT_SHIFT_AND_PAGE_DOWN		0xe0f059e07a
#define MAKE_RIGHT_SHIFT_AND_ARROW_UP		0xe0f059e075
#define MAKE_RIGHT_SHIFT_AND_ARROW_LEFT		0xe0f059e06b
#define MAKE_RIGHT_SHIFT_AND_ARROW_DOWN		0xe0f059e072
#define MAKE_RIGHT_SHIFT_AND_ARROW_RIGHT	0xe0f059e074

#define MAKE_LR_SHIFT_AND_INS			0xe0f012e0f059e070
#define MAKE_LR_SHIFT_AND_HOME			0xe0f012e0f059e06c
#define MAKE_LR_SHIFT_AND_PAGE_UP		0xe0f012e0f059e07d
#define MAKE_LR_SHIFT_AND_DEL			0xe0f012e0f059e071
#define MAKE_LR_SHIFT_AND_END			0xe0f012e0f059e069
#define MAKE_LR_SHIFT_AND_PAGE_DOWN		0xe0f012e0f059e07a
#define MAKE_LR_SHIFT_AND_ARROW_UP		0xe0f012e0f059e075
#define MAKE_LR_SHIFT_AND_ARROW_LEFT	0xe0f012e0f059e06b
#define MAKE_LR_SHIFT_AND_ARROW_DOWN	0xe0f012e0f059e072
#define MAKE_LR_SHIFT_AND_ARROW_RIGHT	0xe0f012e0f059e074
#define MAKE_NUM_KEY_SLASH	0xe04a
#define MAKE_NUM_KEY_LEFT_SHIFT_AND_SLASH	0xe0f012e04a
#define MAKE_NUM_KEY_RIGHT_SHIFT_AND_SLASH	0xe0f059e04a
#define MAKE_NUM_KEY_LR_SHIFT_AND_SLASH		0xe0f012e0f059e04a
#define MAKE_NUM_KEY_ENTER	0xe05a


#endif
