/*!
	KeyBoard.h
	Keyboard type load header
	(C) 2014 VOSystems.
*/

#ifndef _KEYBOARD_H_VANE_
#define _KEYBOARD_H_VANE_

/*Typedef*/
typedef struct
{
    int caps_on;
    int alt_on;
    int shift_on;
    int ctrl_on;
    int numlock_on;
    int scrolllock_on;
    int insert_on;
} KEY_STATE;
typedef int STATUS;
typedef enum
{
    E_KBD_NONE_LED          = 0x00000000,
    E_KBD_SCROLL_LOCK_LED   = 0x00000001,
    E_KBD_NUM_LOCK_LED      = 0x00000002,
    E_KBD_CAPS_LOCK_LED     = 0x00000004
} E_KBD_LED;

/*Extern*/
extern int keyboard_disable;
extern unsigned char scan_code;
extern int system_key_code_flag,break_flag;
extern unsigned long long input;

/*PROTOTYPE*/
unsigned char readKbdCtrlStatus(void);
STATUS writeKbdCtrlCommand(unsigned char command);
unsigned char readKbdEncBuffer(void);
STATUS writeKbdEncCommand(unsigned char command);
STATUS keyboardSetLED( E_KBD_LED led );
STATUS keyboardSelfTest( void );
STATUS waitKbdOutputBufferFull( void );
STATUS keyboardDisableKBD( void );
STATUS keyboardEnableKBD( void );
STATUS initKeyboard( void );
char Generate_Scancode_To_ASCII_Code(void);

/*DESCRIPTION KEYBOARD ENCODE*/
#define DEF_PORT_KBD_ENCODER 0x0060
#define DEF_PORT_KBD_ENC_BUFFER DEF_PORT_KBD_ENCODER
#define DEF_PORT_KBD_ENC_COMMAND DEF_PORT_KBD_ENCODER

/*DESCRIPTION KEYBOARD CONTROLER*/
#define DEF_PORT_KBD_CONTROLLER 0x0064
#define DEF_PORT_KBD_CTRL_STATUS DEF_PORT_KBD_CONTROLLER
#define DEF_PORT_KBD_CTRL_COMMAND DEF_PORT_KBD_CONTROLLER

/*DEFINE STATUS REGISTOR*/
#define DEF_KBD_STS_OBF 0x01
#define DEF_KBD_STS_IBF 0x02
#define DEF_KBD_STS_F0  0x04
#define DEF_KBD_STS_F1  0x08
#define DEF_KBD_STS_ST4 0x10
#define DEF_KBD_STS_ST5 0x20
#define DEF_KBD_STS_ST6 0x40
#define DEF_KBD_STS_ST7 0x80

/*Key Board Status*/
#define DEF_KBD_OK 0
#define DEF_KBD_ERROR (-1)
#define MAX_RETRY 0x01000000

/*Key Board Status*/
#define	DEF_KBD_ENC_COM_SETLED              0xED
#define	DEF_KBD_ENC_COM_ECHO                0xEE
#define	DEF_KBD_ENC_COM_GETSET_SCANCODE     0xF0
#define	DEF_KBD_ENC_COM_GET_KBD_ID          0xF2
#define	DEF_KBD_ENC_COM_SET_TYPEMATIC       0xF3
#define	DEF_KBD_ENC_COM_ENABLE_KBD          0xF4
#define	DEF_KBD_ENC_COM_DISABLE_KBD         0xF5
#define	DEF_KBD_ENC_COM_SET_DEFAULT         0xF6
#define	DEF_KBD_ENC_COM_SET_ALL_REPEAT      0xF7
#define	DEF_KBD_ENC_COM_SET_ALL_BREAK       0xF8
#define	DEF_KBD_ENC_COM_CLEAR_ALL_REP_BRK   0xF9
#define	DEF_KBD_ENC_COM_SET_ALL_REP_BRK     0xFA
#define	DEF_KBD_ENC_COM_SET_REPEAT          0xFB
#define	DEF_KBD_ENC_COM_SET_BREAK           0xFC
#define	DEF_KBD_ENC_COM_CLEAR_REP_BRK       0xFD
#define	DEF_KBD_ENC_COM_REQ_RESEND          0xFE
#define	DEF_KBD_ENC_COM_RESET_SELFTEST      0xFF

/* Standard Commands      */
#define DEF_KBD_CTRL_COM_READ_CCB        0x20
#define DEF_KBD_CTRL_COM_WRITE_CCB       0x60
#define DEF_KBD_CTRL_COM_DISABLE_MOUSE   0xA7
#define DEF_KBD_CTRL_COM_ENABLE_MOUSE    0xA8
#define DEF_KBD_CTRL_COM_TEST_MOUSE      0xA9
#define DEF_KBD_CTRL_COM_SELF_TEST       0xAA
#define DEF_KBD_CTRL_COM_TEST_IF         0xAB
#define DEF_KBD_CTRL_COM_DISABLE_KBD     0xAD
#define DEF_KBD_CTRL_COM_ENABLE_KBD      0xAE
#define DEF_KBD_CTRL_COM_READ_IN_PORT    0xC0
#define DEF_KBD_CTRL_COM_READ_OUT_PORT   0xD0
#define DEF_KBD_CTRL_COM_WRITE_OUT_PORT  0xD1
#define DEF_KBD_CTRL_COM_WRITE_MOUSE     0xD4
#define DEF_KBD_CTRL_COM_READ_TEST_PORT  0xE0
#define DEF_KBD_CTRL_COM_SYSTEM_RESET    0xFE

/* Vendo-Specific Commands  */
#define DEF_KBD_CTRL_COM_READ_RAM_0x20   0x20
#define DEF_KBD_CTRL_COM_READ_RAM_0x21   0x21
#define DEF_KBD_CTRL_COM_READ_RAM_0x22   0x22
#define DEF_KBD_CTRL_COM_READ_RAM_0x23   0x23
#define DEF_KBD_CTRL_COM_READ_RAM_0x24   0x24
#define DEF_KBD_CTRL_COM_READ_RAM_0x25   0x25
#define DEF_KBD_CTRL_COM_READ_RAM_0x26   0x26
#define DEF_KBD_CTRL_COM_READ_RAM_0x27   0x27
#define DEF_KBD_CTRL_COM_READ_RAM_0x28   0x28
#define DEF_KBD_CTRL_COM_READ_RAM_0x29   0x29
#define DEF_KBD_CTRL_COM_READ_RAM_0x2A   0x2A
#define DEF_KBD_CTRL_COM_READ_RAM_0x2B   0x2B
#define DEF_KBD_CTRL_COM_READ_RAM_0x2C   0x2C
#define DEF_KBD_CTRL_COM_READ_RAM_0x2D   0x2D
#define DEF_KBD_CTRL_COM_READ_RAM_0x2E   0x2E
#define DEF_KBD_CTRL_COM_READ_RAM_0x2F   0x2F
#define DEF_KBD_CTRL_COM_READ_RAM_0x30   0x30
#define DEF_KBD_CTRL_COM_READ_RAM_0x31   0x31
#define DEF_KBD_CTRL_COM_READ_RAM_0x32   0x32
#define DEF_KBD_CTRL_COM_READ_RAM_0x33   0x33
#define DEF_KBD_CTRL_COM_READ_RAM_0x34   0x34
#define DEF_KBD_CTRL_COM_READ_RAM_0x35   0x35
#define DEF_KBD_CTRL_COM_READ_RAM_0x36   0x36
#define DEF_KBD_CTRL_COM_READ_RAM_0x37   0x37
#define DEF_KBD_CTRL_COM_READ_RAM_0x38   0x38
#define DEF_KBD_CTRL_COM_READ_RAM_0x39   0x39
#define DEF_KBD_CTRL_COM_READ_RAM_0x3A   0x3A
#define DEF_KBD_CTRL_COM_READ_RAM_0x3B   0x3B
#define DEF_KBD_CTRL_COM_READ_RAM_0x3C   0x3C
#define DEF_KBD_CTRL_COM_READ_RAM_0x3D   0x3D
#define DEF_KBD_CTRL_COM_READ_RAM_0x3E   0x3E
#define DEF_KBD_CTRL_COM_READ_RAM_0x3F   0x3F

#define DEF_KBD_CTRL_COM_WRITE_RAM_0x60  0x60
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x61  0x61
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x62  0x62
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x63  0x36
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x64  0x46
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x65  0x56
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x66  0x66
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x67  0x67
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x68  0x68
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x69  0x69
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6A  0x6A
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6B  0x6B
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6C  0x6C
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6D  0x6D
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6E  0x6E
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x6F  0x6F
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x70  0x70
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x71  0x71
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x72  0x72
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x73  0x73
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x74  0x74
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x75  0x75
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x76  0x76
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x77  0x77
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x78  0x78
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x79  0x79
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7A  0x7A
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7B  0x7B
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7C  0x7C
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7D  0x7D
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7E  0x7E
#define DEF_KBD_CTRL_COM_WRITE_RAM_0x7F  0x7F

/*Self Status Command*/
#define DEF_KBD_CTRL_STS_SELF_TEST_OK    0x55
#define DEF_KBD_CTRL_STS_SELF_TEST_NG    0xFC





#endif
