/*
*Multi Task management system source
*(C) 2014 VOSystems.
*/

#include<VaneOS.h>
#include<task.h>
#include<Message.h>
#include<timer.h>
#include<memory.h>

struct TASKCTL *taskctl;
struct TIMER *task_timer;

struct TASK *task_now(void);
void task_add(struct TASK *task);
void task_remove(struct TASK *task);
void task_switchsub(void);
void task_idle(void);
struct TASK *task_init(struct MEMMAN *memman);
struct TASK* task_alloc(void);
void task_run(struct TASK *task, int level, int priority);
void task_sleep(struct TASK *task);
void task_switch(void);

void set_segmdesc(SEGMENT_DESCRIPTOR *sd, unsigned int limit, int base, int ar)
{
	if (limit > 0xfffff) {
		ar |= 0x8000; /* G_bit = 1 */
		limit /= 0x1000;
	}
	sd->limitLo    = limit & 0xffff;
	sd->baseLo     = base & 0xffff;
	sd->baseMid     = (base >> 16) & 0xff;
	//sd->access_right = ar & 0xff;
	//sd->limitHi   = ((limit >> 16) & 0x0f) | ((ar >> 8) & 0xf0);
	sd->baseHi    = (base >> 24) & 0xff;
	return;
}


struct TASK *task_now(void)
{
	struct TASKLEVEL *tl = &taskctl->level[taskctl->now_lv];
	return tl->tasks[tl->now];
}

void task_add(struct TASK *task)
{
	struct TASKLEVEL *tl = &taskctl->level[task->level];
	tl->tasks[tl->running] = task;
	tl->running++;
	task->flags = 2; /* ®ì */
	return;
}

void task_remove(struct TASK *task)
{
	int i;
	struct TASKLEVEL *tl = &taskctl->level[task->level];

	/* taskªÇ±É¢é©ðT· */
	for (i = 0; i < tl->running; i++) {
		if (tl->tasks[i] == task) {
			/* ±±É¢œ */
			break;
		}
	}

	tl->running--;
	if (i < tl->now) {
		tl->now--; /* žêéÌÅA±êà í¹Äš­ */
	}
	if (tl->now >= tl->running) {
		/* nowªš©µÈlÉÈÁÄ¢œçAC³·é */
		tl->now = 0;
	}
	task->flags = 1; /* X[v */

	/* žçµ */
	for (; i < tl->running; i++) {
		tl->tasks[i] = tl->tasks[i + 1];
	}

	return;
}

void task_switchsub(void)
{
	int i;
	/* êÔãÌxðT· */
	for (i = 0; i < MAX_TASKLEVELS; i++) {
		if (taskctl->level[i].running > 0) {
			break; /* ©Â©Áœ */
		}
	}
	taskctl->now_lv = i;
	taskctl->lv_change = 0;
	return;
}

void task_idle(void)
{
	for (;;) {
		io_hlt();
	}
}

struct TASK *task_init(struct MEMMAN *memman)
{
	int i;
	struct TASK *task, *idle;
	SEGMENT_DESCRIPTOR *gdt = (SEGMENT_DESCRIPTOR *) ADR_GDT;

	taskctl = (struct TASKCTL *) memman_alloc_4k(memman, sizeof (struct TASKCTL));
	for (i = 0; i < MAX_TASKS; i++) {
		taskctl->tasks0[i].flags = 0;
		taskctl->tasks0[i].sel = (TASK_GDT0 + i) * 8;
		taskctl->tasks0[i].tss.ldtr = (TASK_GDT0 + MAX_TASKS + i) * 8;
		set_segmdesc(gdt + TASK_GDT0 + i, 103, (int) &taskctl->tasks0[i].tss, AR_TSS32);
		set_segmdesc(gdt + TASK_GDT0 + MAX_TASKS + i, 15, (int) taskctl->tasks0[i].ldt, AR_LDT);
	}
	for (i = 0; i < MAX_TASKLEVELS; i++) {
		taskctl->level[i].running = 0;
		taskctl->level[i].now = 0;
	}

	task = task_alloc();
	task->flags = 2;	/* ®ì}[N */
	task->priority = 2; /* 0.02b */
	task->level = 0;	/* Åx */
	task_add(task);
	task_switchsub();	/* xÝè */
	load_tr(task->sel);
	task_timer = timer_alloc();
	timer_settime(task_timer, task->priority);

	idle = task_alloc();
	idle->tss.esp = memman_alloc_4k(memman, 64 * 1024) + 64 * 1024;
	idle->tss.eip = (int) &task_idle;
	idle->tss.es = 1 * 8;
	idle->tss.cs = 2 * 8;
	idle->tss.ss = 1 * 8;
	idle->tss.ds = 1 * 8;
	idle->tss.fs = 1 * 8;
	idle->tss.gs = 1 * 8;
	task_run(idle, MAX_TASKLEVELS - 1, 1);

	return task;
}

struct TASK* task_alloc(void)
{
	int i;
	struct TASK *task;
	for (i = 0; i < MAX_TASKS; i++) {
		if (taskctl->tasks0[i].flags == 0) {
			task = &taskctl->tasks0[i];
			task->flags = 1; /* gp}[N */
			task->tss.eflags = 0x00000202; /* IF = 1; */
			task->tss.eax = 0; /* Æè Šž0ÉµÄš­±ÆÉ·é */
			task->tss.ecx = 0;
			task->tss.edx = 0;
			task->tss.ebx = 0;
			task->tss.ebp = 0;
			task->tss.esi = 0;
			task->tss.edi = 0;
			task->tss.es = 0;
			task->tss.ds = 0;
			task->tss.fs = 0;
			task->tss.gs = 0;
			task->tss.iomap = 0x40000000;
			task->tss.ss0 = 0;
			return task;
		}
	}
	return 0; /* à€Sgp */
}

void task_run(struct TASK *task, int level, int priority)
{
	if (level < 0) {
		level = task->level; /* xðÏXµÈ¢ */
	}
	if (priority > 0) {
		task->priority = priority;
	}

	if (task->flags == 2 && task->level != level) { /* ®ìÌxÌÏX */
		task_remove(task); /* ±êðÀs·éÆflagsÍ1ÉÈéÌÅºÌifàÀs³êé */
	}
	if (task->flags != 2) {
		/* X[v©çN±³êéê */
		task->level = level;
		task_add(task);
	}

	taskctl->lv_change = 1; /* ñ^XNXCb`ÌÆ«Éxð©Œ· */
	return;
}

void task_sleep(struct TASK *task)
{
	struct TASK *now_task;
	if (task->flags == 2) {
		/* ®ìŸÁœç */
		now_task = task_now();
		task_remove(task); /* ±êðÀs·éÆflagsÍ1ÉÈé */
		if (task == now_task) {
			/* ©ª©gÌX[vŸÁœÌÅA^XNXCb`ªKv */
			task_switchsub();
			now_task = task_now(); /* ÝèãÅÌAu»ÝÌ^XNvð³ŠÄàç€ */
			farjmp(0, now_task->sel);
		}
	}
	return;
}

void task_switch(void)
{
	struct TASKLEVEL *tl = &taskctl->level[taskctl->now_lv];
	struct TASK *new_task, *now_task = tl->tasks[tl->now];
	tl->now++;
	if (tl->now == tl->running) {
		tl->now = 0;
	}
	if (taskctl->lv_change != 0) {
		task_switchsub();
		tl = &taskctl->level[taskctl->now_lv];
	}
	new_task = tl->tasks[tl->now];
	timer_settime(task_timer, new_task->priority);
	if (new_task != now_task) {
		farjmp(0, new_task->sel);
	}
	return;
}
