/*
*Msg Q Like System
*(C) 2014 VOSystems.
*/

#include<VaneOS.h>
#include<Message.h>

int buf_separate_keyboard;

void msg_init(struct msg_data *fifo,int size,int* buf)
{
	fifo->size=size;
	fifo->buf=buf;
	fifo->free=size;
	fifo->flags=0;
	fifo->r=0;
	fifo->w=0;
	return;
}

int msg_put(struct msg_data *fifo,int data)
{
	if(fifo->free==0)
	{
		fifo->flags |= FLAGS_OVERRUN;
		return 1;
	}
	fifo->buf[fifo->w]=data;
	if(fifo->w==fifo->size){
		fifo->w=0;
	}else{
		fifo->w++;
	}
	fifo->free--;
	return 0;
}

int msg_get(struct msg_data *fifo)
{
	if(fifo->free==fifo->size)
	{
		return 1;
	}
	int data=fifo->buf[fifo->r];
	fifo->buf[fifo->r]=0;
	if(fifo->r==fifo->size){
		fifo->r=0;
	}else{
		fifo->r++;
	}
	fifo->free--;
	return data;
}

inline int msg_status(struct msg_data *fifo)
{
	return fifo->size-fifo->free;
}
