/*!
	KeyBoard.c
	Keyboard functions without Interrupt Handler.
	(C) 2014 VOSystems.
*/

#include<KeyBoard.h>
#include<Message.h>

int keyboard_disable;

unsigned char readKbdCtrlStatus(void)
{
	return(inPortByte(DEF_PORT_KBD_CTRL_STATUS));
}

STATUS writeKbdCtrlCommand(unsigned char command)
{
	int retry;
	
	for(retry=0;retry<MAX_RETRY;++retry)
	{
		if((readKbdCtrlStatus() & DEF_KBD_STS_IBF)==0)
		{
			outPortByte(DEF_PORT_KBD_CTRL_COMMAND,command);
			return DEF_KBD_OK;
		}
	}
	return DEF_KBD_ERROR;
}

unsigned char readKbdEncBuffer(void)
{
	return(inPortByte(DEF_PORT_KBD_ENC_BUFFER));
}

STATUS writeKbdEncCommand(unsigned char command)
{
	int retry;
	
	for(retry=0;retry<MAX_RETRY;++retry)
	{
		if((readKbdCtrlStatus() & DEF_KBD_STS_IBF)==0)
		{
			outPortByte(DEF_PORT_KBD_ENC_COMMAND,command);
			return DEF_KBD_OK;
		}
	}
	return DEF_KBD_ERROR;
}

STATUS keyboardSetLED( E_KBD_LED led )
{
    unsigned char   wirte_data;
    STATUS           status;
	
    /*if designated leds are unknow*/
    if( ( E_KBD_SCROLL_LOCK_LED | E_KBD_NUM_LOCK_LED | E_KBD_CAPS_LOCK_LED ) < led)
    {
        return( DEF_KBD_ERROR );
    }

    status =  writeKbdEncCommand( DEF_KBD_ENC_COM_SETLED    );
    status |= writeKbdEncCommand( ( unsigned char )led      );

    return( status );
}

STATUS keyboardSelfTest( void )
{
    unsigned char enc_buffer;
    STATUS        status;
    
    /* execute self test*/
    status = writeKbdCtrlCommand( DEF_KBD_CTRL_COM_SELF_TEST );

    if( DEF_KBD_OK != status )
    {
        return( status );
    }

    /*wait*/
    status = waitKbdOutputBufferFull( );

    if( DEF_KBD_OK != status )
    {
        return( status );
    }

    /*test result of self test*/
    enc_buffer = readKbdEncBuffer( );

    if( enc_buffer == DEF_KBD_CTRL_STS_SELF_TEST_OK )
    {
        return( status );
    }

    return( DEF_KBD_ERROR );
}

STATUS waitKbdOutputBufferFull( void )
{
    unsigned char kbd_status;
    int           retry;

    for( retry = 0 ; retry < MAX_RETRY ; retry++ )
    {
        kbd_status = readKbdCtrlStatus( );

        if( ( kbd_status & DEF_KBD_STS_OBF ) == DEF_KBD_STS_OBF )
        {
            return( DEF_KBD_OK );
        }
    }

    return( DEF_KBD_ERROR );
}

STATUS keyboardDisableKBD( void )
{
    /*disable a keyboard*/
    STATUS status = writeKbdCtrlCommand( DEF_KBD_CTRL_COM_DISABLE_KBD );

    if( DEF_KBD_OK != status ){
        keyboard_disable = 0;
        
    }else{
        keyboard_disable = 1;
        
    }

    return( status );
}

STATUS keyboardEnableKBD( void )
{
    /*enable a keyboard*/
    STATUS status = writeKbdCtrlCommand( DEF_KBD_CTRL_COM_ENABLE_KBD );

    if( DEF_KBD_OK != status ){
        keyboard_disable = 1;
        
    }else{
        keyboard_disable = 0;
        
    }

    return( status );
}

/*
    Funtion     :initKeyboard
    Input       :void
    Output      :void
    Return      :STATUS
                 < status of initialization >

    Description :initialize keyboard driver
*/
STATUS initKeyboard( void )
{
    STATUS status;
	KEY_STATE key_state;
    /*initialize keyboard management information*/
    key_state.caps_on       = 0;
    key_state.alt_on        = 0;
    key_state.shift_on      = 0;
    key_state.ctrl_on       = 0;
    key_state.numlock_on    = 0;
    key_state.scrolllock_on = 0;
    key_state.insert_on     = 0;

    buf_separate_keyboard=256;
    
    /*set leds of keyboard off*/
    status = keyboardSetLED( E_KBD_NONE_LED );
    
    return( status );
}
