/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  $Id: task.h 93 2012-03-03 05:14:29Z nagasima $
 */

/*
 *		^XNǗW[
 */

#ifndef TOPPERS_TASK_H
#define TOPPERS_TASK_H

#include <queue.h>
#include "time_event.h"

/*
 *  g[XO}ÑftHg`
 */
#ifndef LOG_TSKSTAT
#define LOG_TSKSTAT(p_tcb)
#endif /* LOG_TSKSTAT */

/*
 *  ^XNDx̓\EO\ϊ}N
 */
#define INT_PRIORITY(x)		((uint_t)((x) - TMIN_TPRI))
#define EXT_TSKPRI(x)		((PRI)(x) + TMIN_TPRI)

/*
 *  ^XNԂ̓\
 *
 *  TCB̃^XNԂł́CsԁiRUNNINGjƎs\ԁiREADYj
 *  ͋ʂȂDԂ𑍏̂āCsłԁiRUNNABLEjƌĂԁD
 *  d҂Ԃ́C(TS_WAITING | TS_SUSPENDED)ŕ\DTS_WAIT_???͑
 *  v\C҂ԁid҂Ԃ܂ށj̏ꍇɂ̂ݐݒ肷D
 */
#define TS_DORMANT		0x00U			/* x~ */
#define TS_RUNNABLE		0x01U			/* sł */
#define TS_WAITING		0x02U			/* ҂ */
#define TS_SUSPENDED	0x04U			/* ҂ */

#define TS_WAIT_DLY		(0x00U << 3)	/* Ԍoߑ҂ */
#define TS_WAIT_SLP		(0x01U << 3)	/* N҂ */
#define TS_WAIT_RDTQ	(0x02U << 3)	/* f[^L[̎M҂ */
#define TS_WAIT_RPDQ	(0x03U << 3)	/* Dxf[^L[̎M҂ */
#define TS_WAIT_SEM		(0x04U << 3)	/* Z}tH̊l҂ */
#define TS_WAIT_FLG		(0x05U << 3)	/* CxgtO҂ */
#define TS_WAIT_SDTQ	(0x06U << 3)	/* f[^L[ւ̑M҂ */
#define TS_WAIT_SPDQ	(0x07U << 3)	/* Dxf[^L[ւ̑M҂ */
#define TS_WAIT_MBX		(0x08U << 3)	/* [{bNX̎M҂ */
#define TS_WAIT_MPF		(0x09U << 3)	/* Œ蒷ubN̊l҂ */
#define TS_WAIT_MPL		(0x0AU << 3)	/* ϒubN̊l҂ */

/*
 *  ^XNԔʃ}N
 *
 *  TSTAT_DORMANT̓^XNx~Ԃł邩ǂCTSTAT_RUNNABLE
 *  ^XNsłԂł邩ǂ𔻕ʂDTSTAT_WAITING͑
 *  ԂƓd҂Ԃ̂ꂩł邩ǂCTSTAT_SUSPENDED
 *  ҂ԂƓd҂Ԃ̂ꂩł邩ǂ𔻕ʂD
 */
#define TSTAT_DORMANT(tstat)	((tstat) == TS_DORMANT)
#define TSTAT_RUNNABLE(tstat)	(((tstat) & TS_RUNNABLE) != 0U)
#define TSTAT_WAITING(tstat)	(((tstat) & TS_WAITING) != 0U)
#define TSTAT_SUSPENDED(tstat)	(((tstat) & TS_SUSPENDED) != 0U)

/*
 *  ^XN҂vʃ}N
 *
 *  TSTAT_WAIT_SLP̓^XNN҂ł邩ǂCTSTAT_WAIT_WOBJ
 *  ̓^XNEʐMIuWFNgɑ΂҂ł邩iƁC
 *  ʐMIuWFNg̑҂L[ɂȂĂ邩jǂ𔻕ʂ
 *  D܂CTSTAT_WAIT_WOBJCB̓^XNEʐMIuWFNg̊Ǘ
 *  ubN̋ʕiWOBJCBj̑҂L[ɂȂĂ邩ǂ
 *  ʂD
 *
 *  TSTAT_WAIT_SLṔCCӂ̃^XNԂ̒C^XNN҂ł
 *  Ƃ𔻕ʂłDȂ킿CTSTAT_WAITINGɂ҂Ԃł邱Ƃ
 *  ʂɁCTSTAT_SLPpċN҂Ԃł邱Ƃ𔻕ʂłD
 *  IɎ邽߂ɁCTS_WAIT_SLP̒lC(0x00U << 3)ł͂
 *  (0x01U << 3)ƂĂD̂߁C^XNԌoߑ҂Ԃł
 *  Ƃ𔻕ʂ邽߂TSTAT_WAIT_DLYCTSTAT_WAIT_SLPƓl̕@
 *  邱Ƃ͂łȂD
 */
#define TS_WAIT_MASK	(0x0fU << 3)	/* ҂v̎o}XN */

#define TSTAT_WAIT_SLP(tstat)		(((tstat) & TS_WAIT_MASK) == TS_WAIT_SLP)
#define TSTAT_WAIT_WOBJ(tstat)		(((tstat) & TS_WAIT_MASK) >= TS_WAIT_RDTQ)
#define TSTAT_WAIT_WOBJCB(tstat)	(((tstat) & TS_WAIT_MASK) >= TS_WAIT_SEM)

/*
 *  ҂ubNiWINFOj̒`
 *
 *  ^XN҂Ԃ̊Ԃ́CTCBтp_winfoŎwWINFO
 *  悤ɐݒ肵Ȃ΂ȂȂD
 *
 *  (a) TCB̃^XNԂ҂ԁiTS_WAITINGjɂD̍ۂɁC҂
 *  viTS_WAIT_???jݒ肷D
 *
 *  (b) ^CAEgĎ邽߂ɁC^CCxgubNo^D
 *  o^^CCxgubŃC҂ɓT[rXR[֐
 *  ̃[JϐƂĊmۂCւ̃|C^WINFOp_tmevtbɋL
 *  D^CAEg̊ĎKvȂꍇiiv҂̏ꍇjɂ́C
 *  p_tmevtbNULLɂD
 *
 *  EʐMIuWFNgɑ΂҂Ԃ̏ꍇɂ́CWWINFO
 *  p_wobjcbtB[hǉ\́iWINFO_WOBJCwait.hŒ`jg
 *  D܂Cȉ(c)`(e)̐ݒsKvDEʐMIuWF
 *  NgɊ֌WȂ҂iN҂CԌoߑ҂j̏ꍇɂ́C(c)`(e)
 *  ͕KvȂD
 *
 *  (c) TCB҂Ώۂ̓EʐMIuWFNg̑҂L[ɂȂD
 *  L[ɂȂ߂ɁCtask_queuegD
 *
 *  (d) ҂Ώۂ̓EʐMIuWFNg̊ǗubNւ̃|C^C
 *  WINFO_WOBJp_wobjcbɋLD
 *
 *  (e) ҂Ώۂ̓EʐMIuWFNgɈˑċL邱ƂKv
 *  񂪂ꍇɂ́CWINFO_WOBJɕKvȏ̂߂̃tB[hǉ
 *  \̂`CWINFO_WOBJ̑ɗpD
 *
 *  ҂Ԃۂɂ́C҂^XNɑ΂ԒlWINFO
 *  wercdɐݒ肷DwercdKvȂ̂͑҂ȍ~ł̂ɑ΂āC
 *  p_tmevtb͑҂͕KvȂ߁Cߖ̂߂ɋp̂g
 *  ĂD̂߁CwercdփG[R[hݒ肷̂́C^CCxg
 *  ubNo^ɂȂ΂ȂȂD
 */
typedef union waiting_information {
	ER		wercd;			/* ҂̃G[R[h */
	TMEVTB	*p_tmevtb;		/* ҂ԗp̃^CCxgubN */
} WINFO;

/*
 *  ^XNubN
 *
 *  ^XNɊւClςȂ߂ROMɒu镔i^XN
 *  ubNjƁClω邽߂RAMɒuȂ΂ȂȂ
 *  i^XNǗubNCTCBjɕCTCBɑΉ^XN
 *  ubNw|C^D^XNubNɑΉ
 *  TCBw|C^@̕CRAM̐ߖ̊ϓ_͖]܂
 *  CsȂ邽߂ɍ̗pĂȂD̃IuWFNgɂ
 *  ĂlɈD
 *
 *  ^XNubNɂ́CDEF_TEXŒ`^XNO[`
 *  Ɋւ܂ށD
 */
typedef struct task_initialization_block {
	ATR			tskatr;			/* ^XN */
	intptr_t	exinf;			/* ^XN̊g */
	TASK		task;			/* ^XN̋NԒn */
	uint_t		ipriority;		/* ^XN̋NDxi\j */

#ifdef USE_TSKINICTXB
	TSKINICTXB	tskinictxb;		/* ^XNReLXgubN */
#else /* USE_TSKINICTXB */
	SIZE		stksz;			/* X^bN̈̃TCYiۂ߂lj */
	void		*stk;			/* X^bN̈̐擪Ԓn */
#endif /* USE_TSKINICTXB */

	ATR			texatr;			/* ^XNO[` */
	TEXRTN		texrtn;			/* ^XNO[`̋NԒn */
} TINIB;

/*
 *  TCB̃tB[h̃rbg̒`
 *
 *  vZbTɂẮCTCB̃tB[h̃rbgŃgpʂ
 *  \g[hItɂȂ邽߁C^[QbgˑɃtB[h̃rbg
 *  ύX邱ƂĂD
 */
#ifndef TBIT_TCB_PRIORITY
#define	TBIT_TCB_PRIORITY		8		/* prioritytB[h̃rbg */
#endif /* TBIT_TCB_PRIORITY */

/*
 *  ^XNǗubNiTCBj
 *
 *  ASPJ[lł́C^XN̋NvL[CO̍őliTMAX_ACTCNTj
 *  ƋNvL[CO̍őliTMAX_WUPCNTj1ɌŒ肳Ă
 *  ߁CL[COĂ邩ǂ̐^Ulŕ\邱ƂłD
 *  ܂C҂vlXg̍őliTMAX_SUSCNTj1ɌŒ肳Ă
 *  ̂ŁC҂vlXgisuscntj͕KvȂD
 *
 *  TCB̂̃tB[h́C̃^XNԂł̂ݗLȒlێC
 *  ȊȌꍇ͒lۏ؂ȂiāCQƂĂ͂ȂȂjDe
 *  tB[hLȒlێ͎̒ʂD
 *
 *  E͏ɗLF
 *  		p_tinibCtstatCactque
 *  Ex~ԈȊOŗLix~Ԃł͏lɂȂĂjF
 *  		priorityCwupqueCenatexCtexptn
 *  E҂ԁid҂Ԃ܂ށjŗLF
 *  		p_winfo
 *  EsłԂƓEʐMIuWFNgɑ΂҂ԂŗLF
 *  		task_queue
 *  Es\ԁC҂ԁC҂ԁCd҂ԂŗLF
 *  		tskctxb
 */
typedef struct task_control_block {
	QUEUE			task_queue;		/* ^XNL[ */
	const TINIB		*p_tinib;		/* ubNւ̃|C^ */

#ifdef UINT8_MAX
	uint8_t			tstat;			/* ^XNԁi\j*/
#else /* UINT8_MAX */
	BIT_FIELD_UINT	tstat : 8;		/* ^XNԁi\j*/
#endif /* UINT8_MAX */
#if defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8)
	uint8_t			priority;		/* ݂̗Dxi\j*/
#else /* defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8) */
	BIT_FIELD_UINT	priority : TBIT_TCB_PRIORITY;
									/* ݂̗Dxi\j*/
#endif  /* defined(UINT8_MAX) && (TBIT_TCB_PRIORITY == 8) */
	BIT_FIELD_BOOL	actque : 1;		/* NvL[CO */
	BIT_FIELD_BOOL	wupque : 1;		/* NvL[CO */
	BIT_FIELD_BOOL	enatex : 1;		/* ^XNO */

	TEXPTN			texptn;			/* ۗOv */
	WINFO			*p_winfo;		/* ҂ubNւ̃|C^ */
	TSKCTXB			tskctxb;		/* ^XNReLXgubN */
} TCB;

/*
 *  sԂ̃^XN
 *
 *  sԂ̃^XNivZbTReLXgĂ^XNj
 *  TCBw|C^DsԂ̃^XNȂꍇNULLɂD
 *
 *  T[rXR[̏ŁC^XNiT[rXR[Ăяo^X
 *  NjɊւQƂꍇp_runtskgDp_runtsk
 *  ̂́CfBXpb`iƏĵ݂łD
 */
extern TCB	*p_runtsk;

/*
 *  ōD揇ʂ̃^XN
 *
 *  sł^XN̒ōōD揇ʂ̃^XNTCBw|C^D
 *  sł^XNȂꍇNULLɂD
 *
 *  fBXpb`֎~ԂȂǁCfBXpb`ۗĂԂp_runtsk
 *  ƈvĂƂ͌ȂD
 */
extern TCB	*p_schedtsk;

/*
 *  fBXpb`^^XNO[`NvtO
 *
 *  ݃nh^CPUOnh̏oɁCfBXpb`܂
 *  ^XNO[`̋Nv邱ƂtOD
 */
extern bool_t	reqflg;

/*
 *  ݗDx}XNS
 *
 *  ݗDx}XNSԂł邱ƂtOD
 */
extern bool_t	ipmflg;

/*
 *  fBXpb`֎~
 *
 *  fBXpb`֎~Ԃł邱ƂtOD
 */
extern bool_t	disdsp;

/*
 *  ^XNfBXpb`\
 *
 *  ݗDx}XNSԂłCfBXpb`ԂłifB
 *  Xpb`֎~ԂłȂjƂtOD
 */
extern bool_t	dspflg;

/*
 *  fBL[
 *
 *  fBL[́CsłԂ̃^XNǗ邽߂̃L[łD
 *  sԂ̃^XNǗĂ邽߁CfBis\jL[Ƃ
 *  ̂͐mł͂ȂCfBL[Ƃ̂蒅Ă邽߁C
 *  ̖̂ŌĂԂƂɂD
 *
 *  fBL[́CDxƂ̃^XNL[ō\ĂD^XN
 *  TCB́CYDx̃L[ɓo^D
 */
extern QUEUE	ready_queue[TNUM_TPRI];

/*
 *  fBL[T[`̂߂̃rbg}bv
 *
 *  fBL[̃T[`悭s߂ɁCDxƂ̃^XNL[
 *  Ƀ^XNĂ邩ǂrbg}bvpӂĂDrb
 *  g}bvgƂŁCANZX̉񐔂炷Ƃł邪C
 *  rbg얽߂[ĂȂvZbTŁCDx̒iKȂ
 *  ꍇɂ́Crbg}bṽI[o[wbĥ߂ɁCtɌ
 *  \D
 *
 *  Dx16iKł邱Ƃ肵Ă邽߁Cuint16_t^ƂĂD
 */
extern uint16_t	ready_primap;

/*
 *  ^XNID̍őlikernel_cfg.cj
 */
extern const ID	tmax_tskid;

/*
 *  ^XNubÑGAikernel_cfg.cj
 */
extern const TINIB	tinib_table[];

/*
 *  ^XNe[uikernel_cfg.cj
 */
extern const ID	torder_table[];

/*
 *  TCB̃GAikernel_cfg.cj
 */
extern TCB	tcb_table[];

/*
 *  ^XN̐
 */
#define tnum_tsk	((uint_t)(tmax_tskid - TMIN_TSKID + 1))

/*
 *  ^XNIDTCBo߂̃}N
 */
#define INDEX_TSK(tskid)	((uint_t)((tskid) - TMIN_TSKID))
#define get_tcb(tskid)		(&(tcb_table[INDEX_TSK(tskid)]))
#define get_tcb_self(tskid)	((tskid) == TSK_SELF ? p_runtsk : get_tcb(tskid))

/*
 *  TCB^XNIDo߂̃}N
 */
#define	TSKID(p_tcb)	((ID)(((p_tcb) - tcb_table) + TMIN_TSKID))

/*
 *  ^XNǗW[̏
 */
extern void	initialize_task(void);

/*
 *  ōD揇ʃ^XÑT[`
 *
 *  fBL[̍ōD揇ʂ̃^XNT[`CTCBւ̃|C^
 *  ԂDfBL[̏ꍇɂ́C̊֐ĂяoĂ͂ȂȂD
 */
extern TCB	*search_schedtsk(void);

/*
 *  słԂւ̑J
 *
 *  p_tcbŎw肳^XNfBL[ɑ}DfBL[ɑ}
 *  ^XN̗DxCōD揇ʂ̃^XN̗Dxꍇ́C
 *  ōD揇ʂ̃^XNXVCfBXpb`Ԃłtrue
 *  DłȂꍇfalseԂD
 */
extern bool_t	make_runnable(TCB *p_tcb);

/*
 *  słԂ瑼̏Ԃւ̑J
 *
 *  p_tcbŎw肳^XNfBL[폜Dp_tcbŎw肵
 *  ^XNōD揇ʂ̃^XNłꍇɂ́CōD揇ʂ̃^XN
 *  ݒ肵ȂCfBXpb`ԂłtrueԂDłȂ
 *  ꍇfalseԂD^XN̏Ԃ͍XVȂD
 */
extern bool_t	make_non_runnable(TCB *p_tcb);

/*
 *  x~Ԃւ̑J
 *
 *  p_tcbŎw肳^XN̏Ԃx~ԂƂD܂C^XN̋N
 *  ɏׂϐ̏ƁC^XNN̂߂̃ReLXg
 *  肷D
 */
extern void	make_dormant(TCB *p_tcb);

/*
 *  x~ԂsłԂւ̑J
 *
 *  p_tcbŎw肳^XN̏Ԃx~ԂsłԂƂD
 *  słԂɑJڂ^XNւ̃fBXpb`KvȏꍇtrueC
 *  łȂꍇfalseԂD
 */
extern bool_t	make_active(TCB *p_tcb);

/*
 *  ^XN̗Dx̕ύX
 *
 *  p_tcbŎw肳^XN̗Dxnewprii\jɕύXD܂C
 *  Kvȏꍇɂ͍ōD揇ʂ̃^XNXVCfBXpb`Ԃ
 *  trueԂDłȂꍇfalseԂD
 */
extern bool_t	change_priority(TCB *p_tcb, uint_t newpri);

/*
 *  fBL[̉]
 *
 *  fBL[́CpriŎw肳Dx̃^XNL[]D
 *  ܂CKvȏꍇɂ͍ōD揇ʂ̃^XNύXCfBXpb`
 *  ĂȂtrueԂDłȂꍇfalseԂD
 */
extern bool_t	rotate_ready_queue(uint_t pri);

/*
 *  ^XNO[`̌ďo
 *
 *  ^XNO[`ĂяoDĂяoOɁCsԂ̃^XN
 *  ۗOvNAC^XNO֎~ԂɂCCPUbN
 *  D
 *
 *  ^XNO[`߂ƁC܂CPUbNԂɖ߂C̊
 *  ɕۗOv0łȂȂĂ΁CĂу^XNO[`
 *  ĂяoDۗOv0̏ꍇɂ́COԂɂĊ֐
 *  烊^[D
 *
 *  ̊֐́CsԂ̃^XNC^XNOԁienatex
 *  truejŁCۗOv0łȂitexptn0łȂjꍇɌĂяo
 *  Ƃz肵ĂD̊֐́CCPUbNԂŌĂяoȂ΂Ȃ
 *  ȂD
 */
extern void	call_texrtn(void);

/*
 *  ^XNO[`̋N
 *
 *  sԂ̃^XN^XNO[`̋N𖞂Ă΁C
 *  ^XNO[`ĂяoDCPUO[`Ăяo
 *  ́CꎞICPUbND
 *
 *  ̊֐́CfBXpb`⊄݃nh^CPUOnh̏o
 *  Ăяo邱Ƃz肵ĂD̊֐́CCPUbN
 *  ŌĂяoȂ΂ȂȂD
 *
 *  sグ邽߂ɁC̊֐^[QbgˑŋLqĂ悢D
 *  ̏ꍇɂ́COMIT_CALLTEX}N`D
 */
extern void	calltex(void);

#endif /* TOPPERS_TASK_H */
