/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: dataqueue.h 91 2011-07-18 09:45:01Z nagasima $
 */

/*
 *		f[^L[@\
 */

#ifndef TOPPERS_DATAQUEUE_H
#define TOPPERS_DATAQUEUE_H

#include <queue.h>

/*
 *  f[^ǗubN
 */
typedef struct data_management_block {
	intptr_t	data;			/* f[^{ */
} DTQMB;

/*
 *  f[^L[ubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct dataqueue_initialization_block {
	ATR			dtqatr;			/* f[^L[ */
	uint_t		dtqcnt;			/* f[^L[̗e */
	DTQMB		*p_dtqmb;		/* f[^L[Ǘ̈̐擪Ԓn */
} DTQINIB;

/*
 *  f[^L[ǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct dataqueue_control_block {
	QUEUE		swait_queue;	/* f[^L[M҂L[ */
	const DTQINIB *p_dtqinib;	/* ubNւ̃|C^ */
	QUEUE		rwait_queue;	/* f[^L[M҂L[ */
	uint_t		count;			/* f[^L[̃f[^̐ */
	uint_t		head;			/* ŏ̃f[^̊i[ꏊ */
	uint_t		tail;			/* Ō̃f[^̊i[ꏊ̎ */
} DTQCB;

/*
 *  f[^L[҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 *  f[^L[ւ̑M҂ƃf[^L[̎M҂ŁC҂
 *  ubNgD
 */
typedef struct dataqueue_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	DTQCB		*p_dtqcb;		/* ҂Ăf[^L[̊ǗubN */
	intptr_t	data;			/* Mf[^ */
} WINFO_DTQ;

/*
 *  f[^L[ID̍őlikernel_cfg.cj
 */
extern const ID	tmax_dtqid;

/*
 *  f[^L[ubÑGAikernel_cfg.cj
 */
extern const DTQINIB	dtqinib_table[];

/*
 *  f[^L[ǗubÑGAikernel_cfg.cj
 */
extern DTQCB	dtqcb_table[];

/*
 *  f[^L[ǗubNf[^L[IDo߂̃}N
 */
#define	DTQID(p_dtqcb)	((ID)(((p_dtqcb) - dtqcb_table) + TMIN_DTQID))

/*
 *  f[^L[@\̏
 */
extern void	initialize_dataqueue(void);

/*
 *  f[^L[Ǘ̈ւ̃f[^̊i[
 */
extern void	enqueue_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  f[^L[Ǘ̈ւ̃f[^̋i[
 */
extern void	force_enqueue_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  f[^L[Ǘ̈悩̃f[^̎o
 */
extern void	dequeue_data(DTQCB *p_dtqcb, intptr_t *p_data);

/*
 *  f[^L[ւ̃f[^M
 */
extern bool_t	send_data(DTQCB *p_dtqcb, intptr_t data, bool_t *p_reqdsp);

/*
 *  f[^L[ւ̃f[^M
 */
extern bool_t	force_send_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  f[^L[̃f[^M
 */
extern bool_t	receive_data(DTQCB *p_dtqcb, intptr_t *p_data,
													bool_t *p_reqdsp);

#endif /* TOPPERS_DATAQUEUE_H */
