﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: ViewCommandButtonInfo.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Threading;
using System.Reflection;
using System.Security.Permissions;

namespace SimBase
{
	public class ViewCommandButtonInfo : CommandButtonInfo
	{
		private string m_Key;
		private Type[] m_UnitTypes;

		public ViewCommandButtonInfo(string name, Type commandType , string text, bool checkOnClick ,
			ToolStripItemDisplayStyle displayStyle, string key, params Type[] unitTypes)
			: base(name, commandType, text, checkOnClick, displayStyle, null, Color.Empty)
		{
			m_Key = key;
			m_UnitTypes = unitTypes;
		}

		public string Key { get { return m_Key; } }

		public Type[] UnitTypes { get { return m_UnitTypes; } }

		public bool IsAdaptable(IUnitSim unit)
		{
			if (m_UnitTypes.Length == 0)
				return true;

			if (unit == null)
				return false;

			IUnitSim bare = UnitSimAdpt<IUnitSim>.GetTarget(unit);
			Type unitType = bare.GetType();

			foreach (Type type in m_UnitTypes)
			{
				if ((unitType == type) || (unitType.IsSubclassOf(type)))
					return true;
			}

			return false;
		}
	}
}
