﻿//------------------------------------------------------------------------------
// TOPPERS/ASP Sample1 Debuging Environment
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Test0001.cs 87 2011-04-05 10:30:40Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;
using SimBase;

namespace Sample1Sim
{
	public class Sample1 : DllUnitSim
	{
		List<IUnitInterface> m_Interfaces = new List<IUnitInterface>();

		public Sample1()
			: base("Sample1")
		{
		}

		public override void Dispose()
		{
			ClearInterfaces();
			base.Dispose();
		}

		public event UnitOutputEventHandler ConsoleOut;

		protected override void Push(int kind, byte[] Data)
		{
			if (ConsoleOut != null)
				ConsoleOut(this, kind, Data);
		}

		public override IList<IUnitInterface> Interfaces
		{
			get { return m_Interfaces.AsReadOnly(); }
		}

		private void ClearInterfaces()
		{
			while (m_Interfaces.Count > 0)
			{
				IUnitInterface unitInterface = m_Interfaces[0];
				DoRemoveInterface(unitInterface);
				m_Interfaces.RemoveAt(0);
			}
		}
	}
}
