#include "ETLineTracer.h"
#include "LinePos.h"
#include "Runner.h"
#include "math.h"

ETLineTracer::ETLineTracer(LinePos& linepos, Runner& runner)
	: m_linepos(linepos), m_runner(runner), m_pid(0.4, 0.0015, 12.5), m_speedpid(0.3 ,0.03 ,10.0)
{
	m_pid.SetClip(-100.0,100.0);
	m_pid.SetIntegralClip(-1000.0,1000.0);
	m_speedpid.SetClip(0.0,50.0);
	m_speedpid.SetIntegralClip(-500.0,500.0);
}
ETLineTracer::~ETLineTracer(void)
{
}
void ETLineTracer::Run(int speed)
{
	int forward = 0;
	int turn = 0;
	CalcOutput(speed,m_linepos.GetLinePos(),forward,turn);
	m_runner.Run(forward,turn);
}
bool ETLineTracer::IsException() const
{
	return m_runner.IsException();
}
void ETLineTracer::Stop()
{
	m_runner.Stop();
}
void ETLineTracer::Reset()
{
	m_runner.Reset();
	m_pid.ResetPrevDiff();
	m_speedpid.ResetPrevDiff();
}
template<class T>
inline static void clipmax(T& val, const T& max){
	val = (val < max) ? val : max;
}
void ETLineTracer::CalcOutput(int speed, int linepos, int& forward, int& turn)
{
	float fturn = m_pid.CalcControlValue(static_cast<float>(linepos));
	turn = static_cast<int>(fturn);
	float fabsturn = fabs(fturn);
	float fwddiff;
	if(fabsturn < 5.0){
		fwddiff = -1.0;
	}else{
		fwddiff = fabsturn;
	}
	clipmax(speed,90);	// ȏł͑Ȃ̂Ő
	float fforward = static_cast<float>(speed) * (100.0 - m_speedpid.CalcControlValue(fwddiff)) / 100.0;
	forward = static_cast<int>(fforward);
}
