/* main.cpp for TOPPERS/ATK(OSEK) */ 

// ECRobot++ API
#include "Lcd.h"
#include "Bluetooth.h"
#include "BTConnection.h"
#include "Clock.h"
#include "GyroSensor.h"
#include "LightSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "SonarSensor.h"
#include "Speaker.h"
#include "TouchSensor.h"

#include "tsprintf.h"
#include "ETBalanceRunner.h"
#include "ETTailControl.h"
#include "ETUtility.h"

using namespace ecrobot;

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"

DeclareTask(TaskMain);
DeclareCounter(SysTimerCnt);//AlarmpKv

// global object instances
Nxt nxt;
Lcd lcd;
Speaker speaker;
Bluetooth bt;
Clock clock;
GyroSensor gyro(PORT_1);
SonarSensor sonar(PORT_2);
LightSensor light(PORT_3);
TouchSensor touch(PORT_4);
Motor motorT(PORT_A);
Motor motorR(PORT_B);
Motor motorL(PORT_C);

ETBalanceRunner runner(motorL,motorR,gyro,nxt);
ETTailControl tailcontroler(motorT,0);

/* foCXIptbN֐ */
/* ̊֐STOP܂EXIT{^ꂽɎs܂B */
void ecrobot_device_terminate()
{
	/* ZTA[^Ȃǂ̊efoCX̏I֐
	 * Ŏ邱Ƃł܂B
	 * ˁ@ZTԐFLEDOFFɂ
	 */
	//ecrobot_set_light_sensor_inactive(SENSOR_LIGHT);
	ecrobot_term_bt_connection(); /* BluetoothʐMI */							//ex4
}

 
// nxtOSEK hook to be invoked from an ISR in category 2
void user_1ms_isr_type2(void)
{
    //  //SleeppKv
    SleeperMonitor();
    //  //AlarmpKv
    StatusType ercd;
    ercd = SignalCounter(SysTimerCnt);
    if (ercd != E_OK) {
        ShutdownOS(ercd);
    }
}

TASK(TaskMain)
{
    //bt.setFriendlyName(DEVICE_NAME);
	BTConnection btConnection(bt, lcd, nxt);
	btConnection.connect(ETBluetoothString::PASS_KEY);
	lcd.clear();
	lcd.putf("s", "Hello World");
	lcd.disp();
    tailcontroler.Init();
    tailcontroler.SetAngle(ETTailControl::ANGLE_STAND_UP);

	// TODO:Ƃ肠̃Lu[V
	static const int sum_num = 256;
	unsigned long sum = 0;
	char str[16+1];
	// WC
	while(!ETUtilityStuff::Istouched(touch,tailcontroler)) {}
	for(int i=0;i<sum_num;i++){
		sum += gyro.get();
		clock.wait(10);
	}
	unsigned long offset = sum / sum_num;
	runner.SetGyroOffset(offset);
	tsprintf(str,"Offset = %d",offset);
	lcd.cursor(0,1);
	lcd.putf("s",str);
	lcd.disp();
	speaker.playTone(1000,100,50);

    //wait for touch or bluetooth.
    ETUtilityStuff::Waitstart(touch,tailcontroler,ETBluetoothString::CMD_START);

	tailcontroler.SetAngle(ETTailControl::ANGLE_DRIVE);
	TerminateTask();
}

TASK(Task4ms)
{
	if(touch.isPressed()){
		runner.Stop();
		runner.Reset();
		ActivateTask(TaskMain);
		TerminateTask();
		return;
	}
	runner.Run(150,0);
    tailcontroler.Control();

	TerminateTask();
}

int __cxa_pure_virtual(){
	// z֐I[o[ChȂŌĂяoꂽ̃G[nh
	// ȂramgpʂƂĂEEE
	return 0;
}

}	// extern "C"
