/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>
 *  <code>ifAuthorizedBlock</code> ^O̎NXB
 * </p>
 *
 * <p>
 *  {@link IfAuthorizedTag} ̌ʂ <code>blockId</code>
 *  ɐ䂷ׂ̃^OŁA
 *  <code>blockId</code>  {@link IfAuthorizedTag} ƕRtA
 *  {fB\邩ǂ𔻒肷B<br>
 *  ܂Ã^Oqɂ邱ƂŁAANZX̐_ɍsȂ\ɂȂB
 *  qɂꍇ́Ae^O <code>blockId</code>Ǝq^O<code>parentBlockId</code>
 *  ^ORtA{fB\邩ǂ𔻒肷B
 * </p>
 *
 * <br>
 * <h5>^OT|[g鑮</h5>
 * <p>{@link IfAuthorizedBlockTag} ł́Aȉ̑T|[gB</p>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Tv</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>blockId</code> </td>
 *    <td> - </td>
 *    <td> <code>true</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ΏۂƂȂ <code>blockId</code>B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>parentBlockId</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ̃^O̐eƂȂ {@link IfAuthorizedBlockTag}
 *     ƕRtׂ <code>blockId</code>B
 *    </td>
 *   </tr>
 *  </table>
 * </div>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p><code><pre>
 * &lt;t:ifAthorizedBlock blockId="ABC" &gt;
 *     {fB <code>blockId</code> ŕRtꂽ
 *     {@link IfAuthorizedBlockTag} \ꍇ̂ݕ\B
 *
 *     &lt;t:ifAthorizedBlock blockId="EFG" parentBlockId="ABC" &gt;
 *      {fB <code>blockId</code> ŕRtꂽ {@link IfAuthorizedTag}
 *      \ꍇ̂ݕ\B
 *
 *         &lt;t:ifAthorized path="/sample1/test.do blockId="EFG" &gt;
 *             w肳ꂽpXւ̃ANZXꍇAo͂B
 *         &lt;/t:ifAthorized&gt;
 *
 *     &lt;/t:ifAthorizedBlock&gt;
 * &lt;/t:ifAthorizedBlock&gt;
 * </pre></code></p>
 *
 *
 * @see jp.terasoluna.fw.web.taglib.IfAuthorizedTag
 *
 */
public class IfAuthorizedBlockTag extends BodyTagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 1062137481352416171L;

    /**
     * ONX
     */
    private static Log log
                  = LogFactory.getLog(IfAuthorizedBlockTag.class);

    /**
     * ubNIDB
     */
    private String blockId = null;

    /**
     * eubNIDB
     */
    private String parentBlockId = null;

    /**
     * ubNIDݒ肷B
     *
     * @param blockId ubNID
     */
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    /**
     * eubNIDݒ肷B
     *
     * @param parentBlockId eubNID
     */
    public void setParentBlockId(String parentBlockId) {
        this.parentBlockId = parentBlockId;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        if (this.blockId == null) {
            throw new JspException("blockId is required.");
        }

        // {fB]
        return EVAL_BODY_BUFFERED;
    }

    /**
     * ^O{fBIɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doAfterBody() throws JspException {

        // ubN擾
        Boolean blockInfo = null;
        try {
            // pageContext ubN擾
            blockInfo = (Boolean) pageContext.getAttribute(this.blockId);
        } catch (ClassCastException e) {
            if (log.isWarnEnabled()) {
                log.warn("Class cast error." , e);   
            }
        }

        // {fBoׂ͂ǂ
        boolean outputBody = false;
        if (blockInfo != null && blockInfo.booleanValue()) {
            //blockInfonullł͖truȅꍇ
            outputBody = true;
        }

        // eubN擾
        if (this.parentBlockId != null) {
            // ANZX`FbNʂۑ
            pageContext.setAttribute(
                this.parentBlockId, new Boolean(outputBody));
        }

        // {fBo
        if (outputBody) {
            try {
                bodyContent.writeOut(bodyContent.getEnclosingWriter());
            } catch (IOException e) {
                log.error("Output error.");
                throw new JspException(e);
            }
        }

        // {fBĕ]͂Ȃ
        return SKIP_BODY;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.blockId = null;
        this.parentBlockId = null;
    }

}
