/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;


/**
 * HttpSession ̃bNAbvNXB
 * 
 */
public class MockHttpSession implements HttpSession {

    /**
     * ZbVIDlB
     */
    private String id = "dummyID";

    /**
     * Agr[gli[p̃nbVe[uB
     */
    private Map attributes = new HashMap();

    /**
     * ̃ZbVT[ubgReLXg
     */
    private ServletContext context = new MockServletContext();

    /**
     * @see javax.servlet.http.HttpSession#getId()
     */
    public String getId() {
        return id;
    }

    /**
     * ZbVIDlZbgB
     * 
     * @param id ZbVIDl
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @see javax.servlet.http.HttpSession#getAttribute(String)
     */
    public Object getAttribute(String s) {
        return attributes.get(s);
    }

    /**
     * @see javax.servlet.http.HttpSession#getAttributeNames()
     */
    public Enumeration getAttributeNames() {
        return Collections.enumeration(attributes.keySet());
    }

    /**
     * @see javax.servlet.http.HttpSession#getCreationTime()
     */
    public long getCreationTime() {
        throw new UnsupportedOperationException(
            "getCreationTime() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#getLastAccessedTime()
     */
    public long getLastAccessedTime() {
        throw new UnsupportedOperationException(
            "getLastAccessedTime() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#getMaxInactiveInterval()
     */
    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException(
            "getMaxInactiveInterval() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#getSessionContext()
     * @deprecated
     */
    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException(
            "getSessionContext() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#getValue(String)
     * @deprecated
     */
    public Object getValue(String s) {
        return attributes.get(s);
    }

    /**
     * @see javax.servlet.http.HttpSession#getValueNames()
     * @deprecated
     */
    public String[] getValueNames() {
        return (String[]) attributes.keySet().toArray();
    }

    /**
     * @see javax.servlet.http.HttpSession#invalidate()
     */
    public void invalidate() {
        attributes.clear();
    }

    /**
     * @see javax.servlet.http.HttpSession#isNew()
     */
    public boolean isNew() {
        throw new UnsupportedOperationException(
            "isNew() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#putValue(String, Object)
     * @deprecated
     */
    public void putValue(String key, Object attr) {
        attributes.put(key, attr);
    }

    /**
     * @see javax.servlet.http.HttpSession#removeAttribute(String)
     */
    public void removeAttribute(String key) {
        attributes.remove(key);
    }

    /**
     * @see javax.servlet.http.HttpSession#removeValue(String)
     * @deprecated
     */
    public void removeValue(String key) {
        removeAttribute(key);
    }

    /**
     * @see javax.servlet.http.HttpSession#setAttribute(String, Object)
     */
    public void setAttribute(String key, Object attr) {
        if (attr != null) {
            attributes.put(key, attr);
        } else {
            removeAttribute(key);
        }
    }

    /**
     * @see javax.servlet.http.HttpSession#setMaxInactiveInterval(int)
     */
    public void setMaxInactiveInterval(int i) {
        throw new UnsupportedOperationException(
            "setMaxInactiveInterval() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpSession#getServletContext()
     */
    public ServletContext getServletContext() {
        return this.context;
    }

    /**
     * T[ubgReLXgݒ肷B
     * 
     * @param context T[ubgReLXg
     */
    public void setServletContext(ServletContext context) {
        this.context = context;
    }


}
