/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring;

import javax.servlet.ServletContext;

import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.spring.mock.MockWebApplicationContext;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.web.context.WebApplicationContext;

/**
 * T[ubgReLXgAvP[VReLXg擾鏈s
 * NX̃eXgP[XNX̌pNXB
 * 
 * ̃NX̃TuNX getConfigLocations() \bhŎw肳ꂽbean
 * i[AvP[VReLXgT[ubgReLXg
 * tB[hɎB̂
 * WebApplicationContextUtils#getWebApplicationContext(ServletContext) 
 * AvP[VReLXg擾\łB

 *
 */
public abstract class SpringTestCase extends
        AbstractDependencyInjectionSpringContextTests {
    
    /**
     * T[ubgReLXgB
     */
    protected ServletContext servletContext = new MockServletContext();

    /**
     * eXg̊𐮂B
     * 
     * AvP[VReLXgT[ubgReLXg
     * tB[hɃZbgĂdoOnSetUp()\bhĂяoB
     */
    @Override
    protected final void onSetUp() throws Exception {
        WebApplicationContext ctx = 
            new MockWebApplicationContext(getConfigLocations());
        this.servletContext.setAttribute(
                WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE,
                ctx);
        doOnSetUp();
    }
    
    /**
     * \bhBsvł΋邱ƁB
     * @throws Exception O
     */
    protected abstract void doOnSetUp() throws Exception;

}
