/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.List;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import junit.framework.TestCase;

/**
 * 
 * vpeB̓ǂݍ݂seXgP[XɎgpNXB
 * ̃NXgpꍇAŏɃvpeBLbVAŌ
 * ɖ߂̂ŁAPropertyUTUtilNXgpăvpeBύXĂ
 * ̃eXgP[Xɉe^ȂŃeXgsƂłB
 *
 *
 */
public abstract class PropertyTestCase extends TestCase{
    
    /**
     * PropertyUtil̃tpXB
     */
    private static final String PROPERTY_UTIL_NAME = 
            "jp.terasoluna.fw.util.PropertyUtil";
    
    /**
     * PropertyUtil̃vpeBێMap̃tB[hB
     */
    private static final String PROPERTY_FIELD = "props";
    
    /**
     * vpeBLbV邽߂ɎgpB
     */
    protected Map<String, String> cashMap =null;
    
    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public PropertyTestCase(String name) {
        super(name);
    }

    /**
     * RXgN^B
     */
    public PropertyTestCase() {
        super();
    }

    /**
     * vpeBLbVB
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        // vpeBLbVB
        saveProps();
        setUpData();
    }

    /**
     * vpeBeXgsOɖ߂ĂIB
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        cleanUpData();
        // vpeBeXgJnOɖ߂B
        loadProps();
    }
    
    /**
     * \bhBsvł΋邱ƁB
     * 
     * @throws Exception O
     */
    protected abstract void setUpData() throws Exception;

    /**
     * I\bhBsvł΋邱ƁB
     * 
     * @throws Exception IO
     */
    protected abstract void cleanUpData() throws Exception;
    
    /**
     * ݂̃vpeBLbV
     */ 
    private void saveProps() {
        this.cashMap = new HashMap<String, String>();
        Map<String, String> m = getProps();
        for (Map.Entry e : m.entrySet()) {
            // ǂݍ񂾂ׂ̂propsɒǉB
            this.cashMap.put((String) e.getKey(), (String) e.getValue());
        }
    }
    
    /**
     * LbVĂvpeBɖ߂B
     */
    private void loadProps() {
        Map<String, String> map= getProps();
        map.clear();
        map.putAll(this.cashMap);
    }
    
    /**
     * ݕێĂvpeB̒lMapŕԂB
     * @return ݕێĂvpeB
     */
    @SuppressWarnings("unchecked")
    public Map<String, String> getProps() {
        Class cls = null;
        Field field = null;
        Map<String, String> map = null;
        try {
            // ClassIuWFNg烁\bhw肵ĎsB
            cls = 
                Class.forName(PROPERTY_UTIL_NAME);
        } catch(ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            field = cls.getDeclaredField(PROPERTY_FIELD);
        } catch (NoSuchFieldException e) {
            // tB[hȂꍇB
            e.printStackTrace();
        }
        // privateANZX\ɂB
        field.setAccessible(true);
        try {
            map =(Map<String, String>) field.get(cls);
        } catch (IllegalAccessException e) {
            // tB[hɃANZXłȂꍇB
            e.printStackTrace();
        }
        return map;
    }
    
    /**
     * vpeBPǉB
     * @param key ǉL[B
     * @param value ǉlB
     */
    public void addProperty(String key, String value) {
        Map<String, String> currentMap = getProps();
        currentMap.put(key, value);
    }
    
    /**
     * vpeBMapƒǉB
     * @param m ǉvpeBMap
     */
    public void addPropertyAll(Map<String, String> m) {
        Map<String, String> currentMap = getProps();
        currentMap.putAll(m);
    }

    /**
     * vpeBYL[ (тɑΉl) 폜B
     * 
     * @param key 폜vpeB̃L[A܂̓L[̃vtBbNX
     */
    public void deleteProperty(String key) {
        Map<String, String> currentMap = getProps();
        Iterator<String> iter = currentMap.keySet().iterator();
        List<String> delList = new ArrayList<String>();
        while (iter.hasNext()) {
            String value = iter.next();
            if (value.startsWith(key)) {
                delList.add(value);
            }
        }
        for (int i = 0; i < delList.size(); i++) {
            String delKey = delList.get(i);
            currentMap.remove(delKey);
        }
    }

    /**
     * vpeBׂč폜B
     */
    public void clearProperty() {
        Map<String, String> currentMap = getProps();
        currentMap.clear();
    }
    
}
