/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import java.util.List;
import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobWorker;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.batch.restart.JobRestartTableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartPointCloser
implements Workable<Chunk> {
    private JobWorker jobWorker = null;
    private JobRestartTableHandler jobRestartTableHandler = null;
    private List<SupportLogic<JobContext>> supportLogicList = null;
    private String sqlKey = null;

    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        this.jobWorker.work(chunk, jobStatus);
        if (jobStatus.isExecuting() || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isShutdownGraceful()) {
            this.jobRestartTableHandler.registerRestartPoint(chunk.getJobContext(), jobStatus);
            if (this.supportLogicList == null || this.supportLogicList.size() == 0) {
                this.jobRestartTableHandler.restartPointClear(jobStatus, this.sqlKey);
            }
        }
    }

    public void setJobRestartTableHandler(JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    public void setJobWorker(JobWorker jobWorker) {
        this.jobWorker = jobWorker;
    }

    public void setSupportLogicList(List<SupportLogic<JobContext>> supportLogicList) {
        this.supportLogicList = supportLogicList;
    }

    public void setSqlKey(String sqlKey) {
        this.sqlKey = sqlKey;
    }
}

