/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.init;

import java.util.ArrayList;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.init.JobInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobRequestInfo
implements JobInfo {
    private static final long serialVersionUID = 3134293738030810122L;
    private static Log log = LogFactory.getLog(JobRequestInfo.class);
    private static final String PROCESS_ID_SPLIT = "-P";
    private String jobId = null;
    private String jobDiscriptorPath = null;
    private String[] jobParameters = null;
    private String jobRequestNo = "";
    private String[] inParameters = null;

    public JobRequestInfo(String[] inStr) {
        this.inParameters = inStr;
    }

    public void init() {
        if (this.inParameters == null || this.inParameters.length < 2) {
            throw new InitializeException("There is not a required argument at the time of job start");
        }
        this.setJobId(this.inParameters[0]);
        this.setJobDiscriptorPath(this.inParameters[1]);
        this.setJobParameters(this.inParameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parameter values\uff1a" + this.toString()));
        }
    }

    public String[] getJobParameters() {
        return this.jobParameters;
    }

    public String getJobDiscriptorPath() {
        return this.jobDiscriptorPath;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobRequestNo() {
        return this.jobRequestNo;
    }

    private void setJobParameters(String[] inStr) {
        ArrayList<String> tempArray = new ArrayList<String>();
        for (int index = 2; index < inStr.length; ++index) {
            String tempStr = inStr[index];
            if (tempStr != null && PROCESS_ID_SPLIT.equalsIgnoreCase(tempStr)) {
                if (index >= inStr.length - 1) continue;
                this.jobRequestNo = inStr[++index];
                continue;
            }
            tempArray.add(tempStr);
        }
        this.jobParameters = tempArray.toArray(new String[tempArray.size()]);
    }

    private void setJobDiscriptorPath(String jobDiscriptorPath) {
        if (jobDiscriptorPath == null) {
            throw new InitializeException("A job Bean definition file is null");
        }
        this.jobDiscriptorPath = jobDiscriptorPath;
    }

    private void setJobId(String jobId) {
        if (jobId == null) {
            throw new InitializeException("jobID is null");
        }
        this.jobId = jobId;
    }

    public String toString() {
        StringBuilder returnStr = new StringBuilder();
        returnStr.append("[jobId=" + this.jobId + "]");
        returnStr.append("[jobDiscriptPath\uff1a" + this.jobDiscriptorPath + "]");
        returnStr.append("[parameters\uff1a[");
        for (int i = 0; i < this.jobParameters.length; ++i) {
            returnStr.append(this.jobParameters[i]);
            if (i == this.jobParameters.length - 1) continue;
            returnStr.append(", ");
        }
        returnStr.append("]]");
        returnStr.append("[jobRequestNo\uff1a" + this.jobRequestNo + "]");
        return returnStr.toString();
    }
}

