/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.xml.sax.SAXException;

public class BLogicIOPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog(BLogicIOPlugIn.class);
    public static final String BLOGIC_MAPPER_KEY = "BLOGIC_MAPPER";
    private static final String DIGESTER_RULES_PATH = "/WEB-INF/blogic-io-rules.xml";
    private String publicIdentifier = "-//NTTDATA//DTD TERASOLUNA for Spring blogic-io 1.0//JA";
    private String dtdUrl = "/jp/terasoluna/fw/web/struts/plugins/dtd/blogic-io.dtd";
    private ActionServlet servlet = null;
    private String digesterRules = null;
    private String resources = null;
    private String mapperStr = null;
    private BLogicResources blogicResources = null;
    private AbstractBLogicMapper blogicMapper = null;
    private static Digester digester = null;

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        String moduleName = config.getPrefix();
        this.initResources();
        servlet.getServletContext().setAttribute("BLOGIC_RESOURCES" + moduleName, (Object)this.blogicResources);
        this.initMapper();
        servlet.getServletContext().setAttribute(BLOGIC_MAPPER_KEY + moduleName, (Object)this.blogicMapper);
    }

    private void initResources() throws ServletException {
        if (this.resources == null || "".equals(this.resources)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"resources file location is not specified");
            }
            return;
        }
        StringTokenizer st = new StringTokenizer(this.resources, ",");
        ArrayList<String> pathList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            path = path.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("blogic io file=" + path));
            }
            pathList.add(path);
        }
        try {
            if (digester == null) {
                if (this.digesterRules == null) {
                    this.digesterRules = DIGESTER_RULES_PATH;
                }
                digester = DigesterLoader.createDigester((URL)this.servlet.getServletContext().getResource(this.digesterRules));
                digester.setValidating(true);
            }
            this.blogicResources = new BLogicResources();
            for (int i = 0; i < pathList.size(); ++i) {
                digester.push((Object)this.blogicResources);
                URL url = this.getClass().getResource(this.getDtdUrl());
                if (url != null) {
                    digester.register(this.getPublicIdentifier(), url.toString());
                }
                digester.parse(this.servlet.getServletContext().getResourceAsStream((String)pathList.get(i)));
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (XmlLoadException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public String getDtdUrl() {
        return this.dtdUrl;
    }

    private void initMapper() throws ServletException {
        Object[] args = new Object[]{this.resources};
        if (this.mapperStr != null) {
            try {
                this.blogicMapper = (AbstractBLogicMapper)ClassUtil.create(this.mapperStr, args);
            }
            catch (ClassLoadException e) {
                log.error((Object)"", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (ClassCastException e) {
                log.error((Object)"", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            this.blogicMapper = new BLogicMapper(this.resources);
        }
    }

    public void setDigesterRules(String digesterRules) {
        this.digesterRules = digesterRules;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    public void setMapperClass(String mapperStr) {
        this.mapperStr = mapperStr;
    }

    public void setPublicIdentifier(String publicIdentifier) {
        this.publicIdentifier = publicIdentifier;
    }

    public void setDtdUrl(String dtdUrl) {
        this.dtdUrl = dtdUrl;
    }
}

