/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;
import org.apache.commons.lang.StringUtils;

public class FileDAOUtility {
    public static String padding(String columnString, String fileEncoding, int columnBytes, char paddingChar, PaddingType paddingType) {
        try {
            StringBuilder columnBuilder = new StringBuilder();
            if (1 < Character.toString(paddingChar).getBytes(fileEncoding).length) {
                throw new FileException("Padding char is not half-width character.");
            }
            if (PaddingType.LEFT.equals((Object)paddingType)) {
                for (int i = 0; i < columnBytes - columnString.getBytes(fileEncoding).length; ++i) {
                    columnBuilder.append(paddingChar);
                }
                columnBuilder.append(columnString);
                return columnBuilder.toString();
            }
            if (PaddingType.RIGHT.equals((Object)paddingType)) {
                columnBuilder.append(columnString);
                for (int i = 0; i < columnBytes - columnString.getBytes(fileEncoding).length; ++i) {
                    columnBuilder.append(paddingChar);
                }
                return columnBuilder.toString();
            }
            return columnString;
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(e);
        }
    }

    public static String trim(String columnString, String fileEncoding, char trimChar, TrimType trimType) {
        StringBuilder columnBuffer = new StringBuilder();
        boolean trimFlag = false;
        try {
            if (1 < Character.toString(trimChar).getBytes(fileEncoding).length) {
                throw new FileException("Trim char is not half-width character.");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(e);
        }
        if (TrimType.LEFT.equals((Object)trimType)) {
            for (char columnChar : columnString.toCharArray()) {
                if (trimFlag) {
                    columnBuffer.append(columnChar);
                    continue;
                }
                if (columnChar == trimChar) continue;
                trimFlag = true;
                columnBuffer.append(columnChar);
            }
            return columnBuffer.toString();
        }
        if (TrimType.RIGHT.equals((Object)trimType)) {
            String reverseColumn = StringUtils.reverse((String)columnString);
            for (char columnChar : reverseColumn.toCharArray()) {
                if (trimFlag) {
                    columnBuffer.append(columnChar);
                    continue;
                }
                if (columnChar == trimChar) continue;
                trimFlag = true;
                columnBuffer.append(columnChar);
            }
            return StringUtils.reverse((String)columnBuffer.toString());
        }
        return columnString;
    }
}

