/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Configuration;
import org.exolab.castor.mapping.MappingException;

public final class SQLTypeInfos {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$engine$SQLTypeInfos == null ? (class$org$castor$jdo$engine$SQLTypeInfos = SQLTypeInfos.class$("org.castor.jdo.engine.SQLTypeInfos")) : class$org$castor$jdo$engine$SQLTypeInfos));
    private static final TypeInfo[] TYPEINFO = new TypeInfo[]{new TypeInfo(-7, "bit", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SQLTypeInfos.class$("java.lang.Boolean")) : class$java$lang$Boolean), new TypeInfo(-6, "tinyint", class$java$lang$Byte == null ? (class$java$lang$Byte = SQLTypeInfos.class$("java.lang.Byte")) : class$java$lang$Byte), new TypeInfo(5, "smallint", class$java$lang$Short == null ? (class$java$lang$Short = SQLTypeInfos.class$("java.lang.Short")) : class$java$lang$Short), new TypeInfo(4, "integer", class$java$lang$Integer == null ? (class$java$lang$Integer = SQLTypeInfos.class$("java.lang.Integer")) : class$java$lang$Integer), new TypeInfo(-5, "bigint", class$java$lang$Long == null ? (class$java$lang$Long = SQLTypeInfos.class$("java.lang.Long")) : class$java$lang$Long), new TypeInfo(6, "float", class$java$lang$Double == null ? (class$java$lang$Double = SQLTypeInfos.class$("java.lang.Double")) : class$java$lang$Double), new TypeInfo(8, "double", class$java$lang$Double == null ? (class$java$lang$Double = SQLTypeInfos.class$("java.lang.Double")) : class$java$lang$Double), new TypeInfo(7, "real", class$java$lang$Float == null ? (class$java$lang$Float = SQLTypeInfos.class$("java.lang.Float")) : class$java$lang$Float), new TypeInfo(2, "numeric", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypeInfos.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), new TypeInfo(3, "decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLTypeInfos.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), new TypeInfo(1, "char", class$java$lang$String == null ? (class$java$lang$String = SQLTypeInfos.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(12, "varchar", class$java$lang$String == null ? (class$java$lang$String = SQLTypeInfos.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(-1, "longvarchar", class$java$lang$String == null ? (class$java$lang$String = SQLTypeInfos.class$("java.lang.String")) : class$java$lang$String), new TypeInfo(91, "date", class$java$sql$Date == null ? (class$java$sql$Date = SQLTypeInfos.class$("java.sql.Date")) : class$java$sql$Date), new TypeInfo(92, "time", class$java$sql$Time == null ? (class$java$sql$Time = SQLTypeInfos.class$("java.sql.Time")) : class$java$sql$Time), new TypeInfo(93, "timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SQLTypeInfos.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), new TypeInfo(-2, "binary", array$B == null ? (array$B = SQLTypeInfos.class$("[B")) : array$B), new TypeInfo(-3, "varbinary", array$B == null ? (array$B = SQLTypeInfos.class$("[B")) : array$B), new TypeInfo(-4, "longvarbinary", array$B == null ? (array$B = SQLTypeInfos.class$("[B")) : array$B), new TypeInfo(1111, "other", class$java$lang$Object == null ? (class$java$lang$Object = SQLTypeInfos.class$("java.lang.Object")) : class$java$lang$Object), new TypeInfo(2000, "javaobject", class$java$lang$Object == null ? (class$java$lang$Object = SQLTypeInfos.class$("java.lang.Object")) : class$java$lang$Object), new TypeInfo(2004, "blob", class$java$io$InputStream == null ? (class$java$io$InputStream = SQLTypeInfos.class$("java.io.InputStream")) : class$java$io$InputStream), new TypeInfo(2005, "clob", class$java$sql$Clob == null ? (class$java$sql$Clob = SQLTypeInfos.class$("java.sql.Clob")) : class$java$sql$Clob)};
    private static final ThreadLocal THREAD_SAFE_CALENDAR = new ThreadLocal(){

        public Object initialValue() {
            return new GregorianCalendar();
        }
    };
    private static final TimeZone TIME_ZONE;
    static /* synthetic */ Class class$org$castor$jdo$engine$SQLTypeInfos;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$sql$Clob;

    private static Calendar getCalendar() {
        Calendar calendar = (Calendar)THREAD_SAFE_CALENDAR.get();
        calendar.setTimeZone(TIME_ZONE);
        return calendar;
    }

    public static Class sqlTypeNum2javaType(int sqlTypeNum) throws MappingException {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (sqlTypeNum != TYPEINFO[i]._sqlTypeNum) continue;
            return TYPEINFO[i]._javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", new Integer(sqlTypeNum));
    }

    public static Class sqlTypeName2javaType(String sqlTypeName) throws MappingException {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (!sqlTypeName.equals(TYPEINFO[i]._sqlTypeName)) continue;
            return TYPEINFO[i]._javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", sqlTypeName);
    }

    public static int javaType2sqlTypeNum(Class javaType) {
        for (int i = 0; i < TYPEINFO.length; ++i) {
            if (!javaType.isAssignableFrom(TYPEINFO[i]._javaType)) continue;
            return TYPEINFO[i]._sqlTypeNum;
        }
        return 1111;
    }

    public static Object getValue(ResultSet rs, int index, int sqlType) throws SQLException {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(index);
            }
            case 2: 
            case 3: {
                return rs.getBigDecimal(index);
            }
            case 4: {
                int intVal = rs.getInt(index);
                return rs.wasNull() ? null : new Integer(intVal);
            }
            case 92: {
                return rs.getTime(index, SQLTypeInfos.getCalendar());
            }
            case 91: {
                return rs.getDate(index, SQLTypeInfos.getCalendar());
            }
            case 93: {
                return rs.getTimestamp(index, SQLTypeInfos.getCalendar());
            }
            case 6: 
            case 8: {
                double doubleVal = rs.getDouble(index);
                return rs.wasNull() ? null : new Double(doubleVal);
            }
            case 7: {
                float floatVal = rs.getFloat(index);
                return rs.wasNull() ? null : new Float(floatVal);
            }
            case 5: {
                short shortVal = rs.getShort(index);
                return rs.wasNull() ? null : new Short(shortVal);
            }
            case -6: {
                byte byteVal = rs.getByte(index);
                return rs.wasNull() ? null : new Byte(byteVal);
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case 2004: {
                Blob blob = rs.getBlob(index);
                return blob == null ? null : blob.getBinaryStream();
            }
            case 2005: {
                return rs.getClob(index);
            }
            case -5: {
                long longVal = rs.getLong(index);
                return rs.wasNull() ? null : new Long(longVal);
            }
            case -7: {
                boolean boolVal = rs.getBoolean(index);
                return rs.wasNull() ? null : new Boolean(boolVal);
            }
        }
        Object value = rs.getObject(index);
        return rs.wasNull() ? null : value;
    }

    public static void setValue(PreparedStatement stmt, int index, Object value, int sqlType) {
        try {
            if (value == null) {
                stmt.setNull(index, sqlType);
            } else {
                switch (sqlType) {
                    case 6: 
                    case 8: {
                        stmt.setDouble(index, (Double)value);
                        break;
                    }
                    case 7: {
                        stmt.setFloat(index, ((Float)value).floatValue());
                        break;
                    }
                    case 91: {
                        stmt.setDate(index, (Date)value);
                        break;
                    }
                    case 93: {
                        stmt.setTimestamp(index, (Timestamp)value);
                        break;
                    }
                    case 2004: {
                        try {
                            InputStream stream = (InputStream)value;
                            stmt.setBinaryStream(index, stream, stream.available());
                            break;
                        }
                        catch (IOException ex) {
                            throw new SQLException(ex.toString());
                        }
                    }
                    case 2005: {
                        Clob clob = (Clob)value;
                        stmt.setCharacterStream(index, clob.getCharacterStream(), (int)Math.min(clob.length(), Integer.MAX_VALUE));
                        break;
                    }
                    default: {
                        stmt.setObject(index, value, sqlType);
                    }
                }
            }
        }
        catch (SQLException ex) {
            LOG.error((Object)"Unexpected SQL exception: ", (Throwable)ex);
        }
    }

    private SQLTypeInfos() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Configuration config = Configuration.getInstance();
        String zone = config.getProperty("org.exolab.castor.jdo.defaultTimeZone", "");
        TIME_ZONE = zone.length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(zone);
    }

    private static class TypeInfo {
        private final int _sqlTypeNum;
        private final String _sqlTypeName;
        private final Class _javaType;

        TypeInfo(int sqlTypeNum, String sqlTypeName, Class javaType) {
            this._sqlTypeNum = sqlTypeNum;
            this._sqlTypeName = sqlTypeName;
            this._javaType = javaType;
        }
    }
}

