/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.oxm.serialize;

import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializerEx
extends XMLSerializer {
    public static final String CDATA = "CDATA";
    public static final String PRESERVE_OPTION = "preserve";
    protected boolean atRoot = true;
    protected boolean preserveWhitespace = true;

    public XMLSerializerEx() {
    }

    public XMLSerializerEx(Writer writer, OutputFormat format) {
        super(writer, format);
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        if (this.atRoot && this.isPreserveWhitespace()) {
            if (attrs instanceof AttributeListImpl) {
                AttributeListImpl attr = (AttributeListImpl)attrs;
                attr.addAttribute("xml:space", CDATA, PRESERVE_OPTION);
            }
            this.atRoot = false;
        }
        super.startElement(tagName, attrs);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        if (this.atRoot && this.isPreserveWhitespace()) {
            if (attrs instanceof AttributesImpl) {
                AttributesImpl attr = (AttributesImpl)attrs;
                attr.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", CDATA, PRESERVE_OPTION);
            }
            this.atRoot = false;
        }
        super.startElement(namespaceURI, localName, rawName, attrs);
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }
}

