/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayUtil {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static List getListFromByteArray(byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Byte(byArray[i]));
        }
        return arrayList;
    }

    public static List getListFromObjectArray(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static byte[] getByteArrayFromList(List list) {
        return ArrayUtil.getByteArrayFromList(list, 0);
    }

    public static byte[] getByteArrayFromList(List list, int n) {
        return ArrayUtil.getByteArrayFromList(list, n, list.size() - n);
    }

    public static byte[] getByteArrayFromList(List list, int n, int n2) {
        if (list.size() == 0) {
            return new byte[0];
        }
        if (n >= list.size()) {
            throw new IndexOutOfBoundsException("Position " + n + " invalid in List of size " + list.size());
        }
        byte[] byArray = new byte[n2];
        for (int i = n; i < list.size() && i < n + n2; ++i) {
            Byte by = (Byte)list.get(i);
            if (null == by) continue;
            byArray[i - n] = by;
        }
        return byArray;
    }

    public static void addBytesToList(byte[] byArray, List list, int n) {
        ArrayUtil.addBytesToList(byArray, 0, byArray.length, list, n);
    }

    public static void addBytesToList(byte[] byArray, int n, int n2, List list, int n3) {
        int n4;
        int n5 = n3 + n2 - list.size();
        if (n5 > 0) {
            for (n4 = 0; n4 < n5; ++n4) {
                list.add(null);
            }
        }
        for (n4 = n3; n4 < n3 + n2; ++n4) {
            list.set(n4, new Byte(byArray[n + n4 - n3]));
        }
    }

    public static Object truncateArray(Object object, int n) {
        return ArrayUtil.truncateArray(object, 0, n);
    }

    public static Object truncateArray(Object object, int n, int n2) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("sourceArray must be an array");
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        System.arraycopy(object, n, object2, 0, n2);
        return object2;
    }

    public static Object copyArray(Object object) {
        if (!object.getClass().isArray()) {
            return object;
        }
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, Array.getLength(object));
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, Array.get(object, i));
        }
        return object2;
    }

    public static Object[] convertToObjectArray(Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("sourceArray must be an array");
        }
        Class clazz = object.getClass().getComponentType();
        if (!clazz.isPrimitive()) {
            return (Object[])object;
        }
        if (clazz.equals(Boolean.TYPE)) {
            clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ArrayUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        } else if (clazz.equals(Byte.TYPE)) {
            clazz = class$java$lang$Byte == null ? (class$java$lang$Byte = ArrayUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
        } else if (clazz.equals(Character.TYPE)) {
            clazz = class$java$lang$Character == null ? (class$java$lang$Character = ArrayUtil.class$("java.lang.Character")) : class$java$lang$Character;
        } else if (clazz.equals(Short.TYPE)) {
            clazz = class$java$lang$Short == null ? (class$java$lang$Short = ArrayUtil.class$("java.lang.Short")) : class$java$lang$Short;
        } else if (clazz.equals(Integer.TYPE)) {
            clazz = class$java$lang$Integer == null ? (class$java$lang$Integer = ArrayUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
        } else if (clazz.equals(Long.TYPE)) {
            clazz = class$java$lang$Long == null ? (class$java$lang$Long = ArrayUtil.class$("java.lang.Long")) : class$java$lang$Long;
        } else if (clazz.equals(Float.TYPE)) {
            clazz = class$java$lang$Float == null ? (class$java$lang$Float = ArrayUtil.class$("java.lang.Float")) : class$java$lang$Float;
        } else if (clazz.equals(Double.TYPE)) {
            clazz = class$java$lang$Double == null ? (class$java$lang$Double = ArrayUtil.class$("java.lang.Double")) : class$java$lang$Double;
        }
        int n = Array.getLength(object);
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public static Object convertToPrimitiveArray(Object[] objectArray) {
        Class<Object> clazz = objectArray.getClass().getComponentType();
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ArrayUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            clazz = Boolean.TYPE;
        } else if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = ArrayUtil.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            clazz = Byte.TYPE;
        } else if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = ArrayUtil.class$("java.lang.Character")) : class$java$lang$Character)) {
            clazz = Character.TYPE;
        } else if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = ArrayUtil.class$("java.lang.Short")) : class$java$lang$Short)) {
            clazz = Short.TYPE;
        } else if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = ArrayUtil.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            clazz = Integer.TYPE;
        } else if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = ArrayUtil.class$("java.lang.Long")) : class$java$lang$Long)) {
            clazz = Long.TYPE;
        } else if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = ArrayUtil.class$("java.lang.Float")) : class$java$lang$Float)) {
            clazz = Float.TYPE;
        } else if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = ArrayUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
            clazz = Double.TYPE;
        } else {
            throw new IllegalArgumentException("sourceArray is of type " + clazz + " which is not allowed");
        }
        int n = Array.getLength(objectArray);
        Object object = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, Array.get(objectArray, i));
        }
        return object;
    }

    public static Object convertToArray(Object object) {
        if (object.getClass().isArray()) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass(), 1);
        Array.set(object2, 0, object);
        return object2;
    }

    public static boolean areArraysEqual(Object object, Object object2) {
        int n;
        if (null == object && null == object2) {
            return true;
        }
        if (null == object || null == object2) {
            return false;
        }
        if (!object.getClass().isArray() && !object2.getClass().isArray()) {
            return object.equals(object2);
        }
        if (!object.getClass().isArray() || !object2.getClass().isArray()) {
            return false;
        }
        int n2 = Array.getLength(object);
        if (n2 != (n = Array.getLength(object2))) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Object object3 = Array.get(object, i);
            Object object4 = Array.get(object2, i);
            if (null != object3 && !object3.equals(object4)) {
                return false;
            }
            if (null != object3 || null == object4) continue;
            return false;
        }
        return true;
    }

    public static int computeHashCode(Object object) {
        if (null == object) {
            return 0;
        }
        if (!object.getClass().isArray()) {
            return object.hashCode();
        }
        int n = Array.getLength(object);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (null == object2) continue;
            n2 += 31 * object2.hashCode();
        }
        return n2;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        return ArrayUtil.indexOf(byArray, byArray2, 0);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        if (n + byArray2.length > byArray.length) {
            return -1;
        }
        for (int i = n; i <= byArray.length - byArray2.length; ++i) {
            int n2;
            for (n2 = 0; n2 < byArray2.length && byArray2[n2] == byArray[i + n2]; ++n2) {
            }
            if (n2 != byArray2.length) continue;
            return i;
        }
        return -1;
    }

    public static void ensureUnique(String[] stringArray) {
        Map map = ArrayUtil.collectOccurences(stringArray);
        ArrayUtil.renameDuplicates(stringArray, map);
    }

    private static void renameDuplicates(String[] stringArray, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n = (Integer)map.get(string);
            if (n <= 1) continue;
            int n2 = 1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                stringArray[i] = string + n2;
                ++n2;
            }
        }
    }

    private static Map collectOccurences(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = (Integer)hashMap.get(stringArray[i]);
            if (null == n) {
                hashMap.put(stringArray[i], new Integer(1));
                continue;
            }
            hashMap.put(stringArray[i], new Integer(n + 1));
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

