/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;


/**
 *  Bean֘Ã[eBeBNXB
 *
 * @see jp.terasoluna.fw.util.PropertyAccessException
 *
 */
public final class BeanUtil {

    /**
     * w肵JavaBeañvpeBɒli[B
     *
     * @param bean
     *            l̊i[ƂJavaBean
     * @param property
     *            JavaBeañvpeB
     * @param value
     *            i[l
     * @throws PropertyAccessException
     *             li[ɔObvO
     */
    public static void setBeanProperty(Object bean, String property,
            Object value) throws PropertyAccessException {

        try {
            // ͒lݒ胁\bhs
            PropertyUtils.setProperty(bean, property, value);
        } catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        } catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        } catch (InvocationTargetException e) {
            throw new PropertyAccessException(e.getTargetException());
        } catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
    }

    /**
     * w肵JavaBeañvpeBl擾B
     *
     * @param bean
     *            l̎擾ƂJavaBean
     * @param property
     *            JavaBeañvpeB
     * @return value 擾l
     * @throws PropertyAccessException
     *             l擾ɔObvO
     */
    public static Object getBeanProperty(Object bean, String property)
            throws PropertyAccessException {

        Object value = null;
        try {
            value = PropertyUtils.getProperty(bean, property);
        } catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        } catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        } catch (InvocationTargetException e) {
            throw new PropertyAccessException(e.getTargetException());
        } catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
        return value;
    }
    
    /**
     * w肵JavaBeañvpeB^擾B
     * @param bean
     *            l̎擾ƂJavaBean
     * @param property
     *            JavaBeañvpeB
     * @return ̃NXB
     * @throws PropertyAccessException l擾ɔObvO
     */
    public static Class getBeanPropertyType(Object bean, String property) 
        throws PropertyAccessException {
        try {
            Class type = null;
            if (bean instanceof DynaBean) {
                DynaProperty descriptor = ((DynaBean) bean).getDynaClass()
                    .getDynaProperty(property);
                if (descriptor != null){
                    type = descriptor.getType();
                }
            }
            else{
                type = PropertyUtils.getPropertyType(bean, property);
            }
            return type;
        } catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        } catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        } catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        } catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
    }
}

