/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

/**
 * L[̏gUNVōsL[vZbTNXB
 * 
 * <p>L[ׂ̂Ă̗vf̏sŁAWuXe[^X
 * <code>JobStatus.STATE.STARTED</code>A<code>JobStatus.STATE.RESTARTED</code>
 * A邢<code>JobStatus.STATE.ENDING_NORMALLY</code>
 * łꍇɂ̓R~bgÂق̏ꍇɂ̓[obNB</p>
 *
 * <p>gUNVs߁AWuXe[^XƂ 
 * <code>TransactionalJobStatus</code>gpKvB</p>
 * 
 */
public class TransactionalQueueProcessor extends QueueProcessor {

    /**
     * L[̏sB
     *
     * @param workQueue L[
     * @param jobStatus gUNViWuXe[^X
     */
    @Override
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        transactionalJobStatus.beginTransaction();
        
        try {
            super.process(workQueue, jobStatus);
        } catch (QueueingException e) {
            // I/fÎƂ̓[obN
            if (jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
                transactionalJobStatus.rollback();
                return;
            } else {
                throw e;
            }
        }

        if (jobStatus.isExecuting()
                || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY) {
            transactionalJobStatus.commit();
        } else {
            transactionalJobStatus.rollback();
        }
    }
}
