/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobWorker;
import jp.terasoluna.fw.batch.core.Workable;

/**
 * X^[g|Cgo^p[JNXB
 * 
 */
public class RestartPointUpdater implements Workable<Chunk> {

    /**
     * N郏[JB
     */
    private JobWorker jobWorker = null;
    
    /**
     * WuX^[ge[unhB
     */
    private JobRestartTableHandler jobRestartTableHandler = null;

    /**
     * `N̏sB
     * 
     * <p>
     * `N̏ꍇɁAWuX^[g|Cgo^sB
     * </p>
     * 
     * @param chunk `N
     * @param jobStatus Wu
     */
    public void work(Chunk chunk, JobStatus jobStatus) {
        jobWorker.work(chunk, jobStatus);

        //X^[g|Cgo^
        if (jobStatus.isExecuting()
                || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY
                || jobStatus.isShutdownGraceful()) {
            jobRestartTableHandler.registerRestartPoint(chunk.getJobContext(),
                    jobStatus);
        }
    }

    /**
     * WuX^[ge[unhݒ肷B
     * 
     * @param jobRestartTableHandler WuX^[ge[unh
     */
    public void setJobRestartTableHandler(
            JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    /**
     * Wu[Jݒ肷B
     * 
     * @param jobWorker Wu[J
     */
    public void setJobWorker(JobWorker jobWorker) {
        this.jobWorker = jobWorker;
    }
}
