using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using TDCG;
using TDCGUtils;
using Tso2Pmd;

using jp.nyatla.nymmd.cs.types;
using jp.nyatla.nymmd.cs.core;
using jp.nyatla.nymmd.cs.struct_type;
using jp.nyatla.nymmd.cs.struct_type.pmd;

namespace TDCG.PhysObTemplate
{
    public class Chichi_Hard : IPhysObTemplate
    {
        string name = "";   // gɕ\閼O
        int group = 1;          // \g̎ށi0: 1: 2:XJ[g 3:̑j

        public string Name() { return name; }
        public int Group() { return group; }

        public void Execute(ref T2PPhysObjectList phys_list)
        {
            phys_list.MakeChain("EP");
            phys_list.MakeChain("P");
        
            SetParameter(phys_list.GetBodyListByName(".."));
            SetParameterEnd(phys_list.GetBodyListByName("."));
            SetParameter(phys_list.GetJointListByName(".."));
            phys_list.GetBodyByName("EP").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("P").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("EQ").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            phys_list.GetBodyByName("Q").rigidbody_type = 0; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
        }

        private void SetParameter(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 3; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 2; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.rigidbody_weight = 0.1f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.5f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameterEnd(List<PMD_RigidBody> body_list)
        {
            foreach (PMD_RigidBody body in body_list)
            {
                body.rigidbody_group_index = 3; // f[^FO[v // 00
                body.rigidbody_group_target = 1; // f[^FO[vFΏ // 0xFFFFƂ̍ // 38 FE
                body.shape_type = 0; // `F^Cv(0:A1:A2:JvZ) // 00 // 
                body.shape_w = 0.2f; // `Fa() // CD CC CC 3F // 1.6

                body.rigidbody_weight = 0.01f; // f[^F // 00 00 80 3F // 1.0
                body.rigidbody_pos_dim = 0.5f; // f[^Fړ // 00 00 00 00
                body.rigidbody_rot_dim = 0.5f; // f[^F] // 00 00 00 00
                body.rigidbody_recoil = 0.0f; // f[^F // 00 00 00 00
                body.rigidbody_friction = 0.0f; // f[^FC // 00 00 00 00
                body.rigidbody_type = 1; // f[^F^Cv(0:BoneǏ]A1:ZA2:Z(Boneʒu)) // 00 // BoneǏ]
            }
        }

        private void SetParameter(List<PMD_Joint> joint_list)
        {
            foreach (PMD_Joint joint in joint_list)
            {
                joint.spring_rot.x = 200.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.y = 200.0f; // ΂ˁF](rad(x), rad(y), rad(z))
                joint.spring_rot.z = 200.0f; // ΂ˁF](rad(x), rad(y), rad(z))
            }
        }
    }
}
