require 'spec_helper'

describe Arc do
  #
  # site_code
  #
  it do
    arc = Arc.new(:key => 'up0675', :extname => 'zip')
    arc.site_code.should == 'up'
  end
  it do
    arc = Arc.new(:key => 'file0121', :extname => 'zip', :locked => 1)
    arc.site_code.should == 'file'
  end
  it do
    arc = Arc.new(:key => 'accs_0235', :extname => 'zip')
    arc.site_code.should == 'accs'
  end

  #
  # number
  #
  it do
    arc = Arc.new(:key => 'up0675', :extname => 'zip')
    arc.number.should == 675
  end
  it do
    arc = Arc.new(:key => 'up0621', :extname => 'zip', :locked => 1)
    arc.number.should == 621
  end
  it do
    arc = Arc.new(:key => 'accs_0235', :extname => 'zip')
    arc.number.should == 235
  end
end

describe Arc, "#url" do

  before do
    Fabricate(:site, :key => 'mmd', :url => "http://bytatsu.net/uploader/mikumikudance/")
    Fabricate(:site, :key => 'mmdfile', :url => "http://loda.jp/mmdfile/")
    Fabricate(:site, :key => 'mmdacc1', :url => "http://www9.atpages.jp/~mmdaccessory/uploader/")
    Fabricate(:site, :key => 'mmdacc2', :url => "http://www9.atpages.jp/~mmdaccessory/uploader2/")
  end

  it do
    arc = Arc.create(:key => 'up0675', :site => 'mmd', :extname => 'zip')
    arc.url.should == 'http://bytatsu.net/uploader/mikumikudance/src/up0675.zip'
  end
  it do
    arc = Arc.create(:key => 'up0679', :site => 'mmd', :extname => 'zip')
    arc.url.should == 'http://bytatsu.net/uploader/mikumikudance/src/up0679.zip'
  end
  it do
    arc = Arc.create(:key => 'up0464', :site => 'mmd', :extname => 'bmp')
    arc.url.should == 'http://bytatsu.net/uploader/mikumikudance/src/up0464.bmp'
  end
  it do
    arc = Arc.create(:key => 'up0621', :site => 'mmd', :extname => 'zip', :locked => 1)
    arc.url.should == 'http://bytatsu.net/uploader/mikumikudance/upload.cgi?mode=dl&file=621'
  end
  it do
    arc = Arc.create(:key => 'file0121', :site => 'mmdfile', :extname => 'zip')
    arc.url.should == 'http://loda.jp/mmdfile/?id=121'
  end
  it do
    arc = Arc.create(:key => 'file0120', :site => 'mmdfile', :extname => 'zip', :locked => 1)
    arc.url.should == 'http://loda.jp/mmdfile/?mode=pass&idd=120'
  end
  it do
    arc = Arc.create(:key => 'mini0910', :site => 'mmdacc1', :extname => 'zip')
    arc.url.should == "http://www9.atpages.jp/~mmdaccessory/uploader/log/910.zip"
  end
  it do
    arc = Arc.create(:key => 'accs_0235', :site => 'mmdacc2', :extname => 'zip', :locked => 1)
    arc.url.should == "http://www9.atpages.jp/~mmdaccessory/uploader2/src/MMDaccs_0235.zip.html"
  end
end
